/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.dom.Attribute;
import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.FormControlElement;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.NodeType;
import com.teamdev.jxbrowser.dom.OptionElement;
import com.teamdev.jxbrowser.dom.event.internal.EventTargetImpl;
import com.teamdev.jxbrowser.dom.internal.AttributeImpl;
import com.teamdev.jxbrowser.dom.internal.DocumentImpl;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.FormElementImpl;
import com.teamdev.jxbrowser.dom.internal.FrameElementImpl;
import com.teamdev.jxbrowser.dom.internal.InputElementImpl;
import com.teamdev.jxbrowser.dom.internal.NodeImpl;
import com.teamdev.jxbrowser.dom.internal.OptionElementImpl;
import com.teamdev.jxbrowser.dom.internal.SelectElementImpl;
import com.teamdev.jxbrowser.dom.internal.TextAreaElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.NodeId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public final class DomContext
extends CloseableImpl<DomContext> {
    private final Connection connection;
    private final FrameImpl frame;
    private final Map<NodeId, EventTargetImpl> eventTargetMap;

    public DomContext(Connection connection, FrameImpl frame) {
        this.connection = connection;
        this.frame = frame;
        this.eventTargetMap = new ConcurrentHashMap<NodeId, EventTargetImpl>();
    }

    public FrameImpl frame() {
        return this.frame;
    }

    public void addEventTarget(EventTargetImpl eventTarget) {
        this.eventTargetMap.put(eventTarget.nodeInfo().getNodeId(), eventTarget);
    }

    public void removeEventTarget(EventTargetImpl eventTarget) {
        this.eventTargetMap.remove(eventTarget.nodeInfo().getNodeId());
    }

    @Override
    public void close() {
        this.eventTargetMap.forEach((nodeId, eventTarget) -> eventTarget.close());
        super.close();
    }

    List<Node> toNodes(Iterable<NodeInfo> nodeInfos) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList<Node> result = new ArrayList<Node>();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> result.add(this.toNode((NodeInfo)nodeInfo)));
        return result;
    }

    List<Element> toElements(Iterable<NodeInfo> nodeInfos) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList<Element> result = new ArrayList<Element>();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> result.add(this.toElement((NodeInfo)nodeInfo)));
        return result;
    }

    List<Attribute> toAttributes(Iterable<NodeInfo> nodeInfos) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> result.add(this.toAttribute((NodeInfo)nodeInfo)));
        return result;
    }

    List<OptionElement> toOptionElements(Iterable<NodeInfo> nodeInfos) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList<OptionElement> result = new ArrayList<OptionElement>();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> {
            this.checkNodeIsElement((NodeInfo)nodeInfo);
            Optional tag = Tag.from(nodeInfo.getTagName());
            Preconditions.checkArgument(tag.isPresent());
            Preconditions.checkArgument(tag.get() == Tag.OPTION);
            result.add(this.toOptionElement((NodeInfo)nodeInfo));
        });
        return result;
    }

    public Document toDocument(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        EventTargetImpl eventTarget = this.existingEventTarget(nodeInfo).orElseGet(() -> new DocumentImpl(this.connection, this, nodeInfo));
        return Wrappers.unwrap(eventTarget, Document.class);
    }

    public Node toNode(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        if (nodeInfo.getNodeId().getValue() == 0) {
            return null;
        }
        if (nodeInfo.getNodeType() == NodeType.DOCUMENT_NODE) {
            return this.toDocument(nodeInfo);
        }
        if (nodeInfo.getNodeType() == NodeType.ELEMENT_NODE) {
            return this.toElement(nodeInfo);
        }
        if (nodeInfo.getNodeType() == NodeType.ATTRIBUTE_NODE) {
            return this.toAttribute(nodeInfo);
        }
        EventTargetImpl eventTarget = this.existingEventTarget(nodeInfo).orElseGet(() -> new NodeImpl(this.connection, this, nodeInfo));
        return Wrappers.unwrap(eventTarget, Node.class);
    }

    public Attribute toAttribute(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        if (nodeInfo.getNodeId().getValue() == 0) {
            return null;
        }
        this.checkNodeIsAttribute(nodeInfo);
        EventTargetImpl eventTarget = this.existingEventTarget(nodeInfo).orElseGet(() -> new AttributeImpl(this.connection, this, nodeInfo));
        return Wrappers.unwrap(eventTarget, Attribute.class);
    }

    private void checkNodeIsAttribute(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        Preconditions.checkArgument(nodeInfo.getNodeType() == NodeType.ATTRIBUTE_NODE);
    }

    public Element toElement(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        if (nodeInfo.getNodeId().getValue() == 0) {
            return null;
        }
        this.checkNodeIsElement(nodeInfo);
        return Tag.from(nodeInfo.getTagName()).map(tagValue -> {
            if (tagValue == Tag.FORM) {
                return this.toFormElement(nodeInfo);
            }
            if (tagValue == Tag.SELECT) {
                return this.toSelectElement(nodeInfo);
            }
            if (tagValue == Tag.OPTION) {
                return this.toOptionElement(nodeInfo);
            }
            if (tagValue == Tag.INPUT) {
                return this.toInputElement(nodeInfo);
            }
            if (tagValue == Tag.TEXT_AREA) {
                return this.toTextAreaElement(nodeInfo);
            }
            if (tagValue == Tag.FRAME || tagValue == Tag.IFRAME) {
                return this.toFrameElement(nodeInfo);
            }
            return Wrappers.unwrap(this.existingEventTarget(nodeInfo).orElseGet(() -> new ElementImpl(this.connection, this, nodeInfo)), ElementImpl.class);
        }).orElseGet(() -> Wrappers.unwrap(this.existingEventTarget(nodeInfo).orElseGet(() -> new ElementImpl(this.connection, this, nodeInfo)), ElementImpl.class));
    }

    List<FormControlElement> toFormControlElements(Iterable<NodeInfo> nodeInfos) {
        Preconditions.checkNotNull(nodeInfos);
        ArrayList<FormControlElement> result = new ArrayList<FormControlElement>();
        nodeInfos.spliterator().forEachRemaining(nodeInfo -> {
            this.checkNodeIsElement((NodeInfo)nodeInfo);
            Optional tag = Tag.from(nodeInfo.getTagName());
            Preconditions.checkArgument(tag.isPresent());
            result.add(this.toFormControlElement((NodeInfo)nodeInfo));
        });
        return result;
    }

    private Optional<EventTargetImpl> existingEventTarget(NodeInfo nodeInfo) {
        return Optional.ofNullable(this.eventTargetMap.get(nodeInfo.getNodeId()));
    }

    private FormControlElement toFormControlElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        Optional tag = Tag.from(nodeInfo.getTagName());
        if (tag.isPresent()) {
            Tag tagData = (Tag)((Object)tag.get());
            if (tagData == Tag.SELECT) {
                return this.toSelectElement(nodeInfo);
            }
            if (tagData == Tag.INPUT) {
                return this.toInputElement(nodeInfo);
            }
            if (tagData == Tag.TEXT_AREA) {
                return this.toTextAreaElement(nodeInfo);
            }
        }
        throw new IllegalArgumentException("The tag name of the given NodeInfo isn't supported.");
    }

    private void checkNodeIsElement(NodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        Preconditions.checkArgument(nodeInfo.getNodeType() == NodeType.ELEMENT_NODE);
    }

    private TextAreaElementImpl toTextAreaElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        return (TextAreaElementImpl)this.existingEventTarget(nodeInfo).orElseGet(() -> new TextAreaElementImpl(this.connection, this, nodeInfo));
    }

    private InputElementImpl toInputElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        return (InputElementImpl)this.existingEventTarget(nodeInfo).orElseGet(() -> new InputElementImpl(this.connection, this, nodeInfo));
    }

    private OptionElementImpl toOptionElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        return (OptionElementImpl)this.existingEventTarget(nodeInfo).orElseGet(() -> new OptionElementImpl(this.connection, this, nodeInfo));
    }

    private SelectElementImpl toSelectElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        return (SelectElementImpl)this.existingEventTarget(nodeInfo).orElseGet(() -> new SelectElementImpl(this.connection, this, nodeInfo));
    }

    FormElementImpl toFormElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        return (FormElementImpl)this.existingEventTarget(nodeInfo).orElseGet(() -> new FormElementImpl(this.connection, this, nodeInfo));
    }

    private FrameElementImpl toFrameElement(NodeInfo nodeInfo) {
        this.checkNodeIsElement(nodeInfo);
        return (FrameElementImpl)this.existingEventTarget(nodeInfo).orElseGet(() -> new FrameElementImpl(this.connection, this, nodeInfo));
    }

    private static enum Tag {
        FORM("form"),
        SELECT("select"),
        OPTION("option"),
        INPUT("input"),
        TEXT_AREA("textarea"),
        FRAME("frame"),
        IFRAME("iframe");

        private final String tagName;

        private Tag(String tagName) {
            this.tagName = tagName;
        }

        private String tagName() {
            return this.tagName;
        }

        private static Optional<Tag> from(String tagName) {
            return Stream.of(Tag.values()).filter(value -> value.tagName().equalsIgnoreCase(tagName)).findFirst();
        }
    }
}

