/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.event.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.event.Event;
import com.teamdev.jxbrowser.dom.event.EventPhase;
import com.teamdev.jxbrowser.dom.event.EventTarget;
import com.teamdev.jxbrowser.dom.event.EventType;
import com.teamdev.jxbrowser.dom.event.internal.EventImpl;
import com.teamdev.jxbrowser.dom.event.internal.KeyEventImpl;
import com.teamdev.jxbrowser.dom.event.internal.MouseEventImpl;
import com.teamdev.jxbrowser.dom.event.internal.WheelEventImpl;
import com.teamdev.jxbrowser.dom.event.internal.rpc.AddEventListenerRequest;
import com.teamdev.jxbrowser.dom.event.internal.rpc.DispatchEventRequest;
import com.teamdev.jxbrowser.dom.event.internal.rpc.EventParams;
import com.teamdev.jxbrowser.dom.event.internal.rpc.EventTargetInfo;
import com.teamdev.jxbrowser.dom.event.internal.rpc.EventTargetStub;
import com.teamdev.jxbrowser.dom.event.internal.rpc.MouseEventParams;
import com.teamdev.jxbrowser.dom.event.internal.rpc.ProcessEvent;
import com.teamdev.jxbrowser.dom.event.internal.rpc.RemoveEventListenerRequest;
import com.teamdev.jxbrowser.dom.internal.DomContext;
import com.teamdev.jxbrowser.dom.internal.callback.ProcessEventCallback;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.internal.ThreadUtil;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.EventId;
import com.teamdev.jxbrowser.internal.rpc.EventListenerId;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.NodeId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class EventTargetImpl
extends JsObjectImpl
implements EventTarget {
    private final NodeInfo nodeInfo;
    private final DomContext domContext;
    private final NewServiceConnection<EventTargetStub> rpc;
    private final Map<EventListenerType, EventListener> eventListenerMap;

    protected EventTargetImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext.frame().jsContext(), nodeInfo.getJsObjectId());
        Preconditions.checkNotNull(domContext);
        Preconditions.checkNotNull(nodeInfo);
        Preconditions.checkArgument(nodeInfo.getNodeId().getValue() != 0);
        this.nodeInfo = nodeInfo;
        this.domContext = domContext;
        this.eventListenerMap = new ConcurrentHashMap<EventListenerType, EventListener>();
        EventTargetInfo eventTargetInfo = EventTargetInfo.newBuilder().setFrameId(domContext.frame().id()).setNodeId(nodeInfo.getNodeId()).build();
        this.rpc = new NewServiceConnection<EventTargetStub>(eventTargetInfo, connection, EventTargetStub::new);
        domContext.addEventTarget(this);
    }

    protected FrameId frameId() {
        return this.domContext.frame().id();
    }

    public final NodeInfo nodeInfo() {
        return this.nodeInfo;
    }

    protected NodeId nodeId() {
        return this.nodeInfo().getNodeId();
    }

    protected DomContext domContext() {
        return this.domContext;
    }

    private EventImpl<? extends com.teamdev.jxbrowser.dom.event.EventParams> createEvent(ProcessEvent.Request params) {
        EventId eventId = params.getEventId();
        Node target = this.domContext.toNode(params.getTarget());
        Node currentTarget = this.domContext.toNode(params.getCurrentTarget());
        switch (params.getKindCase()) {
            case KEY_EVENT: {
                return new KeyEventImpl(this.domContext, eventId, (EventType)params.getEventType(), (EventTarget)target, (EventTarget)currentTarget, params.getEventPhase(), params.getKeyEvent());
            }
            case MOUSE_EVENT: {
                return new MouseEventImpl<MouseEventParams>(this.domContext, eventId, params.getEventType(), target, currentTarget, params.getEventPhase(), params.getMouseEvent());
            }
            case WHEEL_EVENT: {
                return new WheelEventImpl(this.domContext, eventId, (EventType)params.getEventType(), (EventTarget)target, (EventTarget)currentTarget, params.getEventPhase(), params.getWheelEvent());
            }
        }
        return new EventImpl<EventParams>(this.domContext, eventId, params.getEventType(), target, currentTarget, params.getEventPhase(), params.getEvent());
    }

    @Override
    public List<Observer<Event>> eventListeners(EventType eventType, boolean useCapture) {
        EventPhase eventPhase = useCapture ? EventPhase.CAPTURING_PHASE : EventPhase.BUBBLING_PHASE;
        return new ArrayList<Observer<Event>>(this.eventListeners(eventType, eventPhase));
    }

    private Set<Observer<Event>> eventListeners(EventType eventType, EventPhase eventPhase) {
        HashSet<Observer<Event>> result = new HashSet<Observer<Event>>();
        if (eventPhase.equals(EventPhase.AT_TARGET)) {
            EventListenerType bubblingType = new EventListenerType(eventType, EventPhase.BUBBLING_PHASE);
            EventListenerType capturingType = new EventListenerType(eventType, EventPhase.CAPTURING_PHASE);
            if (this.eventListenerMap.containsKey(bubblingType)) {
                result.addAll(this.eventListenerMap.get((Object)bubblingType).observers);
            }
            if (this.eventListenerMap.containsKey(capturingType)) {
                result.addAll(this.eventListenerMap.get((Object)capturingType).observers);
            }
        } else {
            Optional.ofNullable(this.eventListenerMap.get(new EventListenerType(eventType, eventPhase))).ifPresent(eventListener -> result.addAll(eventListener.observers));
        }
        return result;
    }

    private void registerProcessEventCallback() {
        this.rpc.set(ProcessEventCallback.class, params -> {
            EventPhase eventPhase = params.getEventPhase();
            com.teamdev.jxbrowser.dom.event.internal.rpc.EventType eventType = params.getEventType();
            Set<Observer<Event>> listeners = this.eventListeners((EventType)eventType, eventPhase);
            if (!listeners.isEmpty()) {
                EventImpl<? extends com.teamdev.jxbrowser.dom.event.EventParams> event = this.createEvent((ProcessEvent.Request)params);
                for (Observer<Event> listener : listeners) {
                    try {
                        listener.on(event);
                    }
                    catch (Exception e) {
                        ThreadUtil.reportException(e);
                        Logger.warn("An exception has been thrown during listeners notification", e);
                    }
                }
                event.close();
            }
            return ProcessEvent.Response.newBuilder().build();
        });
    }

    private void unregisterProcessEventCallback() {
        this.rpc.remove(ProcessEventCallback.class);
    }

    @Override
    public void close() {
        this.domContext.removeEventTarget(this);
        this.rpc.close();
        super.close();
    }

    @Override
    public final void addEventListener(EventType eventType, Observer<Event> listener, boolean useCapture) {
        EventPhase eventPhase;
        EventListenerType type;
        Preconditions.checkNotNull(eventType);
        Preconditions.checkNotNull(listener);
        this.checkNotClosed();
        if (this.eventListenerMap.isEmpty()) {
            this.registerProcessEventCallback();
        }
        if (this.eventListenerMap.containsKey(type = new EventListenerType(eventType, eventPhase = useCapture ? EventPhase.CAPTURING_PHASE : EventPhase.BUBBLING_PHASE))) {
            EventListener eventListener = this.eventListenerMap.get(type);
            eventListener.observers.add(listener);
            return;
        }
        AddEventListenerRequest request = AddEventListenerRequest.newBuilder().setEventTargetInfo(EventTargetInfo.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build()).setEventType(Wrappers.unwrap(eventType, com.teamdev.jxbrowser.dom.event.internal.rpc.EventType.class)).setUseCapture(useCapture).build();
        EventListenerId id = (EventListenerId)this.rpc.invoke(this.rpc.stub()::addEventListener, request);
        EventListener eventListener = new EventListener(id, listener);
        this.eventListenerMap.put(type, eventListener);
    }

    @Override
    public final void removeEventListener(EventType eventType, Observer<Event> listener, boolean useCapture) {
        Preconditions.checkNotNull(eventType);
        Preconditions.checkNotNull(listener);
        this.checkNotClosed();
        EventPhase eventPhase = useCapture ? EventPhase.CAPTURING_PHASE : EventPhase.BUBBLING_PHASE;
        EventListenerType type = new EventListenerType(eventType, eventPhase);
        if (!this.eventListenerMap.containsKey(type)) {
            return;
        }
        EventListener eventListener = this.eventListenerMap.get(type);
        eventListener.observers.remove(listener);
        if (eventListener.observers.isEmpty()) {
            RemoveEventListenerRequest request = RemoveEventListenerRequest.newBuilder().setEventTargetInfo(EventTargetInfo.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build()).setEventType(Wrappers.unwrap(eventType, com.teamdev.jxbrowser.dom.event.internal.rpc.EventType.class)).setUseCapture(useCapture).setEventListenerId(eventListener.id).build();
            this.rpc.invoke(this.rpc.stub()::removeEventListener, request);
            this.eventListenerMap.remove(type);
        }
        if (this.eventListenerMap.isEmpty()) {
            this.unregisterProcessEventCallback();
        }
    }

    @Override
    public final boolean dispatch(Event event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        DispatchEventRequest request = DispatchEventRequest.newBuilder().setEventTargetInfo(EventTargetInfo.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build()).setEventId(((EventImpl)event).id()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::dispatchEvent, request)).getValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventTargetImpl that = (EventTargetImpl)o;
        return Objects.equals(this.nodeInfo, that.nodeInfo) && Objects.equals(this.domContext, that.domContext);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodeInfo, this.domContext);
    }

    private static class EventListener {
        public final EventListenerId id;
        public final List<Observer<Event>> observers;

        public EventListener(EventListenerId id, Observer<Event> observer) {
            this.id = id;
            this.observers = new CopyOnWriteArrayList<Observer<Event>>();
            this.observers.add(observer);
        }
    }

    private static class EventListenerType {
        public final EventType eventType;
        public final EventPhase eventPhase;

        public EventListenerType(EventType eventType, EventPhase eventPhase) {
            this.eventType = eventType;
            this.eventPhase = eventPhase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventListenerType that = (EventListenerType)o;
            return this.eventType.equals(that.eventType) && this.eventPhase == that.eventPhase;
        }

        public int hashCode() {
            return Objects.hash(this.eventType, this.eventPhase);
        }
    }
}

