/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.event.internal;

import com.teamdev.jxbrowser.dom.event.Event;
import com.teamdev.jxbrowser.dom.event.EventParams;
import com.teamdev.jxbrowser.dom.event.EventPhase;
import com.teamdev.jxbrowser.dom.event.EventTarget;
import com.teamdev.jxbrowser.dom.event.EventType;
import com.teamdev.jxbrowser.dom.event.internal.rpc.EventStub;
import com.teamdev.jxbrowser.dom.event.internal.rpc.PreventDefaultRequest;
import com.teamdev.jxbrowser.dom.event.internal.rpc.StopPropagationRequest;
import com.teamdev.jxbrowser.dom.internal.DomContext;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.EventId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.util.Optional;
import javax.annotation.Nullable;

public class EventImpl<T extends EventParams>
extends CloseableImpl
implements Event {
    private final EventId eventId;
    private final EventType eventType;
    private final EventTarget target;
    private final EventTarget currentTarget;
    private final EventPhase eventPhase;
    private final T eventParams;
    private final DomContext domContext;
    private final NewServiceConnection<EventStub> rpc;

    EventImpl(DomContext domContext, EventId eventId, EventType eventType, @Nullable EventTarget target, @Nullable EventTarget currentTarget, EventPhase eventPhase, T eventParams) {
        this.domContext = domContext;
        this.eventId = eventId;
        this.eventType = eventType;
        this.target = target;
        this.currentTarget = currentTarget;
        this.eventPhase = eventPhase;
        this.eventParams = eventParams;
        Connection connection = domContext.frame().renderProcess().connection();
        this.rpc = new NewServiceConnection<EventStub>(eventId, connection, EventStub::new);
    }

    public EventImpl(DomContext domContext, EventId eventId, EventType eventType, T eventParams) {
        this.domContext = domContext;
        this.eventId = eventId;
        this.eventType = eventType;
        this.target = null;
        this.currentTarget = null;
        this.eventPhase = null;
        this.eventParams = eventParams;
        Connection connection = domContext.frame().renderProcess().connection();
        this.rpc = new NewServiceConnection<EventStub>(eventId, connection, EventStub::new);
    }

    public final EventId id() {
        return this.eventId;
    }

    @Override
    public final EventType type() {
        return this.eventType;
    }

    @Override
    public final Optional<EventTarget> target() {
        return Optional.ofNullable(this.target);
    }

    @Override
    public final Optional<EventTarget> currentTarget() {
        return Optional.ofNullable(this.currentTarget);
    }

    @Override
    public final EventPhase phase() {
        return this.eventPhase;
    }

    @Override
    public final boolean isBubbles() {
        return this.eventParams.isBubbles();
    }

    @Override
    public final boolean isCancelable() {
        return this.eventParams.isCancelable();
    }

    @Override
    public final void preventDefault() {
        this.checkNotClosed();
        PreventDefaultRequest request = PreventDefaultRequest.newBuilder().setFrameId(this.domContext.frame().id()).setEventId(this.eventId).build();
        this.rpc.invoke(this.rpc.stub()::preventDefault, request);
    }

    @Override
    public final void stopPropagation() {
        this.checkNotClosed();
        StopPropagationRequest request = StopPropagationRequest.newBuilder().setFrameId(this.domContext.frame().id()).setEventId(this.eventId).build();
        this.rpc.invoke(this.rpc.stub()::stopPropagation, request);
    }

    T eventParams() {
        return this.eventParams;
    }
}

