/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.event;

import com.teamdev.jxbrowser.dom.event.MouseEvent;
import com.teamdev.jxbrowser.dom.event.WheelEvent;
import com.teamdev.jxbrowser.dom.event.internal.rpc.MouseEventParams;
import com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.Point;

public interface WheelEventParams
extends com.teamdev.jxbrowser.dom.event.MouseEventParams {
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    default public boolean isBubbles() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().getUiEventModifiersParams().isBubbles();
    }

    @Override
    default public boolean isCancelable() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().getUiEventModifiersParams().isCancelable();
    }

    @Override
    default public Point clientLocation() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().getClientLocation();
    }

    @Override
    default public Point screenLocation() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().getScreenLocation();
    }

    @Override
    default public MouseEvent.Button button() {
        return MouseEvent.Button.of(((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().getButton());
    }

    @Override
    default public int clickCount() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().clickCount();
    }

    default public double deltaX() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getDeltaX();
    }

    default public double deltaY() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getDeltaY();
    }

    default public WheelEvent.DeltaMode deltaMode() {
        return WheelEvent.DeltaMode.of(((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getDeltaMode().getNumber());
    }

    @Override
    default public KeyModifiers keyModifiers() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this).getMouseParams().keyModifiers();
    }

    public static final class Builder {
        private final WheelEventParams.Builder builder = com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams.newBuilder();

        private Builder() {
        }

        public Builder mouseEventParams(com.teamdev.jxbrowser.dom.event.MouseEventParams mouseEventParams) {
            Preconditions.checkNotNull(mouseEventParams);
            this.builder.setMouseParams((MouseEventParams)mouseEventParams);
            return this;
        }

        public Builder deltaX(double deltaX) {
            this.builder.setDeltaX(deltaX);
            return this;
        }

        public Builder deltaY(double deltaY) {
            this.builder.setDeltaY(deltaY);
            return this;
        }

        public Builder deltaMode(WheelEvent.DeltaMode mode) {
            this.builder.setDeltaMode(WheelEventParams.DeltaMode.forNumber(mode.mode()));
            return this;
        }

        public WheelEventParams build() {
            return this.builder.build();
        }
    }
}

