/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cookie.internal;

import com.teamdev.jxbrowser.cookie.Cookie;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.cookie.internal.rpc.CookieList;
import com.teamdev.jxbrowser.cookie.internal.rpc.CookieStoreStub;
import com.teamdev.jxbrowser.cookie.internal.rpc.SetCookieRequest;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Int32Value;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.Collections;
import java.util.List;

public final class CookieStoreImpl
extends CloseableImpl
implements CookieStore {
    private final NewServiceConnection<CookieStoreStub> rpc;

    public CookieStoreImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.rpc = new NewServiceConnection<CookieStoreStub>(engine.id(), engine.connection(), CookieStoreStub::new);
    }

    @Override
    public List<Cookie> cookies() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((CookieList)this.rpc.invoke(this.rpc.stub()::getAllCookies, ProtobufUtil.empty())).getCookieList());
    }

    @Override
    public List<Cookie> cookies(String url) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        return Collections.unmodifiableList(((CookieList)this.rpc.invoke(this.rpc.stub()::getAllCookiesByUrl, StringValue.of(url))).getCookieList());
    }

    @Override
    public boolean delete(Cookie cookie) {
        Preconditions.checkNotNull(cookie);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::deleteCookie, (Message)Wrappers.unwrap(cookie, com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.class))).getValue();
    }

    @Override
    public int deleteAll() {
        this.checkNotClosed();
        return ((Int32Value)this.rpc.invoke(this.rpc.stub()::deleteAllCookies, ProtobufUtil.empty())).getValue();
    }

    @Override
    public boolean put(String url, Cookie cookie) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        Preconditions.checkNotNull(cookie);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setCookie, SetCookieRequest.newBuilder().setUrl(url).setCookie(Wrappers.unwrap(cookie, com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.class)).build())).getValue();
    }

    @Override
    public void persist() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::save, ProtobufUtil.empty());
    }
}

