/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cookie;

import com.teamdev.jxbrowser.cookie.internal.rpc.Cookie;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.time.internal.rpc.Timestamp;

public interface Cookie {
    public static Builder newBuilder() {
        return new Builder();
    }

    default public String name() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getName();
    }

    default public String value() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getValue();
    }

    default public String domain() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getDomain();
    }

    default public String path() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getPath();
    }

    default public boolean isSecure() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getSecure();
    }

    default public boolean isHttpOnly() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getHttpOnly();
    }

    default public com.teamdev.jxbrowser.time.Timestamp creationTime() {
        return ((com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this).getCreationTime();
    }

    default public com.teamdev.jxbrowser.time.Timestamp expirationTime() {
        com.teamdev.jxbrowser.cookie.internal.rpc.Cookie rawCookie = (com.teamdev.jxbrowser.cookie.internal.rpc.Cookie)this;
        if (rawCookie.hasExpirationTime()) {
            return rawCookie.getExpirationTime();
        }
        return com.teamdev.jxbrowser.time.Timestamp.NONE;
    }

    public static final class Builder {
        private final Cookie.Builder builder = com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.newBuilder();

        private Builder() {
            this.creationTime(com.teamdev.jxbrowser.time.Timestamp.fromMillis(System.currentTimeMillis()));
        }

        public Builder name(String name) {
            Preconditions.checkNotNull(name);
            this.builder.setName(name);
            return this;
        }

        public Builder value(String value) {
            Preconditions.checkNotNull(value);
            this.builder.setValue(value);
            return this;
        }

        public Builder domain(String domain) {
            Preconditions.checkNotNull(domain);
            this.builder.setDomain(domain);
            return this;
        }

        public Builder path(String path) {
            Preconditions.checkNotNull(path);
            this.builder.setPath(path);
            return this;
        }

        public Builder secure(boolean secure) {
            this.builder.setSecure(secure);
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.builder.setHttpOnly(httpOnly);
            return this;
        }

        public Builder creationTime(com.teamdev.jxbrowser.time.Timestamp creationTime) {
            Preconditions.checkNotNull(creationTime);
            this.builder.setCreationTime((Timestamp)creationTime);
            return this;
        }

        public Builder expirationTime(com.teamdev.jxbrowser.time.Timestamp expirationTime) {
            Preconditions.checkNotNull(expirationTime);
            this.builder.setExpirationTime((Timestamp)expirationTime);
            return this;
        }

        public Cookie build() {
            return this.builder.build();
        }
    }
}

