/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.callback.internal;

import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.callback.Callback;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class CallbackUtil {
    public static <C extends Callback> Class<?> determineRequestClass(Class<C> callbackClass) {
        Type[] genericInterfaces = callbackClass.getGenericInterfaces();
        ParameterizedType type = (ParameterizedType)genericInterfaces[0];
        Type actualType = type.getActualTypeArguments()[0];
        return (Class)actualType;
    }

    private CallbackUtil() {
    }

    public static <C extends Callback> Class determineActionClass(Class<C> callbackClass) {
        Class<?>[] declaredClasses;
        for (Class<?> declaredClass : declaredClasses = callbackClass.getDeclaredClasses()) {
            if (!AsyncCallbackAction.class.isAssignableFrom(declaredClass)) continue;
            return declaredClass;
        }
        throw new IllegalArgumentException("Failed to determine action class.");
    }
}

