/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.callback.internal;

import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.Invoker;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class CallbackManager
implements Advisable<Callback> {
    private final Set<Invoker> invokers = new HashSet<Invoker>();

    public void addInvoker(Invoker invoker) {
        this.invokers.add(invoker);
    }

    @Override
    public <C extends Callback> C set(Class<C> callbackClass, C callback) {
        Preconditions.checkNotNull(callbackClass);
        Preconditions.checkNotNull(callback);
        return this.findInvoker(callbackClass).orElseThrow(IllegalStateException::new).set(callbackClass, callback);
    }

    @Override
    public <C extends Callback> Optional<C> get(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        return this.findInvoker(callbackClass).orElseThrow(() -> new IllegalStateException("Unregistered callback: " + callbackClass)).get(callbackClass);
    }

    @Override
    public <C extends Callback> C remove(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        return this.findInvoker(callbackClass).orElseThrow(IllegalStateException::new).remove(callbackClass);
    }

    private <C extends Callback> Optional<Invoker> findInvoker(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        for (Invoker invoker : this.invokers) {
            if (!invoker.invokes(callbackClass)) continue;
            return Optional.of(invoker);
        }
        return Optional.empty();
    }
}

