/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.callback;

import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.function.Consumer;

public abstract class AsyncCallbackAction<R> {
    private final CloseableImpl closable;
    private final Consumer<R> consumer;

    protected AsyncCallbackAction(Consumer<R> consumer) {
        this.consumer = consumer;
        this.closable = new CloseableImpl();
    }

    protected final void send(R response) {
        Preconditions.checkState(!this.isClosed(), "The action is closed");
        this.consumer.accept(response);
        this.closable.close();
    }

    public final boolean isClosed() {
        return this.closable.isClosed();
    }
}

