/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.event.internal.WindowedWidgetEvent;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.rpc.Bounds;
import com.teamdev.jxbrowser.browser.internal.rpc.Display;
import com.teamdev.jxbrowser.browser.internal.rpc.ParentWindow;
import com.teamdev.jxbrowser.browser.internal.rpc.WindowedWidgetStub;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.DisplayId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;

public class WindowedWidget
extends CloseableImpl<WindowedWidget>
implements Observable<WindowedWidgetEvent> {
    private final BrowserImpl browser;
    private final NewServiceConnection<WindowedWidgetStub> rpc;

    public WindowedWidget(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.rpc = new NewServiceConnection<WindowedWidgetStub>(browser.id(), browser.engine().connection(), WindowedWidgetStub::new);
    }

    public void focus() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::focus, this.browser.id());
    }

    public void unfocus() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::unfocus, this.browser.id());
    }

    public void attach(long windowHandle) {
        this.checkNotClosed();
        Preconditions.checkArgument(windowHandle != 0L, "Invalid window handle.");
        ParentWindow request = ParentWindow.newBuilder().setBrowserId(this.browser.id()).setWindowHandle(windowHandle).build();
        this.rpc.invokeAsync(this.rpc.stub()::attach, request);
    }

    public void detach() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::detach, this.browser.id());
    }

    public void minimize() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::minimize, this.browser.id());
    }

    public void restore() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::restore, this.browser.id());
    }

    public void displayId(String displayId) {
        Preconditions.checkNotNullEmptyOrBlank(displayId);
        this.checkNotClosed();
        Display request = Display.newBuilder().setBrowserId(this.browser.id()).setDisplayId(DisplayId.newBuilder().setValue(displayId).build()).build();
        this.rpc.invokeAsync(this.rpc.stub()::setDisplay, request);
    }

    public void bounds(com.teamdev.jxbrowser.ui.Rect rect) {
        this.checkNotClosed();
        Bounds request = Bounds.newBuilder().setBrowserId(this.browser.id()).setWidgetBounds(Wrappers.unwrap(rect, Rect.class)).build();
        this.rpc.invokeAsync(this.rpc.stub()::setBounds, request);
    }

    public void boundsOnScreen(com.teamdev.jxbrowser.ui.Rect rect) {
        this.checkNotClosed();
        Bounds request = Bounds.newBuilder().setBrowserId(this.browser.id()).setWidgetBounds(Wrappers.unwrap(rect, Rect.class)).build();
        this.rpc.invokeAsync(this.rpc.stub()::setBoundsInScreen, request);
    }

    @Override
    public <E extends WindowedWidgetEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

