/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.event.internal.RenderWidgetsEvent;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogRenderWidgetCreated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogRenderWidgetDeleted;
import com.teamdev.jxbrowser.browser.internal.rpc.FullScreenRenderWidgetCreated;
import com.teamdev.jxbrowser.browser.internal.rpc.FullScreenRenderWidgetDeleted;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderWidgetCreated;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderWidgetDeleted;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderWidgetsStub;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.RenderWidgetId;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class RenderWidgets
extends CloseableImpl<RenderWidgets>
implements Observable<RenderWidgetsEvent> {
    private final List<RenderWidget> renderWidgets = new CopyOnWriteArrayList<RenderWidget>();
    private final NewServiceConnection<RenderWidgetsStub> rpc;

    RenderWidgets(BrowserImpl browser) {
        this.rpc = new NewServiceConnection<RenderWidgetsStub>(browser.id(), browser.engine().connection(), RenderWidgetsStub::new);
        this.rpc.setPreProcessor(RenderWidgetCreated.class, event -> this.add(new RenderWidget(browser, event.getRenderWidgetId())));
        this.rpc.setPreProcessor(RenderWidgetDeleted.class, event -> this.renderWidget(event.getRenderWidgetId()).ifPresent(this::remove));
        this.rpc.setPreProcessor(DialogRenderWidgetCreated.class, event -> this.add(new RenderWidget(browser, event.getRenderWidgetId())));
        this.rpc.setPreProcessor(DialogRenderWidgetDeleted.class, event -> this.renderWidget(event.getRenderWidgetId()).ifPresent(this::remove));
        this.rpc.setPreProcessor(FullScreenRenderWidgetCreated.class, event -> this.add(new RenderWidget(browser, event.getRenderWidgetId())));
        this.rpc.setPreProcessor(FullScreenRenderWidgetDeleted.class, event -> this.renderWidget(event.getRenderWidgetId()).ifPresent(this::remove));
    }

    @Override
    public void close() {
        this.renderWidgets.forEach(this::remove);
        this.rpc.close();
        super.close();
    }

    private void add(RenderWidget renderWidget) {
        if (!this.renderWidgets.contains(renderWidget)) {
            this.renderWidgets.add(renderWidget);
        }
    }

    private void remove(RenderWidget renderWidget) {
        this.renderWidgets.remove(renderWidget);
        renderWidget.close();
    }

    public Optional<RenderWidget> activeRenderWidget() {
        if (!this.renderWidgets.isEmpty()) {
            return Optional.of(this.renderWidgets.get(this.renderWidgets.size() - 1));
        }
        return Optional.empty();
    }

    public Optional<RenderWidget> renderWidget(RenderWidgetId renderWidgetId) {
        for (RenderWidget renderWidget : this.list()) {
            if (!renderWidget.id().equals(renderWidgetId)) continue;
            return Optional.of(renderWidget);
        }
        return Optional.empty();
    }

    private List<RenderWidget> list() {
        return Collections.unmodifiableList(this.renderWidgets);
    }

    @Override
    public <E extends RenderWidgetsEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

