/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.callback.BrowserSyncCallback;
import com.teamdev.jxbrowser.browser.callback.input.EnterMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.ExitMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveMouseWheelCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.ReleaseKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.ReleaseMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.TypeKeyCallback;
import com.teamdev.jxbrowser.browser.event.internal.RenderWidgetClosing;
import com.teamdev.jxbrowser.browser.event.internal.RenderWidgetEvent;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.callback.RenderWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragDropRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragEndRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragEnterRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragLeaveRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOverRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.browser.internal.rpc.KeyPressRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.KeyReleaseRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.KeyTypeRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseDragRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseEnterRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseExitRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseMoveRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MousePressRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseReleaseRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseWheelRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderWidgetBounds;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderWidgetStub;
import com.teamdev.jxbrowser.browser.internal.rpc.SetDisplayRequest;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.CustomEventSource;
import com.teamdev.jxbrowser.event.internal.EventSource;
import com.teamdev.jxbrowser.event.internal.EventSourceManager;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.RenderWidgetId;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.internal.util.ReflectionUtil;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.event.internal.rpc.EnterMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.ExitMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyReleased;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseEntered;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseExited;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseMoved;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseReleased;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveMouseWheel;
import com.teamdev.jxbrowser.ui.event.internal.rpc.PressKey;
import com.teamdev.jxbrowser.ui.event.internal.rpc.PressMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.ReleaseKey;
import com.teamdev.jxbrowser.ui.event.internal.rpc.ReleaseMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TypeKey;
import com.teamdev.jxbrowser.ui.internal.MacEditorCommand;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;

public final class RenderWidget
extends CloseableImpl
implements Observable<RenderWidgetEvent>,
Advisable<RenderWidgetCallback> {
    private final BrowserImpl browser;
    private final RenderWidgetId renderWidgetId;
    private final NewServiceConnection<RenderWidgetStub> rpc;
    private final EventSource<RenderWidgetEvent> eventSource;
    private final EventSourceManager eventSourceManager;

    public RenderWidget(BrowserImpl browser, RenderWidgetId renderWidgetId) {
        Preconditions.checkNotNull(browser);
        Preconditions.checkNotNull(renderWidgetId);
        this.browser = browser;
        this.renderWidgetId = renderWidgetId;
        this.rpc = new NewServiceConnection<RenderWidgetStub>(renderWidgetId, browser.engine().connection(), RenderWidgetStub::new);
        this.eventSource = new CustomEventSource<RenderWidgetEvent>(RenderWidgetClosing.class);
        this.eventSourceManager = new EventSourceManager();
        this.eventSourceManager.addEventSource(this.rpc);
        this.eventSourceManager.addEventSource(this.eventSource);
    }

    public RenderWidgetId id() {
        return this.renderWidgetId;
    }

    public BrowserImpl browser() {
        return this.browser;
    }

    public void focus() {
        this.rpc.invokeAsync(this.rpc.stub()::focus, this.renderWidgetId);
    }

    public void unfocus() {
        this.rpc.invokeAsync(this.rpc.stub()::unfocus, this.renderWidgetId);
    }

    public void show() {
        this.rpc.invokeAsync(this.rpc.stub()::show, this.renderWidgetId);
    }

    public void hide() {
        this.rpc.invokeAsync(this.rpc.stub()::hide, this.renderWidgetId);
    }

    public void minimize() {
        this.rpc.invokeAsync(this.rpc.stub()::minimize, this.renderWidgetId);
    }

    public void restore() {
        this.rpc.invokeAsync(this.rpc.stub()::restore, this.renderWidgetId);
    }

    public void resize(Size size) {
        Preconditions.checkNotNull(size);
        this.bounds(Rect.of(size));
    }

    public void bounds(Rect bounds) {
        Preconditions.checkNotNull(bounds);
        this.checkNotClosed();
        RenderWidgetBounds request = RenderWidgetBounds.newBuilder().setRenderWidgetId(this.renderWidgetId).setBounds(Wrappers.unwrap(bounds, com.teamdev.jxbrowser.ui.internal.rpc.Rect.class)).build();
        this.rpc.invokeAsync(this.rpc.stub()::setBounds, request);
    }

    public void boundsInScreen(Rect bounds) {
        Preconditions.checkNotNull(bounds);
        this.checkNotClosed();
        RenderWidgetBounds request = RenderWidgetBounds.newBuilder().setRenderWidgetId(this.renderWidgetId).setBounds(Wrappers.unwrap(bounds, com.teamdev.jxbrowser.ui.internal.rpc.Rect.class)).build();
        this.rpc.invokeAsync(this.rpc.stub()::setBoundsInScreen, request);
    }

    public void displayId(String displayId) {
        Preconditions.checkNotNullEmptyOrBlank(displayId);
        this.checkNotClosed();
        SetDisplayRequest request = SetDisplayRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setDisplayId(displayId).build();
        this.rpc.invokeAsync(this.rpc.stub()::setDisplay, request);
    }

    private <C extends BrowserSyncCallback, M, E> boolean suppress(Class<C> callbackClass, Class<M> messageClass, E event) {
        if (!Environment.isMac() && this.browser.engine().options().renderingMode() == RenderingMode.HARDWARE_ACCELERATED) {
            return false;
        }
        return this.browser.get(callbackClass).map(callback -> {
            RpcThread rpcThread = this.rpc.connection().rpcThread();
            Supplier<Boolean> task = () -> {
                Class<?> requestClass = ReflectionUtil.findDeclaredClass(messageClass, "Request").orElseThrow(() -> new IllegalArgumentException("The callback class does not declare 'Request' class: " + callbackClass));
                Class<?> responseClass = ReflectionUtil.findDeclaredClass(messageClass, "Response").orElseThrow(() -> new IllegalArgumentException("The callback class does not declare 'Response' class: " + callbackClass));
                Method newBuilder = ReflectionUtil.getMethod(requestClass, "newBuilder", new Class[0]);
                Object builder = ReflectionUtil.invoke(null, newBuilder, new Object[0]);
                Method setEvent = ReflectionUtil.getMethod(builder.getClass(), "setEvent", event.getClass());
                ReflectionUtil.invoke(builder, setEvent, event);
                Method build = ReflectionUtil.getMethod(builder.getClass(), "build", new Class[0]);
                Object params = ReflectionUtil.invoke(builder, build, new Object[0]);
                Object response = callback.on(params);
                if (response != null) {
                    Method getSuppress = ReflectionUtil.getMethod(responseClass, "getSuppress", new Class[0]);
                    return (Boolean)ReflectionUtil.invoke(response, getSuppress, new Object[0]);
                }
                return false;
            };
            try {
                return rpcThread.isCurrentlyOn() ? task.get() : rpcThread.execute(task);
            }
            catch (Exception e) {
                Logger.error("An exception occurred during processing the callback.", e);
                return false;
            }
        }).orElse(false);
    }

    public void dispatch(KeyPressed event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        com.teamdev.jxbrowser.ui.event.internal.rpc.KeyPressed keyPressed = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.KeyPressed.class);
        if (this.suppress(PressKeyCallback.class, PressKey.class, keyPressed)) {
            return;
        }
        KeyPressRequest request = KeyPressRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setKeyPressed(keyPressed).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardKeyPress, request);
        if (Environment.isMac()) {
            MacEditorCommand.of(event).ifPresent(editorCommand -> this.browser.focusedFrame().ifPresent(focusedFrame -> focusedFrame.execute((EditorCommand)editorCommand)));
        }
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.KeyReleased event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        KeyReleased keyReleased = Wrappers.unwrap(event, KeyReleased.class);
        if (this.suppress(ReleaseKeyCallback.class, ReleaseKey.class, keyReleased)) {
            return;
        }
        KeyReleaseRequest request = KeyReleaseRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setKeyReleased(keyReleased).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardKeyRelease, request);
    }

    public void dispatch(KeyTyped event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        com.teamdev.jxbrowser.ui.event.internal.rpc.KeyTyped keyTyped = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.KeyTyped.class);
        if (this.suppress(TypeKeyCallback.class, TypeKey.class, keyTyped)) {
            return;
        }
        KeyTypeRequest request = KeyTypeRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setKeyTyped(keyTyped).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardKeyType, request);
    }

    public void dispatch(MousePressed event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        com.teamdev.jxbrowser.ui.event.internal.rpc.MousePressed mousePressed = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.MousePressed.class);
        if (this.suppress(PressMouseCallback.class, PressMouse.class, mousePressed)) {
            return;
        }
        MousePressRequest request = MousePressRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMousePressed(mousePressed).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMousePress, request);
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseReleased event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        MouseReleased mouseReleased = Wrappers.unwrap(event, MouseReleased.class);
        if (this.suppress(ReleaseMouseCallback.class, ReleaseMouse.class, mouseReleased)) {
            return;
        }
        MouseReleaseRequest request = MouseReleaseRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMouseReleased(mouseReleased).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMouseRelease, request);
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseEntered event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        MouseEntered mouseEntered = Wrappers.unwrap(event, MouseEntered.class);
        if (this.suppress(EnterMouseCallback.class, EnterMouse.class, mouseEntered)) {
            return;
        }
        MouseEnterRequest request = MouseEnterRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMouseEntered(mouseEntered).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMouseEnter, request);
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseExited event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        MouseExited mouseExited = Wrappers.unwrap(event, MouseExited.class);
        if (this.suppress(ExitMouseCallback.class, ExitMouse.class, mouseExited)) {
            return;
        }
        MouseExitRequest request = MouseExitRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMouseExited(mouseExited).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMouseExit, request);
    }

    public void dispatch(MouseDragged event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        com.teamdev.jxbrowser.ui.event.internal.rpc.MouseDragged mouseDragged = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.MouseDragged.class);
        MouseMoved mouseMoved = MouseMoved.newBuilder().setLocation(mouseDragged.getLocation()).setLocationOnScreen(mouseDragged.getLocationOnScreen()).build();
        if (this.suppress(MoveMouseCallback.class, MoveMouse.class, mouseMoved)) {
            return;
        }
        MouseDragRequest request = MouseDragRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMouseDragged(mouseDragged).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMouseDrag, request);
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseMoved event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        MouseMoved mouseMoved = Wrappers.unwrap(event, MouseMoved.class);
        if (this.suppress(MoveMouseCallback.class, MoveMouse.class, mouseMoved)) {
            return;
        }
        MouseMoveRequest request = MouseMoveRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMouseMoved(mouseMoved).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMouseMove, request);
    }

    public void dispatch(MouseWheel event) {
        Preconditions.checkNotNull(event);
        this.checkNotClosed();
        com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel mouseWheel = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel.class);
        if (this.suppress(MoveMouseWheelCallback.class, MoveMouseWheel.class, mouseWheel)) {
            return;
        }
        MouseWheelRequest request = MouseWheelRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setMouseWheel(mouseWheel).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardMouseWheel, request);
    }

    public void dragEnter(DropMetadata dropMetadata, Point location, Point screenLocation, int operationsAllowed) {
        Preconditions.checkNotNull(dropMetadata);
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.checkNotClosed();
        DragEnterRequest request = DragEnterRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setDropMetadata(dropMetadata).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setOperationsAllowed(operationsAllowed).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardDragEnter, request);
    }

    public void dragOver(Point location, Point screenLocation, int operationsAllowed) {
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.checkNotClosed();
        DragOverRequest request = DragOverRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setOperationsAllowed(operationsAllowed).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardDragOver, request);
    }

    public void dragLeave() {
        this.checkNotClosed();
        DragLeaveRequest request = DragLeaveRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardDragLeave, request);
    }

    public void drop(DropData dropData, Point location, Point screenLocation) {
        Preconditions.checkNotNull(dropData);
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.checkNotClosed();
        DragDropRequest request = DragDropRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setDropData(dropData).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardDragDrop, request);
    }

    public void dragEnd(Point location, Point screenLocation, DragOperation operation) {
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.checkNotClosed();
        DragEndRequest request = DragEndRequest.newBuilder().setRenderWidgetId(this.renderWidgetId).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setOperation(operation).build();
        this.rpc.invokeAsync(this.rpc.stub()::forwardDragEnd, request);
    }

    public void shutdownAndDestroy() {
        this.rpc.invokeAsync(this.rpc.stub()::shutdownAndDestroy, this.renderWidgetId);
    }

    @Override
    public <E extends RenderWidgetEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.eventSourceManager.on(eventClass, observer);
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.eventSource.dispatch(new RenderWidgetClosing(){});
        this.rpc.close();
        super.close();
    }

    @Override
    public <C extends RenderWidgetCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((RenderWidgetCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends RenderWidgetCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends RenderWidgetCallback> C remove(Class<C> callbackClass) {
        return (C)((RenderWidgetCallback)this.rpc.remove(callbackClass));
    }
}

