/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.BrowserSettings;
import com.teamdev.jxbrowser.browser.SavePageType;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.InjectCssCallback;
import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.event.BrowserEvent;
import com.teamdev.jxbrowser.browser.event.FrameCreated;
import com.teamdev.jxbrowser.browser.event.FrameDeleted;
import com.teamdev.jxbrowser.browser.event.RenderProcessStarted;
import com.teamdev.jxbrowser.browser.event.RenderProcessTerminated;
import com.teamdev.jxbrowser.browser.event.SpellCheckCompleted;
import com.teamdev.jxbrowser.browser.internal.BrowserSettingsImpl;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.RenderWidgets;
import com.teamdev.jxbrowser.browser.internal.callback.StartRenderProcessCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TerminateRenderProcessCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserStub;
import com.teamdev.jxbrowser.browser.internal.rpc.OpenPopup;
import com.teamdev.jxbrowser.browser.internal.rpc.PopupCreatorStub;
import com.teamdev.jxbrowser.browser.internal.rpc.PrintRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.PrintServiceStub;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderProcessesStub;
import com.teamdev.jxbrowser.browser.internal.rpc.ReplaceMisspelledWordRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.SavePage;
import com.teamdev.jxbrowser.browser.internal.rpc.Size;
import com.teamdev.jxbrowser.browser.internal.rpc.StartRenderProcess;
import com.teamdev.jxbrowser.browser.internal.rpc.TerminateRenderProcess;
import com.teamdev.jxbrowser.browser.internal.rpc.UserAgent;
import com.teamdev.jxbrowser.browser.internal.rpc.WebPageStub;
import com.teamdev.jxbrowser.callback.internal.CallbackManager;
import com.teamdev.jxbrowser.callback.internal.CustomInvoker;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.devtools.DevTools;
import com.teamdev.jxbrowser.devtools.internal.DevToolsImpl;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.CustomEventSource;
import com.teamdev.jxbrowser.event.internal.EventSource;
import com.teamdev.jxbrowser.event.internal.EventSourceManager;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.Frames;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ContextMenuServiceStub;
import com.teamdev.jxbrowser.internal.rpc.DialogsStub;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.FolderPath;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.FrameIdList;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProcessId;
import com.teamdev.jxbrowser.internal.rpc.RenderProcessId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.js.internal.rpc.JsDialogsStub;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.media.Audio;
import com.teamdev.jxbrowser.media.internal.AudioImpl;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceManagerStub;
import com.teamdev.jxbrowser.navigation.Navigation;
import com.teamdev.jxbrowser.navigation.TimeoutException;
import com.teamdev.jxbrowser.navigation.internal.NavigationImpl;
import com.teamdev.jxbrowser.net.internal.rpc.CertificateErrorHandlerStub;
import com.teamdev.jxbrowser.net.internal.rpc.ClientCertificateChooserStub;
import com.teamdev.jxbrowser.os.Display;
import com.teamdev.jxbrowser.search.TextFinder;
import com.teamdev.jxbrowser.search.internal.TextFinderImpl;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.zoom.Zoom;
import com.teamdev.jxbrowser.zoom.internal.ZoomImpl;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class BrowserImpl
extends CloseableImpl<BrowserImpl>
implements Browser {
    private static final IdMap<BrowserId, BrowserImpl> browserIdToBrowserMap = new IdMap();
    private final BrowserId id;
    private final Frames frames;
    private final EngineImpl engine;
    private final RenderWidgets renderWidgets;
    private final NewServiceConnection<BrowserStub> rpc;
    private final NewServiceConnection<WebPageStub> webPageRpc;
    private final NewServiceConnection<DialogsStub> dialogsRpc;
    private final NewServiceConnection<PrintServiceStub> printRpc;
    private final NewServiceConnection<JsDialogsStub> jsDialogsRpc;
    private final NewServiceConnection<PopupCreatorStub> popupCreatorRpc;
    private final NewServiceConnection<PrintServiceStub> printServiceRpc;
    private final NewServiceConnection<RenderProcessesStub> renderProcessesRpc;
    private final NewServiceConnection<ContextMenuServiceStub> contextMenuServiceRpc;
    private final NewServiceConnection<MediaDeviceManagerStub> mediaDeviceManagerRpc;
    private final NewServiceConnection<CertificateErrorHandlerStub> certificateErrorHandlerRpc;
    private final NewServiceConnection<ClientCertificateChooserStub> clientCertificateChooserRpc;
    private final Lazy<ZoomImpl> zoom;
    private final Lazy<AudioImpl> audio;
    private final Lazy<DevToolsImpl> devTools;
    private final Lazy<DragAndDrop> dragAndDrop;
    private final Lazy<NavigationImpl> navigation;
    private final Lazy<TextFinderImpl> textFinder;
    private final Lazy<BrowserSettingsImpl> settings;
    private final EventSource<BrowserEvent> eventSource;
    private final EventSourceManager eventSourceManager;
    private final CallbackManager callbackManager;

    public static Optional<BrowserImpl> with(BrowserId browserId) {
        Preconditions.checkNotNull(browserId);
        return browserIdToBrowserMap.find(browserId);
    }

    public BrowserImpl(Connection connection, EngineImpl engine, BrowserId id) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(engine);
        Preconditions.checkNotNull(id);
        this.id = id;
        this.engine = engine;
        this.zoom = new Lazy<ZoomImpl>(() -> new ZoomImpl(this));
        this.audio = new Lazy<AudioImpl>(() -> new AudioImpl(this));
        this.devTools = new Lazy<DevToolsImpl>(() -> new DevToolsImpl(this));
        this.navigation = new Lazy<NavigationImpl>(() -> new NavigationImpl(this));
        this.textFinder = new Lazy<TextFinderImpl>(() -> new TextFinderImpl(this));
        this.settings = new Lazy<BrowserSettingsImpl>(() -> new BrowserSettingsImpl(this));
        this.dragAndDrop = new Lazy<DragAndDrop>(() -> new DragAndDrop(this));
        this.eventSource = new CustomEventSource<BrowserEvent>(BrowserClosing.class, RenderProcessStarted.class, RenderProcessTerminated.class, FrameCreated.class, FrameDeleted.class, SpellCheckCompleted.class);
        this.renderWidgets = new RenderWidgets(this);
        this.frames = new Frames(this);
        this.rpc = new NewServiceConnection<BrowserStub>(id, connection, BrowserStub::new);
        this.rpc.setEventHandler(BrowserClosed.class, message -> {
            this.close();
            return true;
        });
        this.webPageRpc = new NewServiceConnection<WebPageStub>(id, connection, WebPageStub::new);
        this.printRpc = new NewServiceConnection<PrintServiceStub>(id, connection, PrintServiceStub::new);
        RenderProcesses renderProcesses = engine.renderProcesses();
        this.renderProcessesRpc = new NewServiceConnection<RenderProcessesStub>(id, connection, RenderProcessesStub::new);
        this.renderProcessesRpc.set(StartRenderProcessCallback.class, params -> {
            RenderProcessId renderProcessId = params.getRenderProcessId();
            ProcessId pid = params.getRenderProcessPid();
            renderProcesses.add(new RenderProcess(engine.connectionServer().awaitConnection(params.getConnectionId()).orElseThrow(() -> new TimeoutException("Failed to find connection within a timeout")), renderProcessId, pid));
            this.notifyObserversAsync(params);
            return StartRenderProcess.Response.newBuilder().build();
        });
        this.renderProcessesRpc.set(TerminateRenderProcessCallback.class, params -> {
            renderProcesses.renderProcess(params.getRenderProcessId()).ifPresent(renderProcess -> {
                renderProcess.close();
                renderProcesses.remove((RenderProcess)renderProcess);
            });
            this.notifyObserversAsync(params);
            return TerminateRenderProcess.Response.newBuilder().build();
        });
        this.eventSourceManager = new EventSourceManager();
        this.eventSourceManager.addEventSource(this.rpc);
        this.eventSourceManager.addEventSource(this.eventSource);
        this.eventSourceManager.addEventSource(this.renderProcessesRpc);
        this.eventSourceManager.addEventSource(this.frames.eventSource());
        this.callbackManager = new CallbackManager();
        this.callbackManager.addInvoker(new CustomInvoker(InjectCssCallback.class, InjectJsCallback.class));
        this.popupCreatorRpc = new NewServiceConnection<PopupCreatorStub>(id, connection, PopupCreatorStub::new);
        this.popupCreatorRpc.setPreProcessor(OpenPopup.class, message -> {
            BrowserId popupBrowserId = message.getRequest().getPopupBrowserId();
            new BrowserImpl(connection, engine, popupBrowserId);
        });
        this.dialogsRpc = new NewServiceConnection<DialogsStub>(id, connection, DialogsStub::new);
        this.jsDialogsRpc = new NewServiceConnection<JsDialogsStub>(id, connection, JsDialogsStub::new);
        this.printServiceRpc = new NewServiceConnection<PrintServiceStub>(id, connection, PrintServiceStub::new);
        this.clientCertificateChooserRpc = new NewServiceConnection<ClientCertificateChooserStub>(id, connection, ClientCertificateChooserStub::new);
        this.certificateErrorHandlerRpc = new NewServiceConnection<CertificateErrorHandlerStub>(id, connection, CertificateErrorHandlerStub::new);
        this.contextMenuServiceRpc = new NewServiceConnection<ContextMenuServiceStub>(id, connection, ContextMenuServiceStub::new);
        this.mediaDeviceManagerRpc = new NewServiceConnection<MediaDeviceManagerStub>(id, connection, MediaDeviceManagerStub::new);
        this.callbackManager.addInvoker(this.rpc);
        this.callbackManager.addInvoker(this.popupCreatorRpc);
        this.callbackManager.addInvoker(this.jsDialogsRpc);
        this.callbackManager.addInvoker(this.dialogsRpc);
        this.callbackManager.addInvoker(this.clientCertificateChooserRpc);
        this.callbackManager.addInvoker(this.certificateErrorHandlerRpc);
        this.callbackManager.addInvoker(this.contextMenuServiceRpc);
        this.callbackManager.addInvoker(this.printServiceRpc);
        this.callbackManager.addInvoker(this.mediaDeviceManagerRpc);
        browserIdToBrowserMap.put(id, this);
        engine.addBrowser(this);
    }

    public BrowserId id() {
        return this.id;
    }

    public RenderWidgets renderWidgets() {
        return this.renderWidgets;
    }

    @Override
    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public Optional<Frame> mainFrame() {
        this.checkNotClosed();
        return FrameImpl.with((FrameId)this.rpc.invoke(this.rpc.stub()::getMainFrame, this.id)).map(frame -> frame);
    }

    @Override
    public Optional<Frame> focusedFrame() {
        this.checkNotClosed();
        return FrameImpl.with((FrameId)this.rpc.invoke(this.rpc.stub()::getFocusedFrame, this.id)).map(frame -> frame);
    }

    @Override
    public List<Frame> frames() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((FrameIdList)this.rpc.invoke(this.rpc.stub()::getAllFrames, this.id)).getFrameIdList().stream().map(frameId -> FrameImpl.with(frameId).orElseThrow(IllegalStateException::new)).collect(Collectors.toList()));
    }

    @Override
    public Bitmap bitmap() {
        this.checkNotClosed();
        return (Bitmap)this.rpc.invoke(this.rpc.stub()::getBitmap, this.id);
    }

    @Override
    public Bitmap favicon() {
        this.checkNotClosed();
        return (Bitmap)this.rpc.invoke(this.rpc.stub()::getFavicon, this.id);
    }

    @Override
    public TextFinder textFinder() {
        return this.textFinder.get();
    }

    @Override
    public Zoom zoom() {
        return this.zoom.get();
    }

    @Override
    public Audio audio() {
        return this.audio.get();
    }

    @Override
    public Navigation navigation() {
        return this.navigation.get();
    }

    @Override
    public BrowserSettings settings() {
        return this.settings.get();
    }

    @Override
    public DevTools devTools() {
        return this.devTools.get();
    }

    @Override
    public void replaceMisspelledWord(String word) {
        Preconditions.checkNotNullEmptyOrBlank(word);
        this.checkNotClosed();
        ReplaceMisspelledWordRequest request = ReplaceMisspelledWordRequest.newBuilder().setBrowserId(this.id).setReplacementWord(word).build();
        this.rpc.invoke(this.rpc.stub()::replaceMisspelledWord, request);
    }

    @Override
    public boolean saveWebPage(Path filePath, Path resourcesDir, SavePageType saveType) {
        Preconditions.checkNotNull(filePath);
        Preconditions.checkNotNull(resourcesDir);
        Preconditions.checkNotNull(saveType);
        this.checkNotClosed();
        SavePage request = SavePage.newBuilder().setBrowserId(this.id).setTargetFilePath(FilePath.newBuilder().setValue(filePath.toAbsolutePath().toString()).build()).setTargetFolderPath(FolderPath.newBuilder().setValue(resourcesDir.toAbsolutePath().toString()).build()).setType(saveType).build();
        return ((BoolValue)this.webPageRpc.invoke(this.webPageRpc.stub()::save, request)).getValue();
    }

    @Override
    public String url() {
        this.checkNotClosed();
        return ((StringValue)this.webPageRpc.invoke(this.webPageRpc.stub()::getUrl, this.id)).getValue();
    }

    @Override
    public String title() {
        this.checkNotClosed();
        return ((StringValue)this.webPageRpc.invoke(this.webPageRpc.stub()::getTitle, this.id)).getValue();
    }

    @Override
    public String userAgent() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getUserAgent, this.id)).getValue();
    }

    @Override
    public void userAgent(String userAgent) {
        Preconditions.checkNotNullEmptyOrBlank(userAgent);
        this.checkNotClosed();
        UserAgent request = UserAgent.newBuilder().setBrowserId(this.id).setUserAgent(userAgent).build();
        this.rpc.invoke(this.rpc.stub()::setUserAgent, request);
    }

    @Override
    public void focus() {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(RenderWidget::focus);
    }

    @Override
    public void unfocus() {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(RenderWidget::unfocus);
    }

    @Override
    public void resize(com.teamdev.jxbrowser.ui.Size size) {
        Preconditions.checkNotNull(size);
        Preconditions.checkArgument(!size.isEmpty());
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setSize, Size.newBuilder().setBrowserId(this.id).setSize(Wrappers.unwrap(size, com.teamdev.jxbrowser.ui.internal.rpc.Size.class)).build());
    }

    @Override
    public void resize(int width, int height) {
        Preconditions.checkArgument(width >= 0 && height >= 0);
        this.resize(com.teamdev.jxbrowser.ui.Size.of(width, height));
    }

    @Override
    public com.teamdev.jxbrowser.ui.Size size() {
        this.checkNotClosed();
        return (com.teamdev.jxbrowser.ui.Size)this.rpc.invoke(this.rpc.stub()::getSize, this.id);
    }

    @Override
    public Display display() {
        this.checkNotClosed();
        return (Display)this.rpc.invoke(this.rpc.stub()::getDisplay, this.id);
    }

    public Optional<String> remoteDebuggingUrl() {
        String url = ((StringValue)this.rpc.invoke(this.rpc.stub()::getRemoteDebuggingUrl, this.id)).getValue();
        return Optional.ofNullable(url.isEmpty() ? null : url);
    }

    @Override
    public void dispatch(KeyPressed event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(KeyReleased event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(KeyTyped event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MousePressed event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MouseReleased event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MouseEntered event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MouseExited event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MouseDragged event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MouseMoved event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    @Override
    public void dispatch(MouseWheel event) {
        this.checkNotClosed();
        this.renderWidgets.activeRenderWidget().ifPresent(renderWidget -> renderWidget.dispatch(event));
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop.get();
    }

    public void print(FrameId frameId) {
        this.checkNotClosed();
        this.printRpc.invoke(this.printRpc.stub()::print, PrintRequest.newBuilder().setBrowserId(this.id).setFrameId(frameId).build());
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Logger.debug("Closing browser...");
        this.eventSource.dispatch(() -> this);
        if (!this.rpc.isClosed()) {
            this.rpc.invoke(this.rpc.stub()::close, this.id);
        }
        this.frames.close();
        this.renderWidgets.close();
        BrowserImpl.closeIfNecessary(this.zoom);
        BrowserImpl.closeIfNecessary(this.audio);
        BrowserImpl.closeIfNecessary(this.settings);
        BrowserImpl.closeIfNecessary(this.navigation);
        BrowserImpl.closeIfNecessary(this.textFinder);
        BrowserImpl.closeIfNecessary(this.dragAndDrop);
        super.close();
        this.engine.removeBrowser(this);
        this.rpc.dispatch(BrowserClosed.newBuilder().setBrowserId(this.id).build());
        this.rpc.setEventHandler(BrowserClosed.class, null);
        this.eventSourceManager.removeEventSource(this.rpc);
        this.eventSourceManager.removeEventSource(this.eventSource);
        this.eventSourceManager.removeEventSource(this.renderProcessesRpc);
        this.eventSourceManager.removeEventSource(this.frames.eventSource());
        this.rpc.close();
        this.printRpc.close();
        this.webPageRpc.close();
        this.renderProcessesRpc.close();
        this.dialogsRpc.close();
        this.jsDialogsRpc.close();
        this.popupCreatorRpc.close();
        this.printServiceRpc.close();
        this.contextMenuServiceRpc.close();
        this.mediaDeviceManagerRpc.close();
        this.certificateErrorHandlerRpc.close();
        this.clientCertificateChooserRpc.close();
        browserIdToBrowserMap.remove(this.id);
        Logger.debug("Closing browser... [OK]");
    }

    public <E extends BrowserEvent> void notifyObservers(E event) {
        Preconditions.checkNotNull(event);
        this.eventSource.dispatch(event);
    }

    public <E extends BrowserEvent> void notifyObserversAsync(E event) {
        Preconditions.checkNotNull(event);
        this.rpc.connection().rpcThread().submit(() -> this.notifyObservers(event));
    }

    public <E extends BrowserEvent> void notifyObserversAsync(E event, Runnable onCompleted) {
        Preconditions.checkNotNull(event);
        Preconditions.checkNotNull(onCompleted);
        this.rpc.connection().rpcThread().submit(() -> {
            try {
                this.notifyObservers(event);
            }
            finally {
                onCompleted.run();
            }
        });
    }

    @Override
    public <E extends BrowserEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.eventSourceManager.on(eventClass, observer);
    }

    @Override
    public <C extends BrowserCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((BrowserCallback)this.callbackManager.set(callbackClass, callback));
    }

    @Override
    public <C extends BrowserCallback> Optional<C> get(Class<C> callbackClass) {
        return this.callbackManager.get(callbackClass);
    }

    @Override
    public <C extends BrowserCallback> C remove(Class<C> callbackClass) {
        return (C)((BrowserCallback)this.callbackManager.remove(callbackClass));
    }
}

