/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.rpc.ContextMenuItem;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.rpc.ShowContextMenu;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.media.MediaType;
import com.teamdev.jxbrowser.menu.SpellCheckMenu;
import com.teamdev.jxbrowser.ui.Point;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public interface ShowContextMenuCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<ShowContextMenu.Response> {
        public Action(Consumer<ShowContextMenu.Response> consumer) {
            super(consumer);
        }

        public void select(com.teamdev.jxbrowser.menu.ContextMenuItem item) {
            Preconditions.checkNotNull(item);
            this.send(ShowContextMenu.Response.newBuilder().setSelectContextMenuItem((ContextMenuItem)item).build());
        }

        public void close() {
            this.send(ShowContextMenu.Response.newBuilder().setCancel(ProtobufUtil.empty()).build());
        }
    }

    public static interface Params {
        default public Browser browser() {
            return BrowserImpl.with(((ShowContextMenu.Request)this).getBrowserId()).orElseThrow(IllegalStateException::new);
        }

        default public Point location() {
            return ((ShowContextMenu.Request)this).getLocation();
        }

        default public String linkUrl() {
            return ((ShowContextMenu.Request)this).getLinkUrl();
        }

        default public String linkText() {
            return ((ShowContextMenu.Request)this).getLinkText();
        }

        default public String srcUrl() {
            return ((ShowContextMenu.Request)this).getSrcUrl();
        }

        default public String pageUrl() {
            return ((ShowContextMenu.Request)this).getPageUrl();
        }

        default public String frameUrl() {
            return ((ShowContextMenu.Request)this).getFrameUrl();
        }

        default public String selectedText() {
            return ((ShowContextMenu.Request)this).getSelectedText();
        }

        default public String frameCharset() {
            return ((ShowContextMenu.Request)this).getFrameCharset();
        }

        default public MediaType mediaType() {
            return ((ShowContextMenu.Request)this).getMediaType();
        }

        @Immutable
        default public List<com.teamdev.jxbrowser.menu.ContextMenuItem> customContextMenuItems() {
            return Collections.unmodifiableList(((ShowContextMenu.Request)this).getCustomMenuItemList());
        }

        default public SpellCheckMenu spellCheckMenu() {
            return ((ShowContextMenu.Request)this).getSpellCheckMenu();
        }
    }
}

