/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.rpc.SaveAsPdf;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.nio.file.Path;
import java.util.function.Consumer;

public interface SaveAsPdfCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<SaveAsPdf.Response> {
        public Action(Consumer<SaveAsPdf.Response> consumer) {
            super(consumer);
        }

        public void save(Path filePath) {
            Preconditions.checkNotNull(filePath);
            this.send(SaveAsPdf.Response.newBuilder().setSaveFile(FilePath.newBuilder().setValue(filePath.toAbsolutePath().toString()).build()).build());
        }

        public void cancel() {
            this.send(SaveAsPdf.Response.newBuilder().setCancel(ProtobufUtil.empty()).build());
        }
    }

    public static interface Params {
        default public String suggestedFileName() {
            return ((SaveAsPdf.Request)this).getSuggestedFileName().getValue();
        }
    }
}

