/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.js.internal.rpc.ShowPrompt;
import java.util.function.Consumer;

public interface PromptCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<ShowPrompt.Response> {
        public Action(Consumer<ShowPrompt.Response> consumer) {
            super(consumer);
        }

        public void ok(String text) {
            Preconditions.checkNotNull(text);
            this.send(ShowPrompt.Response.newBuilder().setEnterText(text).build());
        }

        public void cancel() {
            this.send(ShowPrompt.Response.newBuilder().setCancel(ProtobufUtil.empty()).build());
        }
    }

    public static interface Params {
        default public String title() {
            return ((ShowPrompt.Request)this).getTitle();
        }

        default public String message() {
            return ((ShowPrompt.Request)this).getMessage();
        }

        default public String text() {
            return ((ShowPrompt.Request)this).getText();
        }

        default public String okActionText() {
            return ((ShowPrompt.Request)this).getOkActionText();
        }

        default public String cancelActionText() {
            return ((ShowPrompt.Request)this).getCancelActionText();
        }

        default public String url() {
            return ((ShowPrompt.Request)this).getUrl();
        }
    }
}

