/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import javax.swing.UIManager;

public class JVM {
    public static final int JDK1_0 = 1000;
    public static final int JDK1_1 = 1100;
    public static final int JDK1_2 = 1200;
    public static final int JDK1_3 = 1300;
    public static final int JDK1_4 = 1400;
    public static final int JDK1_5 = 1500;
    public static final int JDK1_6 = 1600;
    public static final int JDK1_6N = 1610;
    public static final int JDK1_7 = 1700;
    public static final int JDK1_8 = 1800;
    public static final int JDK1_9 = 1900;
    public static final int JDK_UNKNWON = Integer.MAX_VALUE;
    private static JVM current = new JVM();
    private int jdkVersion;

    public static JVM current() {
        return current;
    }

    public JVM() {
        this(System.getProperty("java.version"));
    }

    public JVM(String p_JavaVersion) {
        if (p_JavaVersion.startsWith("1.9.")) {
            this.jdkVersion = 1900;
        } else if (p_JavaVersion.startsWith("1.8.")) {
            this.jdkVersion = 1800;
        } else if (p_JavaVersion.startsWith("1.7.")) {
            this.jdkVersion = 1700;
        } else if (p_JavaVersion.startsWith("1.6.")) {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel".equals(info.getClassName())) {
                    this.jdkVersion = 1610;
                    break;
                }
                ++n2;
            }
            this.jdkVersion = this.jdkVersion == 0 ? 1600 : this.jdkVersion;
        } else {
            this.jdkVersion = p_JavaVersion.startsWith("1.5.") ? 1500 : (p_JavaVersion.startsWith("1.4.") ? 1400 : (p_JavaVersion.startsWith("1.3.") ? 1300 : (p_JavaVersion.startsWith("1.2.") ? 1200 : (p_JavaVersion.startsWith("1.1.") ? 1100 : (p_JavaVersion.startsWith("1.0.") ? 1000 : Integer.MAX_VALUE)))));
        }
    }

    public boolean isOrLater(int p_Version) {
        return this.jdkVersion >= p_Version;
    }

    public boolean isOneDotOne() {
        return this.jdkVersion == 1100;
    }

    public boolean isOneDotTwo() {
        return this.jdkVersion == 1200;
    }

    public boolean isOneDotThree() {
        return this.jdkVersion == 1300;
    }

    public boolean isOneDotFour() {
        return this.jdkVersion == 1400;
    }

    public boolean isOneDotFive() {
        return this.jdkVersion == 1500;
    }

    public boolean isOneDotSix() {
        return this.jdkVersion == 1600 || this.isOneDotSixUpdateN();
    }

    public boolean isOneDotSixUpdateN() {
        return this.jdkVersion == 1610;
    }

    public boolean isOneDotSeven() {
        return this.jdkVersion == 1700;
    }
}

