/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.plaf.ColumnControlButtonAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.table.ColumnControlPopup;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class ColumnControlButton
extends JButton {
    public static final String COLUMN_CONTROL_MARKER = "column.";
    public static final String COLUMN_CONTROL_BUTTON_ICON_KEY = "ColumnControlButton.actionIcon";
    public static final String COLUMN_CONTROL_BUTTON_MARGIN_KEY = "ColumnControlButton.margin";
    protected ColumnControlPopup popup;
    private JXTable table;
    private PropertyChangeListener tablePropertyChangeListener;
    TableColumnModelListener columnModelListener;
    private List<ColumnVisibilityAction> columnVisibilityActions;
    private boolean additionalActionsVisible;

    static {
        LookAndFeelAddons.contribute(new ColumnControlButtonAddon());
    }

    public ColumnControlButton(JXTable table) {
        this(table, null);
    }

    public ColumnControlButton(JXTable table, Icon icon) {
        this.init();
        this.setAction(this.createControlAction(icon));
        this.updateActionUI();
        this.updateButtonUI();
        this.installTable(table);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateActionUI();
        this.updateButtonUI();
        this.getColumnControlPopup().updateUI();
    }

    protected void updateButtonUI() {
        if (this.getMargin() == null || this.getMargin() instanceof UIResource) {
            Insets insets = UIManager.getInsets(COLUMN_CONTROL_BUTTON_MARGIN_KEY);
            this.setMargin(insets);
        }
    }

    protected void updateActionUI() {
        if (this.getAction() == null) {
            return;
        }
        Icon icon = (Icon)this.getAction().getValue("SmallIcon");
        if (icon == null || icon instanceof UIResource) {
            icon = SyntheticaLookAndFeel.getIcon((String)COLUMN_CONTROL_BUTTON_ICON_KEY, null, (boolean)true);
            this.getAction().putValue("SmallIcon", icon);
        }
    }

    public void togglePopup() {
        this.getColumnControlPopup().toggleVisibility(this);
    }

    public boolean getAdditionalActionsVisible() {
        return this.additionalActionsVisible;
    }

    public void setAdditionalActionsVisible(boolean additionalActionsVisible) {
        if (additionalActionsVisible == this.getAdditionalActionsVisible()) {
            return;
        }
        boolean old = this.getAdditionalActionsVisible();
        this.additionalActionsVisible = additionalActionsVisible;
        this.populatePopup();
        this.firePropertyChange("additionalActionsVisible", old, this.getAdditionalActionsVisible());
    }

    public void setActionGrouper(ColumnControlPopup.ActionGrouper grouper) {
        if (!(this.getColumnControlPopup() instanceof ColumnControlPopup.ActionGroupable)) {
            return;
        }
        ((ColumnControlPopup.ActionGroupable)((Object)this.getColumnControlPopup())).setActionGrouper(grouper);
        this.populatePopup();
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.getColumnControlPopup().applyComponentOrientation(o);
    }

    protected ColumnControlPopup getColumnControlPopup() {
        if (this.popup == null) {
            this.popup = this.createColumnControlPopup();
        }
        return this.popup;
    }

    protected ColumnControlPopup createColumnControlPopup() {
        return new DefaultColumnControlPopup();
    }

    protected void updateFromColumnModelChange(TableColumnModel oldModel) {
        if (oldModel != null) {
            oldModel.removeColumnModelListener(this.columnModelListener);
        }
        this.populatePopup();
        if (this.canControl()) {
            this.table.getColumnModel().addColumnModelListener(this.getColumnModelListener());
        }
    }

    protected void updateFromTableEnabledChanged() {
        this.getAction().setEnabled(this.table.isEnabled());
    }

    protected boolean canControl() {
        return this.table.getColumnModel() instanceof TableColumnModelExt;
    }

    protected void populatePopup() {
        this.clearAll();
        if (this.canControl()) {
            this.createVisibilityActions();
            this.addVisibilityActionItems();
        }
        this.addAdditionalActionItems();
    }

    protected void clearAll() {
        this.clearColumnVisibilityActions();
        this.getColumnControlPopup().removeAll();
    }

    protected void clearColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            return;
        }
        for (ColumnVisibilityAction action : this.columnVisibilityActions) {
            action.releaseColumn();
        }
        this.columnVisibilityActions.clear();
    }

    protected void addVisibilityActionItems() {
        this.getColumnControlPopup().addVisibilityActionItems(Collections.unmodifiableList(this.getColumnVisibilityActions()));
    }

    protected void addAdditionalActionItems() {
        if (!this.getAdditionalActionsVisible()) {
            return;
        }
        this.getColumnControlPopup().addAdditionalActionItems(Collections.unmodifiableList(this.getAdditionalActions()));
    }

    protected void createVisibilityActions() {
        List<TableColumn> columns = this.table.getColumns(true);
        for (TableColumn column : columns) {
            ColumnVisibilityAction action = this.createColumnVisibilityAction(column);
            if (action == null) continue;
            this.getColumnVisibilityActions().add(action);
        }
    }

    protected ColumnVisibilityAction createColumnVisibilityAction(TableColumn column) {
        return new ColumnVisibilityAction(column);
    }

    protected List<ColumnVisibilityAction> getColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            this.columnVisibilityActions = new ArrayList<ColumnVisibilityAction>();
        }
        return this.columnVisibilityActions;
    }

    protected List<Action> getAdditionalActions() {
        List actionKeys = this.getColumnControlActionKeys();
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Object key : actionKeys) {
            actions.add(this.table.getActionMap().get(key));
        }
        return actions;
    }

    protected List getColumnControlActionKeys() {
        Object[] allKeys = this.table.getActionMap().allKeys();
        ArrayList<Object> columnKeys = new ArrayList<Object>();
        int i = 0;
        while (i < allKeys.length) {
            if (this.isColumnControlActionKey(allKeys[i])) {
                columnKeys.add(allKeys[i]);
            }
            ++i;
        }
        Collections.sort(columnKeys);
        return columnKeys;
    }

    protected boolean isColumnControlActionKey(Object actionKey) {
        return actionKey instanceof String && ((String)actionKey).startsWith(COLUMN_CONTROL_MARKER);
    }

    private void installTable(JXTable table) {
        this.table = table;
        table.addPropertyChangeListener(this.getTablePropertyChangeListener());
        this.updateFromColumnModelChange(null);
        this.updateFromTableEnabledChanged();
    }

    private void init() {
        this.setFocusPainted(false);
        this.setFocusable(false);
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", preventHide);
        this.additionalActionsVisible = true;
    }

    private Action createControlAction(Icon icon) {
        AbstractAction control = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnControlButton.this.togglePopup();
            }
        };
        control.putValue("SmallIcon", icon);
        return control;
    }

    protected PropertyChangeListener getTablePropertyChangeListener() {
        if (this.tablePropertyChangeListener == null) {
            this.tablePropertyChangeListener = this.createTablePropertyChangeListener();
        }
        return this.tablePropertyChangeListener;
    }

    protected PropertyChangeListener createTablePropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("columnModel".equals(evt.getPropertyName())) {
                    ColumnControlButton.this.updateFromColumnModelChange((TableColumnModel)evt.getOldValue());
                } else if ("enabled".equals(evt.getPropertyName())) {
                    ColumnControlButton.this.updateFromTableEnabledChanged();
                }
            }
        };
    }

    protected TableColumnModelListener getColumnModelListener() {
        if (this.columnModelListener == null) {
            this.columnModelListener = this.createColumnModelListener();
        }
        return this.columnModelListener;
    }

    protected TableColumnModelListener createColumnModelListener() {
        return new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                if (!this.isVisibilityChange(e, true)) {
                    ColumnControlButton.this.populatePopup();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                if (!this.isVisibilityChange(e, false)) {
                    ColumnControlButton.this.populatePopup();
                }
            }

            private boolean isVisibilityChange(TableColumnModelEvent e, boolean added) {
                if (!(e.getSource() instanceof DefaultTableColumnModelExt)) {
                    return false;
                }
                DefaultTableColumnModelExt model = (DefaultTableColumnModelExt)e.getSource();
                if (added) {
                    return model.isAddedFromInvisibleEvent(e.getToIndex());
                }
                return model.isRemovedToInvisibleEvent(e.getFromIndex());
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    public class ColumnVisibilityAction
    extends AbstractActionExt {
        private TableColumn column;
        private PropertyChangeListener columnListener;
        private boolean fromColumn;

        public ColumnVisibilityAction(TableColumn column) {
            super((String)null);
            this.setStateAction();
            this.installColumn(column);
        }

        public void releaseColumn() {
            this.column.removePropertyChangeListener(this.columnListener);
            this.column = null;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.canControlColumn();
        }

        protected boolean canControlColumn() {
            return this.column instanceof TableColumnExt;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.canControlColumn()) {
                if (e.getStateChange() == 2 && ColumnControlButton.this.table.getColumnCount() <= 1 && !this.fromColumn) {
                    this.reselect();
                } else {
                    this.setSelected(e.getStateChange() == 1);
                }
            }
        }

        @Override
        public synchronized void setSelected(boolean newValue) {
            super.setSelected(newValue);
            if (this.canControlColumn() && !this.fromColumn) {
                ((TableColumnExt)this.column).setVisible(newValue);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        private void updateFromColumnVisible(boolean visible) {
            this.fromColumn = true;
            this.setSelected(visible);
            this.fromColumn = false;
        }

        protected void updateFromColumnHideable(boolean hideable) {
            this.setEnabled(hideable);
        }

        private void updateFromColumnHeader(Object value) {
            this.setName(String.valueOf(value));
        }

        private void reselect() {
            this.firePropertyChange("selected", null, Boolean.TRUE);
        }

        private void installColumn(TableColumn column) {
            this.column = column;
            column.addPropertyChangeListener(this.getColumnListener());
            this.updateFromColumnHeader(column.getHeaderValue());
            if (column.getIdentifier() != null) {
                this.setActionCommand(column.getIdentifier().toString());
            }
            boolean visible = column instanceof TableColumnExt ? ((TableColumnExt)column).isVisible() : true;
            this.updateFromColumnVisible(visible);
        }

        protected PropertyChangeListener getColumnListener() {
            if (this.columnListener == null) {
                this.columnListener = this.createPropertyChangeListener();
            }
            return this.columnListener;
        }

        protected PropertyChangeListener createPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("visible".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnVisible((Boolean)evt.getNewValue());
                    } else if ("headerValue".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnHeader(evt.getNewValue());
                    } else if ("hideable".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnHideable((Boolean)evt.getNewValue());
                    }
                }
            };
        }
    }

    public class DefaultColumnControlPopup
    implements ColumnControlPopup,
    ColumnControlPopup.ActionGroupable {
        private JPopupMenu popupMenu;
        private ColumnControlPopup.ActionGrouper grouper;

        public DefaultColumnControlPopup() {
            this(null);
        }

        public DefaultColumnControlPopup(ColumnControlPopup.ActionGrouper grouper) {
            this.grouper = grouper;
        }

        @Override
        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.getPopupMenu());
        }

        @Override
        public void toggleVisibility(JComponent owner) {
            JPopupMenu popupMenu = this.getPopupMenu();
            if (popupMenu.isVisible()) {
                popupMenu.setVisible(false);
            } else if (popupMenu.getComponentCount() > 0) {
                Dimension buttonSize = owner.getSize();
                int xPos = owner.getComponentOrientation().isLeftToRight() ? buttonSize.width - popupMenu.getPreferredSize().width : 0;
                popupMenu.show(owner, xPos, buttonSize.height);
            }
        }

        @Override
        public void applyComponentOrientation(ComponentOrientation o) {
            this.getPopupMenu().applyComponentOrientation(o);
        }

        @Override
        public void removeAll() {
            this.getPopupMenu().removeAll();
        }

        @Override
        public void addVisibilityActionItems(List<? extends AbstractActionExt> actions) {
            this.addItems(new ArrayList<AbstractActionExt>(actions));
        }

        @Override
        public void addAdditionalActionItems(List<? extends Action> actions) {
            if (actions.size() == 0) {
                return;
            }
            if (ColumnControlButton.this.canControl()) {
                this.addSeparator();
            }
            if (this.getGrouper() == null) {
                this.addItems(actions);
                return;
            }
            List<List<? extends Action>> groups = this.grouper.group(actions);
            for (List<? extends Action> group : groups) {
                this.addItems(group);
                if (group == groups.get(groups.size() - 1)) continue;
                this.addSeparator();
            }
        }

        protected void addItems(List<? extends Action> actions) {
            ActionContainerFactory factory = new ActionContainerFactory(null);
            for (Action action : actions) {
                this.addItem(factory.createMenuItem(action));
            }
        }

        protected void addSeparator() {
            this.getPopupMenu().addSeparator();
        }

        protected void addItem(JMenuItem item) {
            this.getPopupMenu().add(item);
        }

        protected JPopupMenu getPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            return this.popupMenu;
        }

        @Override
        public void setActionGrouper(ColumnControlPopup.ActionGrouper grouper) {
            this.grouper = grouper;
        }

        protected ColumnControlPopup.ActionGrouper getGrouper() {
            return this.grouper;
        }
    }
}

