/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.util.Calendar;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.basic.BasicCalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarAdapter;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class PublicCalendarRenderingHandler
extends BasicCalendarRenderingHandler {
    private MonthViewCalendarAdapter adapter;
    private CompoundHighlighter highlighter;

    public void setHighlighters(Highlighter ... highlighters) {
        this.getHighlighter().setHighlighters(highlighters);
    }

    public void addHighlighters(Highlighter ... highlighters) {
        Highlighter[] highlighterArray = highlighters;
        int n = highlighters.length;
        int n2 = 0;
        while (n2 < n) {
            Highlighter highlighter = highlighterArray[n2];
            this.getHighlighter().addHighlighter(highlighter);
            ++n2;
        }
    }

    @Override
    public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        JComponent component = super.prepareRenderingComponent(monthView, calendar, dayState);
        return (JComponent)this.getHighlighter().highlight(component, this.getCalendarAdapter(monthView, calendar, dayState));
    }

    protected CompoundHighlighter getHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = new CompoundHighlighter(new Highlighter[0]);
        }
        return this.highlighter;
    }

    protected MonthViewCalendarAdapter getCalendarAdapter(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        if (this.adapter == null) {
            this.adapter = new MonthViewCalendarAdapter(monthView);
        }
        return this.adapter.install(calendar, dayState);
    }

    public static class MonthViewCalendarAdapter
    extends CalendarAdapter {
        public MonthViewCalendarAdapter(JXMonthView component) {
            super(component);
        }

        @Override
        public MonthViewCalendarAdapter install(Calendar calendar, CalendarState dayState) {
            return (MonthViewCalendarAdapter)super.install(calendar, dayState);
        }

        @Override
        public boolean isSelected() {
            if (!this.isDayInMonth()) {
                return false;
            }
            return super.isSelected();
        }

        public Calendar getCalendar() {
            return (Calendar)this.calendar.clone();
        }

        public boolean isDayInMonth() {
            return CalendarState.IN_MONTH == this.getCalendarState() || CalendarState.TODAY == this.getCalendarState();
        }

        public boolean isWeekend() {
            int dayOfWeek = this.getCalendar().get(7);
            return this.isDayInMonth() && (dayOfWeek == 7 || dayOfWeek == 1);
        }
    }
}

