/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.effects;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import org.jdesktop.swingx.painter.effects.AbstractAreaEffect;

public class NeonBorderEffect
extends AbstractAreaEffect {
    private Color edgeColor;
    private Color centerColor;
    private BorderPosition borderPosition = BorderPosition.Outside;

    public NeonBorderEffect() {
        this(Color.GREEN, Color.WHITE, 10);
    }

    public NeonBorderEffect(Color edgeColor, Color centerColor, int effectWidth) {
        this.setEffectWidth(effectWidth);
        this.setEdgeColor(edgeColor);
        this.setCenterColor(centerColor);
        this.setRenderInsideShape(false);
        this.setShouldFillShape(false);
        this.setOffset(new Point(0, 0));
    }

    @Override
    protected void paintBorderGlow(Graphics2D gfx, Shape clipShape, int width, int height) {
        gfx.translate(this.getOffset().getX(), this.getOffset().getY());
        gfx.setComposite(AlphaComposite.SrcOver);
        int steps = this.getEffectWidth();
        if (this.borderPosition == BorderPosition.Centered) {
            steps /= 2;
        }
        int i = 0;
        while (i < steps) {
            float brushWidth = steps + 1 - i;
            float half = steps / 2;
            if (this.borderPosition == BorderPosition.Centered) {
                gfx.setPaint(this.interpolateColor((float)(steps - i) / (float)steps, this.getEdgeColor(), this.getCenterColor()));
            } else if ((float)i < half) {
                gfx.setPaint(this.interpolateColor((half - (float)i) / half, this.getEdgeColor(), this.getCenterColor()));
            } else {
                gfx.setPaint(this.interpolateColor(((float)i - half) / half, this.getEdgeColor(), this.getCenterColor()));
            }
            gfx.setStroke(new BasicStroke(brushWidth, 1, 1));
            gfx.draw(clipShape);
            ++i;
        }
        gfx.translate(-this.getOffset().getX(), -this.getOffset().getY());
    }

    protected Color interpolateColor(float t, Color start, Color end) {
        float[] partsS = start.getRGBComponents(null);
        float[] partsE = end.getRGBComponents(null);
        float[] partsR = new float[4];
        int i = 0;
        while (i < 4) {
            partsR[i] = (partsS[i] - partsE[i]) * t + partsE[i];
            ++i;
        }
        return new Color(partsR[0], partsR[1], partsR[2], partsR[3]);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getCenterColor() {
        return this.centerColor;
    }

    public void setCenterColor(Color centerColor) {
        this.centerColor = centerColor;
    }

    public BorderPosition getBorderPosition() {
        return this.borderPosition;
    }

    public void setBorderPosition(BorderPosition borderPosition) {
        this.borderPosition = borderPosition;
        switch (borderPosition) {
            case Centered: {
                this.setShapeMasked(false);
                break;
            }
            case Inside: {
                this.setShapeMasked(true);
                this.setRenderInsideShape(true);
                break;
            }
            case Outside: {
                this.setShapeMasked(true);
                this.setRenderInsideShape(false);
            }
        }
    }

    public static enum BorderPosition {
        Inside,
        Centered,
        Outside;

    }
}

