/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.util.prefs.Preferences;
import org.jdesktop.beans.JavaBean;
import org.jdesktop.swingx.auth.UserNameStore;

@JavaBean
public class DefaultUserNameStore
extends UserNameStore {
    private static final String USER_KEY = "usernames";
    private static final String NUM_KEY = "usernames.length";
    private Preferences prefs;
    private String[] userNames = new String[0];

    @Override
    public void loadUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            int n = this.prefs.getInt(NUM_KEY, 0);
            String[] names = new String[n];
            int i = 0;
            while (i < n) {
                names[i] = this.prefs.get("usernames." + i, null);
                ++i;
            }
            this.setUserNames(names);
        }
    }

    @Override
    public void saveUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            this.prefs.putInt(NUM_KEY, this.userNames.length);
            int i = 0;
            while (i < this.userNames.length) {
                this.prefs.put("usernames." + i, this.userNames[i]);
                ++i;
            }
        }
    }

    @Override
    public String[] getUserNames() {
        String[] copy = new String[this.userNames.length];
        System.arraycopy(this.userNames, 0, copy, 0, this.userNames.length);
        return copy;
    }

    @Override
    public void setUserNames(String[] userNames) {
        userNames = userNames == null ? new String[]{} : userNames;
        String[] old = this.getUserNames();
        this.userNames = userNames;
        this.firePropertyChange("userNames", old, this.getUserNames());
    }

    @Override
    public void addUserName(String name) {
        if (!this.containsUserName(name)) {
            String[] newNames = new String[this.userNames.length + 1];
            int i = 0;
            while (i < this.userNames.length) {
                newNames[i] = this.userNames[i];
                ++i;
            }
            newNames[newNames.length - 1] = name;
            this.setUserNames(newNames);
        }
    }

    @Override
    public void removeUserName(String name) {
        if (this.containsUserName(name)) {
            String[] newNames = new String[this.userNames.length - 1];
            int index = 0;
            String[] stringArray = this.userNames;
            int n = this.userNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.equals(name)) {
                    newNames[index++] = s;
                }
                ++n2;
            }
            this.setUserNames(newNames);
        }
    }

    @Override
    public boolean containsUserName(String name) {
        String[] stringArray = this.userNames;
        int n = this.userNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void setPreferences(Preferences prefs) {
        Preferences old = this.getPreferences();
        this.initPrefs();
        this.prefs = prefs;
        this.firePropertyChange("preferences", old, this.getPreferences());
        if (this.prefs != old) {
            this.loadUserNames();
        }
    }

    private void initPrefs() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(DefaultUserNameStore.class);
            this.prefs = this.prefs.node("DefaultUserNameStore");
        }
    }
}

