/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.swing.extensions;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;

public class JTFrame
extends JFrame {
    private static final int sleepTime = 200;
    private static final int borderWidth = 8;
    private static final Insets borderInsets = new Insets(8, 8, 8, 8);
    private static Robot robot = null;
    private boolean opaqueBorder = false;
    private boolean lockUpdate = false;
    private boolean evenUICall = true;
    private BufferedImage imgTopBorder = null;
    private BufferedImage imgLeftBorder = null;
    private BufferedImage imgBottomBorder = null;
    private BufferedImage imgRightBorder = null;
    private Point capturePoint = null;
    private Dimension captureSize = null;

    public JTFrame() {
        this.init();
    }

    public JTFrame(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public JTFrame(boolean opaqueBorder) {
        this.opaqueBorder = opaqueBorder;
        this.init();
    }

    public JTFrame(String title) {
        super(title);
        this.init();
    }

    public JTFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.init();
    }

    public JTFrame(String title, boolean opaqueBorder) {
        super(title);
        this.opaqueBorder = opaqueBorder;
        this.init();
    }

    private void init() {
        this.getRootPane().setBorder(new FrameBorder());
        this.getRootPane().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("UI")) {
                    if (JTFrame.this.evenUICall) {
                        JTFrame.this.evenUICall = false;
                        JTFrame.this.releaseBorder();
                    } else {
                        JTFrame.this.evenUICall = true;
                        JTFrame.this.captureBorder();
                    }
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("windowMoving") || evt.getPropertyName().equals("windowResizing") || evt.getPropertyName().equals("windowMaximized")) {
                    JTFrame.this.releaseBorder();
                } else if (evt.getPropertyName().equals("windowMoved") || evt.getPropertyName().equals("windowResized") || evt.getPropertyName().equals("windowRestored")) {
                    JTFrame.this.captureBorder();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JTFrame.this.captureBorder();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                JTFrame.this.releaseBorder();
            }
        });
    }

    private Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return robot;
    }

    public void captureBorder() {
        if (!this.isShowing()) {
            return;
        }
        int titleHeight = 0;
        if (!this.opaqueBorder && this.getRootPane().getUI() instanceof BaseRootPaneUI) {
            BaseRootPaneUI ui = (BaseRootPaneUI)this.getRootPane().getUI();
            titleHeight = ui.getTitlePane().getHeight();
        }
        this.lockUpdate = true;
        this.capturePoint = this.getLocationOnScreen();
        this.captureSize = this.getSize();
        this.setBounds(this.capturePoint.x + 8, this.capturePoint.y + 8 + titleHeight, this.captureSize.width - 16, this.captureSize.height - 16 - titleHeight);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Rectangle bounds = JTFrame.this.getBounds();
                Rectangle rect = new Rectangle(((JTFrame)JTFrame.this).capturePoint.x, ((JTFrame)JTFrame.this).capturePoint.y, ((JTFrame)JTFrame.this).captureSize.width, 8);
                JTFrame.this.imgTopBorder = JTFrame.this.getRobot().createScreenCapture(rect);
                rect.y += ((JTFrame)JTFrame.this).captureSize.height - 8;
                JTFrame.this.imgBottomBorder = JTFrame.this.getRobot().createScreenCapture(rect);
                rect.y = ((JTFrame)JTFrame.this).capturePoint.y + 8;
                rect.width = 8;
                rect.height = ((JTFrame)JTFrame.this).captureSize.height - 16;
                JTFrame.this.imgLeftBorder = JTFrame.this.getRobot().createScreenCapture(rect);
                rect.x += ((JTFrame)JTFrame.this).captureSize.width - 8;
                JTFrame.this.imgRightBorder = JTFrame.this.getRobot().createScreenCapture(rect);
                if (!JTFrame.this.opaqueBorder && JTFrame.this.getRootPane().getUI() instanceof BaseRootPaneUI) {
                    BaseRootPaneUI ui = (BaseRootPaneUI)JTFrame.this.getRootPane().getUI();
                    BaseTitlePane tp = ui.getTitlePane();
                    rect.x = ((JTFrame)JTFrame.this).capturePoint.x + 8;
                    rect.y = ((JTFrame)JTFrame.this).capturePoint.y + 8;
                    rect.width = ((JTFrame)JTFrame.this).captureSize.width - 16;
                    rect.height = tp.getHeight();
                    tp.setBackgroundImage(JTFrame.this.getRobot().createScreenCapture(rect));
                }
                JTFrame.this.lockUpdate = false;
                JTFrame.this.setBounds(((JTFrame)JTFrame.this).capturePoint.x, ((JTFrame)JTFrame.this).capturePoint.y, ((JTFrame)JTFrame.this).captureSize.width, ((JTFrame)JTFrame.this).captureSize.height);
            }
        });
    }

    public void releaseBorder() {
        this.imgTopBorder = null;
        this.imgBottomBorder = null;
        this.imgLeftBorder = null;
        this.imgRightBorder = null;
        if (!this.opaqueBorder && this.getRootPane().getUI() instanceof BaseRootPaneUI) {
            BaseRootPaneUI ui = (BaseRootPaneUI)this.getRootPane().getUI();
            BaseTitlePane tp = ui.getTitlePane();
            tp.setBackgroundImage(null);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (!this.lockUpdate) {
            super.paint(g);
        }
    }

    private class FrameBorder
    implements Border {
        private FrameBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean active = JTattooUtilities.isActive((JComponent)c);
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowBorderColor();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowTitleColorLight();
            if (!active) {
                frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
                borderColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
            }
            if (JTFrame.this.imgTopBorder != null) {
                g.drawImage(JTFrame.this.imgTopBorder, x, y, null);
                g.drawImage(JTFrame.this.imgLeftBorder, x, y + 8, null);
                g.drawImage(JTFrame.this.imgBottomBorder, x, y + height - 8, null);
                g.drawImage(JTFrame.this.imgRightBorder, x + width - 8, y + 8, null);
                Graphics2D g2D = (Graphics2D)g;
                Composite composite = g2D.getComposite();
                AlphaComposite alpha = null;
                g.setColor(frameColor);
                int x1 = x + 5;
                int y1 = y;
                int x2 = x + width - 5;
                int y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 3;
                x2 = x1 + 1;
                g2D.drawLine(x1, ++y1, x2, ++y2);
                x1 = x + width - 4;
                x2 = x1 + 1;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + 2;
                g2D.drawLine(x1, ++y1, x2, ++y2);
                x2 = x1 = x + width - 2;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + 1;
                y2 = ++y1 + 1;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + width - 1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 5;
                x2 = x + width - 5;
                y2 = y1 = y + height - 1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 3;
                x2 = x1 + 1;
                y2 = y1 = y + height - 2;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + width - 4;
                x2 = x1 + 1;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + 2;
                g2D.drawLine(x1, --y1, x2, --y2);
                x2 = x1 = x + width - 2;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + 1;
                y2 = (y1 -= 2) + 1;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + width - 1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x;
                y1 = y + 5;
                x2 = x1;
                y2 = y + height - 5;
                g2D.drawLine(x1, y1, x2, y2);
                x2 = x1 = x + width - 1;
                g2D.drawLine(x1, y1, x2, y2);
                if (!JTFrame.this.opaqueBorder) {
                    alpha = AlphaComposite.getInstance(3, 0.85f);
                    g2D.setComposite(alpha);
                }
                g.setColor(ColorHelper.brighter(borderColor, 20.0));
                x1 = x + 5;
                y1 = y + 1;
                x2 = x + width - 5;
                y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 1;
                y1 = y + 8 - 1;
                x2 = x + 1;
                y2 = y + height - 8 + 1;
                g2D.drawLine(x1, y1, x2, y2);
                g.setColor(borderColor);
                x1 = x + 3;
                y1 = y + 2;
                x2 = x + width - 3;
                y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 2;
                y1 = y + 3;
                x2 = x + width - 2;
                y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                g2D.drawLine(x1, ++y1, x2, ++y2);
                g2D.fillRect(x + 1, y + 5, width - 2, 2);
                x1 = x + 5;
                y1 = y + height - 2;
                x2 = x + width - 5;
                y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 3;
                y1 = y + height - 3;
                x2 = x + width - 3;
                y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                x1 = x + 2;
                y1 = y + height - 4;
                x2 = x + width - 2;
                y2 = y1;
                g2D.drawLine(x1, y1, x2, y2);
                g2D.fillRect(x + 1, y + height - 8 + 1, width - 2, 3);
                g.fillRect(x + 2, y + 8 - 1, 5, height - 16 + 2);
                g.fillRect(x + width - 8 + 1, y + 8 - 1, 6, height - 16 + 2);
                g.drawRect(x + 8 - 1, y + 8 - 1, width - 16 + 1, height - 16 + 1);
                if (!JTFrame.this.opaqueBorder) {
                    g2D.setComposite(composite);
                }
            } else {
                g.setColor(frameColor);
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(borderColor);
                g.fillRect(x + 1, y + 1, width - 2, 7);
                g.fillRect(x + 1, y + height - 8, width - 2, 7);
                g.fillRect(x + 1, y + 8, 7, y + height - 16);
                g.fillRect(x + width - 8, y + 8, 7, y + height - 16);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

