/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.samples.BaseSampleFrame;
import com.jtattoo.samples.textures.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TransparentTabbedPaneSample
extends BaseSampleFrame {
    private JCheckBox opaqueCheck = new JCheckBox("TabbedPane.opaque", false);
    private JCheckBox contentOpaqueCheck = null;
    private JCheckBox tabsOpaqueCheck = null;
    private JPanel tabPanel = null;
    private JTabbedPane tabbedPane = null;
    private JPanel backgroundPanel = null;

    public TransparentTabbedPaneSample() {
        super("TransparentTabbedPaneSample");
        this.opaqueCheck.setOpaque(false);
        this.opaqueCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransparentTabbedPaneSample.this.tabbedPane.setOpaque(!TransparentTabbedPaneSample.this.tabbedPane.isOpaque());
                TransparentTabbedPaneSample.this.contentOpaqueCheck.setEnabled(!TransparentTabbedPaneSample.this.opaqueCheck.isSelected());
                TransparentTabbedPaneSample.this.tabsOpaqueCheck.setEnabled(!TransparentTabbedPaneSample.this.opaqueCheck.isSelected());
                TransparentTabbedPaneSample.this.updateTabbedPane();
            }
        });
        this.contentOpaqueCheck = new JCheckBox("TabbedPane.contentOpaque", true);
        this.contentOpaqueCheck.setOpaque(false);
        this.contentOpaqueCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean opaque = true;
                if (UIManager.get("TabbedPane.contentOpaque") != null) {
                    opaque = UIManager.getBoolean("TabbedPane.contentOpaque");
                }
                UIManager.put("TabbedPane.contentOpaque", !opaque);
                TransparentTabbedPaneSample.this.updateTabbedPane();
            }
        });
        this.tabsOpaqueCheck = new JCheckBox("TabbedPane.tabsOpaque", true);
        this.tabsOpaqueCheck.setOpaque(false);
        this.tabsOpaqueCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean opaque = true;
                if (UIManager.get("TabbedPane.tabsOpaque") != null) {
                    opaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
                }
                UIManager.put("TabbedPane.tabsOpaque", !opaque);
                TransparentTabbedPaneSample.this.updateTabbedPane();
            }
        });
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setOpaque(false);
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 8));
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        checkBoxPanel.add(this.opaqueCheck);
        checkBoxPanel.add(this.contentOpaqueCheck);
        checkBoxPanel.add(this.tabsOpaqueCheck);
        JPanel optionPanel = new JPanel();
        optionPanel.setOpaque(false);
        optionPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 8));
        optionPanel.setLayout(new BoxLayout(optionPanel, 0));
        final JRadioButton topCheck = new JRadioButton("Top", true);
        topCheck.setOpaque(false);
        final JRadioButton leftCheck = new JRadioButton("Left", false);
        leftCheck.setOpaque(false);
        final JRadioButton bottomCheck = new JRadioButton("Bottom", false);
        bottomCheck.setOpaque(false);
        JRadioButton rightCheck = new JRadioButton("Right", false);
        rightCheck.setOpaque(false);
        final JCheckBox scrollableCheck = new JCheckBox("ScrollableTabs", false);
        scrollableCheck.setOpaque(false);
        scrollableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (scrollableCheck.isSelected()) {
                    TransparentTabbedPaneSample.this.tabbedPane.setTabLayoutPolicy(1);
                } else {
                    TransparentTabbedPaneSample.this.tabbedPane.setTabLayoutPolicy(0);
                }
                TransparentTabbedPaneSample.this.updateTabbedPane();
            }
        });
        optionPanel.add(topCheck);
        optionPanel.add(leftCheck);
        optionPanel.add(bottomCheck);
        optionPanel.add(rightCheck);
        optionPanel.add(scrollableCheck);
        ButtonGroup orientatioGroup = new ButtonGroup();
        orientatioGroup.add(topCheck);
        orientatioGroup.add(leftCheck);
        orientatioGroup.add(bottomCheck);
        orientatioGroup.add(rightCheck);
        ActionListener orientationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (topCheck.isSelected()) {
                    TransparentTabbedPaneSample.this.tabbedPane.setTabPlacement(1);
                } else if (leftCheck.isSelected()) {
                    TransparentTabbedPaneSample.this.tabbedPane.setTabPlacement(2);
                } else if (bottomCheck.isSelected()) {
                    TransparentTabbedPaneSample.this.tabbedPane.setTabPlacement(3);
                } else {
                    TransparentTabbedPaneSample.this.tabbedPane.setTabPlacement(4);
                }
                TransparentTabbedPaneSample.this.updateTabbedPane();
            }
        };
        topCheck.addActionListener(orientationListener);
        leftCheck.addActionListener(orientationListener);
        bottomCheck.addActionListener(orientationListener);
        rightCheck.addActionListener(orientationListener);
        this.tabPanel = new JPanel(new BorderLayout());
        this.tabPanel.setOpaque(false);
        this.tabPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.tabbedPane = new JTabbedPane();
        JPanel panelTransparent = new JPanel();
        panelTransparent.setOpaque(false);
        this.tabbedPane.add("Transparent", panelTransparent);
        JPanel yellowPanel = new JPanel();
        yellowPanel.setBackground(Color.yellow);
        this.tabbedPane.add("Yellow", yellowPanel);
        this.tabbedPane.setBackgroundAt(1, Color.yellow);
        this.tabbedPane.setForegroundAt(1, Color.red);
        JPanel greenPanel = new JPanel();
        greenPanel.setBackground(Color.green);
        this.tabbedPane.add("Green", greenPanel);
        this.tabbedPane.setBackgroundAt(2, Color.green);
        this.tabbedPane.setForegroundAt(2, Color.blue);
        JPanel bluePanel = new JPanel();
        bluePanel.setBackground(Color.blue);
        this.tabbedPane.add("Blue", bluePanel);
        this.tabbedPane.setBackgroundAt(3, Color.blue);
        this.tabbedPane.setForegroundAt(3, Color.magenta);
        JPanel defaultPanel = new JPanel();
        this.tabbedPane.add("Default", defaultPanel);
        this.tabPanel.add((Component)this.tabbedPane, "Center");
        this.backgroundPanel = new JPanel(new BorderLayout());
        this.backgroundPanel.putClientProperty("backgroundTexture", ImageHelper.loadImage("BackgroundTexture.jpg"));
        this.backgroundPanel.add((Component)checkBoxPanel, "North");
        this.backgroundPanel.add((Component)this.tabPanel, "Center");
        this.backgroundPanel.add((Component)optionPanel, "South");
        JScrollPane contentScrollPane = new JScrollPane(this.backgroundPanel);
        this.contentPanel.add((Component)contentScrollPane, "Center");
    }

    @Override
    public void setLookAndFeel() {
        if (this.selectedLaf == 6 || this.selectedLaf == 10) {
            this.backgroundPanel.putClientProperty("backgroundTexture", ImageHelper.loadImage("DarkBackgroundTexture.jpg"));
        } else {
            this.backgroundPanel.putClientProperty("backgroundTexture", ImageHelper.loadImage("BackgroundTexture.jpg"));
        }
        super.setLookAndFeel();
    }

    private void updateTabbedPane() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransparentTabbedPaneSample.this.tabPanel.validate();
                TransparentTabbedPaneSample.this.tabPanel.repaint();
            }
        });
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TransparentTabbedPaneSample app = new TransparentTabbedPaneSample();
                    app.setSize(800, 600);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

