/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.samples.BaseSampleFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolTipSample
extends BaseSampleFrame {
    private JPanel toolTipPanel = null;
    private JPanel controlsPanel = null;
    private JCheckBox castShadowCheck = new JCheckBox("tooltipCastShadow", false);
    private JLabel borderSizeLabel = null;
    private JSpinner borderSizeSpinner = null;
    private JLabel shadowSizeLabel = null;
    private JSpinner shadowSizeSpinner = null;
    private JLabel toolTipLabel = null;

    public ToolTipSample() {
        super("ToolTipSample");
        this.castShadowCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipSample.this.createTipText();
                ToolTipSample.this.setLookAndFeel();
            }
        });
        this.borderSizeLabel = new JLabel("tooltipBorderSize");
        this.borderSizeLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderSizeSpinner = new JSpinner(new SpinnerNumberModel(6, 0, 8, 1));
        this.borderSizeSpinner.setMaximumSize(new Dimension(48, 24));
        this.borderSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolTipSample.this.createTipText();
                ToolTipSample.this.setLookAndFeel();
            }
        });
        this.shadowSizeLabel = new JLabel("tooltipShadowSize");
        this.shadowSizeLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.shadowSizeSpinner = new JSpinner(new SpinnerNumberModel(6, 0, 8, 1));
        this.shadowSizeSpinner.setMaximumSize(new Dimension(48, 24));
        this.shadowSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolTipSample.this.createTipText();
                ToolTipSample.this.setLookAndFeel();
            }
        });
        this.controlsPanel = new JPanel();
        this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 0));
        this.controlsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.controlsPanel.add(this.castShadowCheck);
        this.controlsPanel.add(this.borderSizeLabel);
        this.controlsPanel.add(this.borderSizeSpinner);
        this.controlsPanel.add(this.shadowSizeLabel);
        this.controlsPanel.add(this.shadowSizeSpinner);
        this.controlsPanel.add(new JPanel());
        this.toolTipLabel = new JLabel("Rollover me to show the tool tip!");
        this.toolTipLabel.setFont(new Font("Dialog", 0, 16));
        this.toolTipLabel.setHorizontalAlignment(0);
        this.toolTipLabel.setOpaque(true);
        this.toolTipLabel.setBackground(new Color(255, 255, 128));
        this.toolTipLabel.setForeground(Color.black);
        this.toolTipLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.createTipText();
        this.toolTipPanel = new JPanel(new BorderLayout());
        this.toolTipPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.toolTipPanel.add((Component)this.controlsPanel, "North");
        this.toolTipPanel.add((Component)this.toolTipLabel, "Center");
        this.contentPanel.add((Component)this.toolTipPanel, "Center");
    }

    @Override
    public Properties getLAFProps() {
        Properties props = super.getLAFProps();
        if (this.castShadowCheck.isSelected()) {
            props.put("tooltipCastShadow", "on");
        } else {
            props.put("tooltipCastShadow", "off");
        }
        props.put("tooltipBorderSize", "" + this.borderSizeSpinner.getValue());
        props.put("tooltipShadowSize", "" + this.shadowSizeSpinner.getValue());
        return props;
    }

    private void createTipText() {
        String tip = "<html>Tool tip";
        tip = this.castShadowCheck.isSelected() ? String.valueOf(tip) + " with cast shadow.<br/>" : String.valueOf(tip) + " with default shadow.<br/>";
        tip = String.valueOf(tip) + " tooltipBorderSize = " + this.borderSizeSpinner.getValue() + "<br/>";
        tip = String.valueOf(tip) + " tooltipShadowSize = " + this.shadowSizeSpinner.getValue() + "<br/>";
        tip = String.valueOf(tip) + "</html>";
        this.toolTipLabel.setToolTipText(tip);
    }

    public static void main(String[] args) {
        try {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setReshowDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolTipSample app = new ToolTipSample();
                    app.setSize(800, 600);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

