/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TitleBorder
implements Border {
    private static final Insets BORDER_INSETS = new Insets(24, 1, 1, 1);
    private String title = null;

    public TitleBorder(String aTitle) {
        this.title = aTitle;
    }

    private boolean isTextureLAF() {
        return "Texture".equals(UIManager.getLookAndFeel().getName());
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.isTextureLAF()) {
            this.paintTextureBorder(c, g, x, y, width, height);
        } else {
            this.paintDefaultBorder(c, g, x, y, width, height);
        }
    }

    public void paintDefaultBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2D = (Graphics2D)g;
        Color backColorLight = UIManager.getColor("activeCaptionLight");
        Color backColorDark = UIManager.getColor("activeCaptionDark");
        Color frameColor = ColorHelper.darker(UIManager.getColor("controlShadow"), 20.0);
        if (backColorLight == null) {
            backColorLight = new Color(220, 220, 220);
        }
        if (backColorDark == null) {
            backColorDark = new Color(180, 180, 180);
        }
        if (frameColor == null) {
            frameColor = new Color(120, 120, 120);
        }
        g2D.setColor(frameColor);
        g2D.drawRect(x, y, width - 1, height - 1);
        g2D.setPaint(new GradientPaint(0.0f, 0.0f, backColorLight, 0.0f, TitleBorder.BORDER_INSETS.top, backColorDark));
        g2D.fillRect(x + 1, y + 1, width - 2, TitleBorder.BORDER_INSETS.top - 1);
        g2D.setColor(frameColor);
        g2D.drawLine(x + 1, y + TitleBorder.BORDER_INSETS.top - 1, x + width - 2, y + TitleBorder.BORDER_INSETS.top - 1);
        Color foreColor = UIManager.getColor("activeCaptionText");
        this.paintTitle(c, g, foreColor, x, y, width, height);
    }

    public void paintTextureBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2D = (Graphics2D)g;
        Composite saveComposite = g2D.getComposite();
        TextureUtils.fillComponent(g, c, x, y, width, TitleBorder.BORDER_INSETS.top, 2);
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
        g2D.setComposite(alpha);
        Color frameColor = UIManager.getColor("Button.frame");
        g2D.setColor(frameColor);
        g2D.drawRect(x, y, width - 1, height - 1);
        g2D.drawLine(x + 1, y + TitleBorder.BORDER_INSETS.top - 1, x + width - 2, y + TitleBorder.BORDER_INSETS.top - 1);
        g2D.setColor(frameColor);
        g2D.setColor(Color.white);
        float a = 0.7f;
        int i = 0;
        while (i < 7) {
            alpha = AlphaComposite.getInstance(3, a);
            g2D.setComposite(alpha);
            g2D.drawLine(x + 1, y + 1 + i, x + width - 2, y + 1 + i);
            a -= 0.1f;
            ++i;
        }
        g2D.setComposite(saveComposite);
        Color foreColor = c.getForeground();
        this.paintTitle(c, g, foreColor, x, y, width, height);
    }

    public void paintTitle(Component c, Graphics g, Color foreColor, int x, int y, int width, int height) {
        if (this.title != null && this.title.trim().length() > 0) {
            Font font = UIManager.getFont("Label.font").deriveFont(1);
            if (font == null) {
                font = c.getFont();
            }
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            String clippedTitle = JTattooUtilities.getClippedText(this.title, fm, width - 12);
            if (ColorHelper.getGrayValue(foreColor) > 128) {
                Graphics2D g2D = (Graphics2D)g;
                Composite savedComposit = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                g.setColor(Color.black);
                JTattooUtilities.drawString((JComponent)c, g, clippedTitle, x + 7, y + fm.getHeight() + 1);
                g2D.setComposite(savedComposit);
            }
            g.setColor(foreColor);
            JTattooUtilities.drawString((JComponent)c, g, clippedTitle, x + 6, y + fm.getHeight());
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            TitleBorder.BORDER_INSETS.top = font.getSize() * 2;
        }
        return BORDER_INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

