/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.samples.BaseSampleFrame;
import com.jtattoo.samples.icons.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class TabComponentSample
extends BaseSampleFrame {
    private static final int MAX_TABS = 20;
    private static int tabNo = 0;
    private JTabbedPane tabbedPane = null;

    public TabComponentSample() {
        super("TabComponentSample");
        JPanel optionPanel = new JPanel();
        optionPanel.setOpaque(false);
        optionPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 8));
        optionPanel.setLayout(new BoxLayout(optionPanel, 0));
        final JRadioButton topCheck = new JRadioButton("Top", true);
        topCheck.setOpaque(false);
        final JRadioButton leftCheck = new JRadioButton("Left", false);
        leftCheck.setOpaque(false);
        final JRadioButton bottomCheck = new JRadioButton("Bottom", false);
        bottomCheck.setOpaque(false);
        JRadioButton rightCheck = new JRadioButton("Right", false);
        rightCheck.setOpaque(false);
        final JCheckBox scrollableCheck = new JCheckBox("ScrollableTabs", false);
        scrollableCheck.setOpaque(false);
        scrollableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (scrollableCheck.isSelected()) {
                    TabComponentSample.this.tabbedPane.setTabLayoutPolicy(1);
                } else {
                    TabComponentSample.this.tabbedPane.setTabLayoutPolicy(0);
                }
                TabComponentSample.this.updateTabbedPane();
            }
        });
        optionPanel.add(topCheck);
        optionPanel.add(leftCheck);
        optionPanel.add(bottomCheck);
        optionPanel.add(rightCheck);
        optionPanel.add(scrollableCheck);
        ButtonGroup orientatioGroup = new ButtonGroup();
        orientatioGroup.add(topCheck);
        orientatioGroup.add(leftCheck);
        orientatioGroup.add(bottomCheck);
        orientatioGroup.add(rightCheck);
        ActionListener orientationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (topCheck.isSelected()) {
                    TabComponentSample.this.tabbedPane.setTabPlacement(1);
                } else if (leftCheck.isSelected()) {
                    TabComponentSample.this.tabbedPane.setTabPlacement(2);
                } else if (bottomCheck.isSelected()) {
                    TabComponentSample.this.tabbedPane.setTabPlacement(3);
                } else {
                    TabComponentSample.this.tabbedPane.setTabPlacement(4);
                }
                TabComponentSample.this.updateTabbedPane();
            }
        };
        topCheck.addActionListener(orientationListener);
        leftCheck.addActionListener(orientationListener);
        bottomCheck.addActionListener(orientationListener);
        rightCheck.addActionListener(orientationListener);
        JPanel tabPanel = new JPanel(new BorderLayout());
        tabPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("DefaultTab", new JPanel());
        int i = 1;
        while (i < 7) {
            String tabTitle = "Tab " + ++tabNo + "  ";
            this.tabbedPane.add(tabTitle, new JPanel());
            this.tabbedPane.setTabComponentAt(i, new CloseableTabComponent(this.tabbedPane, tabTitle));
            ++i;
        }
        this.tabbedPane.addTab("+", new JPanel());
        this.tabbedPane.setTabComponentAt(this.tabbedPane.getTabCount() - 1, new AddTabComponent(this.tabbedPane));
        this.tabbedPane.setEnabledAt(this.tabbedPane.getTabCount() - 1, false);
        tabPanel.add((Component)this.tabbedPane, "Center");
        tabPanel.add((Component)optionPanel, "South");
        JScrollPane tabScrolPane = new JScrollPane(tabPanel);
        this.contentPanel.add((Component)tabScrolPane, "Center");
    }

    private void updateTabbedPane() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabComponentSample.this.tabbedPane.validate();
                TabComponentSample.this.tabbedPane.repaint();
            }
        });
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabComponentSample app = new TabComponentSample();
                    app.setSize(800, 600);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class AddButton
    extends JButton {
        private static final Dimension PREF_SIZE = new Dimension(16, 15);

        public AddButton() {
            super("+");
            this.setFont(new Font("Dialog", 1, 14));
            this.setForeground(Color.blue);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setContentAreaFilled(false);
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            return PREF_SIZE;
        }
    }

    private static class AddTabComponent
    extends JPanel {
        private JButton addButton = null;
        private JTabbedPane tabPane = null;

        public AddTabComponent(JTabbedPane aTabbedPane) {
            super(new BorderLayout());
            this.tabPane = aTabbedPane;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            this.addButton = new AddButton();
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tabPane.getTabCount() < 20) {
                        int tabIndex = tabPane.getTabCount() - 1;
                        StringBuilder stringBuilder = new StringBuilder("Tab ");
                        int n = tabNo + 1;
                        tabNo = n;
                        String tabTitle = stringBuilder.append(n).append("  ").toString();
                        tabPane.insertTab(tabTitle, null, new JPanel(), null, tabIndex);
                        tabPane.setTabComponentAt(tabIndex, new CloseableTabComponent(tabPane, tabTitle));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (tabPane.getTabCount() > 1) {
                                    tabPane.setSelectedIndex(tabPane.getTabCount() - 2);
                                }
                            }
                        });
                    }
                }
            });
            this.add((Component)this.addButton, "East");
        }
    }

    private static class CloseButton
    extends JButton {
        private static final ImageIcon CLOSER_ICON = ImageHelper.loadImage("closer.gif");
        private static final ImageIcon CLOSER_ROLLOVER_ICON = ImageHelper.loadImage("closer_rollover.gif");
        private static final ImageIcon CLOSER_PRESSED_ICON = ImageHelper.loadImage("closer_pressed.gif");
        private static Dimension prefSize = new Dimension(16, 16);

        public CloseButton() {
            super("");
            this.setIcon(CLOSER_ICON);
            this.setRolloverIcon(CLOSER_ROLLOVER_ICON);
            this.setPressedIcon(CLOSER_PRESSED_ICON);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            prefSize = new Dimension(CLOSER_ICON.getIconWidth(), CLOSER_ICON.getIconHeight());
        }

        @Override
        public Dimension getPreferredSize() {
            return prefSize;
        }
    }

    private static class CloseableTabComponent
    extends JPanel {
        private JTabbedPane tabbedPane = null;
        private JLabel titleLabel = null;
        private JButton closeButton = null;
        private Font defaultFont = null;
        private Font selectedFont = null;
        private Color selectedColor = null;

        public CloseableTabComponent(JTabbedPane aTabbedPane, String title) {
            super(new BorderLayout());
            this.tabbedPane = aTabbedPane;
            this.setOpaque(false);
            this.titleLabel = new JLabel(title);
            this.titleLabel.setOpaque(false);
            this.defaultFont = this.titleLabel.getFont().deriveFont(-2);
            this.selectedFont = this.titleLabel.getFont().deriveFont(1);
            this.selectedColor = UIManager.getColor("TabbedPane.selectedForeground");
            if (this.selectedColor == null) {
                this.selectedColor = this.tabbedPane.getForeground();
            }
            this.closeButton = new CloseButton();
            this.add((Component)this.titleLabel, "Center");
            this.add((Component)this.closeButton, "East");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int tabIndex = this.getTabIndex();
                    if (tabIndex >= 0) {
                        tabbedPane.removeTabAt(tabIndex);
                    }
                    if (tabbedPane.getTabCount() > 1 && tabbedPane.getSelectedIndex() == tabbedPane.getTabCount() - 1) {
                        tabbedPane.setSelectedIndex(tabbedPane.getTabCount() - 2);
                    }
                }
            });
        }

        private int getTabIndex() {
            int i = 0;
            while (i < this.tabbedPane.getTabCount()) {
                if (this.equals(this.tabbedPane.getTabComponentAt(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.titleLabel != null) {
                this.defaultFont = this.titleLabel.getFont().deriveFont(-2);
                this.selectedFont = this.titleLabel.getFont().deriveFont(1);
                this.selectedColor = UIManager.getColor("TabbedPane.selectedForeground");
                if (this.selectedColor == null) {
                    this.selectedColor = this.tabbedPane.getForeground();
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            int tabIndex = this.getTabIndex();
            if (tabIndex >= 0) {
                if (tabIndex == this.tabbedPane.getSelectedIndex()) {
                    this.titleLabel.setFont(this.selectedFont);
                    if (this.tabbedPane.getForegroundAt(tabIndex) instanceof ColorUIResource) {
                        this.titleLabel.setForeground(this.selectedColor);
                    } else {
                        this.titleLabel.setForeground(this.tabbedPane.getForegroundAt(tabIndex));
                    }
                } else {
                    this.titleLabel.setFont(this.defaultFont);
                    this.titleLabel.setForeground(this.tabbedPane.getForegroundAt(tabIndex));
                }
            }
            super.paint(g);
        }
    }
}

