/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.samples.BaseSampleFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LinuxStyleScrollBarSample
extends BaseSampleFrame {
    public LinuxStyleScrollBarSample() {
        super("LinuxStyleScrollBarSample");
        JScrollPane treeScrollPane = new JScrollPane(new JTree());
        treeScrollPane.setMinimumSize(new Dimension(120, 80));
        JTextArea textArea = new JTextArea(this.loadDummyText());
        JScrollPane textAreaScrollPane = new JScrollPane(textArea);
        JSplitPane splitPane = new JSplitPane(1, true, treeScrollPane, textAreaScrollPane);
        splitPane.setDividerLocation(148);
        this.contentPanel.add((Component)splitPane, "Center");
    }

    @Override
    public Properties getLAFProps() {
        Properties props = super.getLAFProps();
        props.put("linuxStyleScrollBar", "on");
        return props;
    }

    private String loadDummyText() {
        try {
            int c;
            InputStream in = LinuxStyleScrollBarSample.class.getResourceAsStream("dummy.txt");
            StringBuilder sb = new StringBuilder();
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Hello Word";
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put("linuxStyleScrollBar", "on");
            AcrylLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LinuxStyleScrollBarSample app = new LinuxStyleScrollBarSample();
                    app.setSize(600, 400);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

