/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DecorationSample
extends JFrame {
    private static final String DECORATION_ARG = "decoration:";
    private static final String DEFAULT_DECORATION = "default";
    private static final String SYSTEM_DECORATION = "system";
    private static final String NO_DECORATION = "none";
    private static String decorationStyle = "default";

    public DecorationSample() {
        super("DecorationSample");
        if (NO_DECORATION.equals(decorationStyle)) {
            this.setUndecorated(true);
        }
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic('N');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...");
        menuItem.setMnemonic('O');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(DecorationSample.this) == 0) {
                    JOptionPane.showMessageDialog(DecorationSample.this, "Your selection: " + fc.getSelectedFile().getName());
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menuItem.setMnemonic('S');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save as");
        menuItem.setMnemonic('a');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        JScrollPane westPanel = new JScrollPane(new JTree());
        JTextArea textArea = new JTextArea("Hello World");
        JScrollPane eastPanel = new JScrollPane(textArea);
        JSplitPane splitPane = new JSplitPane(1, true, westPanel, eastPanel);
        splitPane.setDividerLocation(148);
        contentPanel.add((Component)splitPane, "Center");
        this.setContentPane(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) {
        try {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.startsWith(DECORATION_ARG)) {
                    String style = arg.substring(DECORATION_ARG.length());
                    if (DEFAULT_DECORATION.equals(style)) {
                        decorationStyle = style;
                    } else if (SYSTEM_DECORATION.equals(style)) {
                        decorationStyle = style;
                    } else if (NO_DECORATION.equals(style)) {
                        decorationStyle = style;
                    }
                }
                ++n2;
            }
            Properties props = new Properties();
            props.put("logoString", "my company");
            if (!DEFAULT_DECORATION.equals(decorationStyle)) {
                props.put("windowDecoration", "off");
            }
            HiFiLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.hifi.HiFiLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DecorationSample app = new DecorationSample();
                    app.setSize(400, 300);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

