/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.BaseInternalFrameUI;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.samples.BaseSampleFrame;
import com.jtattoo.samples.icons.ImageHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CustomizedTitlebarSample
extends BaseSampleFrame {
    private TitlebarCheckBox checkBox = null;
    private TitlebarButton button = null;
    private TitlebarMenuButton menuButton = null;
    private JPanel titlebarPanel = null;
    private JDesktopPane desktopPane = null;
    private JInternalFrame internalFrame = null;
    private TitlebarCheckBox ifCheckBox = null;
    private TitlebarButton ifButton = null;
    private TitlebarMenuButton ifMenuButton = null;
    private JPanel ifTitlebarPanel = null;
    private JCheckBox macStyleCheckBox = new JCheckBox("macStyleWindowDecoration");
    private JCheckBox leftToRightCheckBox = new JCheckBox("leftToRight", true);

    public CustomizedTitlebarSample() {
        super("CustomizedTitlebarSample");
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setOpaque(false);
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        checkBoxPanel.add(this.macStyleCheckBox);
        checkBoxPanel.add(this.leftToRightCheckBox);
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.desktopPane.putClientProperty("backgroundTexture", com.jtattoo.samples.textures.ImageHelper.loadImage("DesktopTexture.jpg"));
        this.internalFrame = new JInternalFrame("InternalFrameOne", true, true, true, true);
        this.internalFrame.setBounds(20, 20, 480, 320);
        this.desktopPane.add((Component)this.internalFrame, 0);
        this.internalFrame.setVisible(true);
        this.contentPanel.add((Component)checkBoxPanel, "North");
        this.contentPanel.add((Component)this.desktopPane, "Center");
        this.checkBox = new TitlebarCheckBox("Check");
        this.button = new TitlebarButton("Button");
        this.menuButton = new TitlebarMenuButton("Menu");
        this.titlebarPanel = new JPanel(new TitlebarLayoutManager());
        this.titlebarPanel.setOpaque(false);
        this.titlebarPanel.add(this.checkBox);
        this.titlebarPanel.add(this.button);
        this.titlebarPanel.add(this.menuButton);
        this.ifCheckBox = new TitlebarCheckBox("ifCheck");
        this.ifButton = new TitlebarButton("ifButton");
        this.ifMenuButton = new TitlebarMenuButton("ifMenu");
        this.ifTitlebarPanel = new JPanel(new TitlebarLayoutManager());
        this.ifTitlebarPanel.setOpaque(false);
        this.ifTitlebarPanel.add(this.ifCheckBox);
        this.ifTitlebarPanel.add(this.ifButton);
        this.ifTitlebarPanel.add(this.ifMenuButton);
        if (this.getRootPane().getUI() instanceof BaseRootPaneUI) {
            BaseRootPaneUI rootPaneUI = (BaseRootPaneUI)this.getRootPane().getUI();
            rootPaneUI.getTitlePane().setCustomizedTitlePanel(this.titlebarPanel);
        }
        if (this.internalFrame.getUI() instanceof BaseInternalFrameUI) {
            BaseInternalFrameUI internalFrameUI = (BaseInternalFrameUI)this.internalFrame.getUI();
            internalFrameUI.getTitlePane().setCustomizedTitlePanel(this.ifTitlebarPanel);
        }
        this.macStyleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedTitlebarSample.this.setLookAndFeel();
            }
        });
        this.leftToRightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomizedTitlebarSample.this.leftToRightCheckBox.isSelected()) {
                    CustomizedTitlebarSample.this.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                } else {
                    CustomizedTitlebarSample.this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                CustomizedTitlebarSample.this.validate();
                CustomizedTitlebarSample.this.repaint();
            }
        });
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "CheckBox clicked");
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "Button clicked");
            }
        });
        this.ifCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "ifCheckBox clicked");
            }
        });
        this.ifButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "ifButton clicked");
            }
        });
    }

    public void selectInternalFrame() {
        try {
            this.internalFrame.setSelected(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Properties getLAFProps() {
        Properties props = super.getLAFProps();
        props.put("macStyleWindowDecoration", this.macStyleCheckBox.isSelected() ? "on" : "off");
        return props;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomizedTitlebarSample app = new CustomizedTitlebarSample();
                    app.setSize(800, 600);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                    app.selectInternalFrame();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class TitlebarButton
    extends JButton {
        public TitlebarButton(String title) {
            super(title);
            this.setFocusable(false);
            Border innerBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            Border outerBorder = BorderFactory.createLineBorder(UIManager.getColor("activeCaptionBorder"));
            this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Border innerBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            Border outerBorder = BorderFactory.createLineBorder(UIManager.getColor("activeCaptionBorder"));
            this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        }
    }

    public class TitlebarCheckBox
    extends JCheckBox {
        public TitlebarCheckBox(String title) {
            super(title);
            this.setForeground(UIManager.getColor("activeCaptionText"));
            this.setOpaque(false);
            this.setFocusable(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(UIManager.getColor("activeCaptionText"));
        }
    }

    public class TitlebarLayoutManager
    implements LayoutManager {
        private Dimension preferredSize = null;

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = 0;
            int count = parent.getComponentCount();
            int[] w = new int[count];
            int i = 0;
            while (i < count) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    w[i] = c.getPreferredSize().width;
                    width += w[i];
                    width += 4;
                }
                ++i;
            }
            if (this.preferredSize == null) {
                this.preferredSize = new Dimension(width, parent.getHeight());
            } else {
                this.preferredSize.width = width;
                this.preferredSize.height = parent.getHeight();
            }
            int x = parent.getWidth() - width;
            if (!parent.getComponentOrientation().isLeftToRight()) {
                x = 0;
            }
            int y = 0;
            int h = parent.getHeight() - 2;
            int i2 = 0;
            while (i2 < count) {
                Component c = parent.getComponent(i2);
                if (c.isVisible()) {
                    c.setBounds(x, y, w[i2], h);
                    x += w[i2] + 4;
                }
                ++i2;
            }
        }
    }

    public class TitlebarMenuButton
    extends JButton {
        public TitlebarMenuButton(String title) {
            super(title, ImageHelper.loadImage("DownArrow.gif"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setForeground(UIManager.getColor("activeCaptionText"));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    TitlebarMenuButton.this.setForeground(Color.black);
                    TitlebarMenuButton.this.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TitlebarMenuButton.this.setForeground(UIManager.getColor("activeCaptionText"));
                    TitlebarMenuButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TitlebarMenuButton.this.showPopup();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(UIManager.getColor("activeCaptionText"));
        }

        private void showPopup() {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Menu #1");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "Menu #1 clicked");
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Menu #2");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "Menu #2 clicked");
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Menu #3");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(CustomizedTitlebarSample.this, "Menu #3 clicked");
                }
            });
            popupMenu.add(menuItem);
            if (CustomizedTitlebarSample.this.leftToRightCheckBox.isSelected()) {
                popupMenu.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                popupMenu.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            popupMenu.show(this, 0, this.getHeight() - 1);
        }
    }
}

