/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.texture.TextureLookAndFeel;
import com.jtattoo.samples.textures.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CustomTextureSample
extends JFrame {
    public CustomTextureSample() {
        super("CustomTextureSample");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic('N');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...");
        menuItem.setMnemonic('O');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(CustomTextureSample.this) == 0) {
                    JOptionPane.showMessageDialog(CustomTextureSample.this, "Your selection: " + fc.getSelectedFile().getName());
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menuItem.setMnemonic('S');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save as");
        menuItem.setMnemonic('a');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 8, 10));
        JScrollPane westPanel = new JScrollPane(new JTree());
        JTextArea textArea = new JTextArea("Hello World");
        JScrollPane eastPanel = new JScrollPane(textArea);
        JSplitPane splitPane = new JSplitPane(1, true, westPanel, eastPanel);
        splitPane.setDividerLocation(148);
        contentPanel.add((Component)splitPane, "Center");
        this.setContentPane(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put("textureSet", "Custom");
            ImageIcon texture = ImageHelper.loadImage("WindowTexture.jpg");
            if (texture != null) {
                props.put("windowTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("BackgroundTexture.jpg")) != null) {
                props.put("backgroundTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("AlterBackgroundTexture.jpg")) != null) {
                props.put("alterBackgroundTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("RolloverTexture.gif")) != null) {
                props.put("rolloverTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("RolloverTexture.gif")) != null) {
                props.put("selectedTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("AlterBackgroundTexture.jpg")) != null) {
                props.put("pressedTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("BackgroundTexture.jpg")) != null) {
                props.put("disabledTexture", texture);
            }
            if ((texture = ImageHelper.loadImage("MenubarTexture.jpg")) != null) {
                props.put("menubarTexture", texture);
            }
            props.setProperty("backgroundColor", "240 240 240");
            props.setProperty("backgroundColorLight", "220 220 220");
            props.setProperty("backgroundColorDark", "200 200 200");
            props.setProperty("alterBackgroundColor", "180 180 180");
            props.setProperty("frameColor", "164 164 164");
            props.setProperty("gridColor", "196 196 196");
            props.setProperty("disabledForegroundColor", "96 96 96");
            props.setProperty("disabledBackgroundColor", "240 240 240");
            props.setProperty("rolloverColor", "160 160 160");
            props.setProperty("rolloverColorLight", "230 230 230");
            props.setProperty("rolloverColorDark", "210 210 210");
            props.setProperty("controlBackgroundColor", "248 248 248");
            props.setProperty("controlShadowColor", "160 160 160");
            props.setProperty("controlDarkShadowColor", "110 110 110");
            props.setProperty("controlColorLight", "248 248 248");
            props.setProperty("controlColorDark", " 210 210 210");
            props.setProperty("buttonColorLight", "255 255 255");
            props.setProperty("buttonColorDark", "230 230 230");
            props.setProperty("menuBackgroundColor", "64 64 64");
            props.setProperty("menuColorLight", "96 96 96");
            props.setProperty("menuColorDark", "48 48 48");
            props.setProperty("menuSelectionBackgroundColor", "48 48 48");
            props.setProperty("toolbarBackgroundColor", "64 64 64");
            props.setProperty("toolbarColorLight", "96 96 96");
            props.setProperty("toolbarColorDark", "48 48 48");
            props.setProperty("desktopColor", "220 220 220");
            TextureLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.texture.TextureLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomTextureSample app = new CustomTextureSample();
                    app.setSize(600, 400);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

