/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.samples.BaseSampleFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ColoredTabbedPaneSample
extends BaseSampleFrame {
    private JCheckBox opaqueCheck = new JCheckBox("TabbedPane.opaque", false);
    private JCheckBox contentOpaqueCheck = null;
    private JCheckBox tabsOpaqueCheck = null;
    private JPanel tabPanel = null;
    private JTabbedPane tabbedPane = null;

    public ColoredTabbedPaneSample() {
        super("ColoredTabbedPaneSample");
        this.opaqueCheck.setOpaque(false);
        this.opaqueCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColoredTabbedPaneSample.this.tabbedPane.setOpaque(!ColoredTabbedPaneSample.this.tabbedPane.isOpaque());
                ColoredTabbedPaneSample.this.contentOpaqueCheck.setEnabled(!ColoredTabbedPaneSample.this.opaqueCheck.isSelected());
                ColoredTabbedPaneSample.this.tabsOpaqueCheck.setEnabled(!ColoredTabbedPaneSample.this.opaqueCheck.isSelected());
                ColoredTabbedPaneSample.this.updateTabbedPane();
            }
        });
        this.contentOpaqueCheck = new JCheckBox("TabbedPane.contentOpaque", true);
        this.contentOpaqueCheck.setOpaque(false);
        this.contentOpaqueCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean opaque = true;
                if (UIManager.get("TabbedPane.contentOpaque") != null) {
                    opaque = UIManager.getBoolean("TabbedPane.contentOpaque");
                }
                UIManager.put("TabbedPane.contentOpaque", !opaque);
                ColoredTabbedPaneSample.this.updateTabbedPane();
            }
        });
        this.tabsOpaqueCheck = new JCheckBox("TabbedPane.tabsOpaque", true);
        this.tabsOpaqueCheck.setOpaque(false);
        this.tabsOpaqueCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean opaque = true;
                if (UIManager.get("TabbedPane.tabsOpaque") != null) {
                    opaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
                }
                UIManager.put("TabbedPane.tabsOpaque", !opaque);
                ColoredTabbedPaneSample.this.updateTabbedPane();
            }
        });
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setOpaque(false);
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 8));
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        checkBoxPanel.add(this.opaqueCheck);
        checkBoxPanel.add(this.contentOpaqueCheck);
        checkBoxPanel.add(this.tabsOpaqueCheck);
        JPanel optionPanel = new JPanel();
        optionPanel.setOpaque(false);
        optionPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 8));
        optionPanel.setLayout(new BoxLayout(optionPanel, 0));
        final JRadioButton topCheck = new JRadioButton("Top", true);
        topCheck.setOpaque(false);
        final JRadioButton leftCheck = new JRadioButton("Left", false);
        leftCheck.setOpaque(false);
        final JRadioButton bottomCheck = new JRadioButton("Bottom", false);
        bottomCheck.setOpaque(false);
        JRadioButton rightCheck = new JRadioButton("Right", false);
        rightCheck.setOpaque(false);
        final JCheckBox scrollableCheck = new JCheckBox("ScrollableTabs", false);
        scrollableCheck.setOpaque(false);
        scrollableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (scrollableCheck.isSelected()) {
                    ColoredTabbedPaneSample.this.tabbedPane.setTabLayoutPolicy(1);
                } else {
                    ColoredTabbedPaneSample.this.tabbedPane.setTabLayoutPolicy(0);
                }
                ColoredTabbedPaneSample.this.updateTabbedPane();
            }
        });
        optionPanel.add(topCheck);
        optionPanel.add(leftCheck);
        optionPanel.add(bottomCheck);
        optionPanel.add(rightCheck);
        optionPanel.add(scrollableCheck);
        ButtonGroup orientatioGroup = new ButtonGroup();
        orientatioGroup.add(topCheck);
        orientatioGroup.add(leftCheck);
        orientatioGroup.add(bottomCheck);
        orientatioGroup.add(rightCheck);
        ActionListener orientationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (topCheck.isSelected()) {
                    ColoredTabbedPaneSample.this.tabbedPane.setTabPlacement(1);
                } else if (leftCheck.isSelected()) {
                    ColoredTabbedPaneSample.this.tabbedPane.setTabPlacement(2);
                } else if (bottomCheck.isSelected()) {
                    ColoredTabbedPaneSample.this.tabbedPane.setTabPlacement(3);
                } else {
                    ColoredTabbedPaneSample.this.tabbedPane.setTabPlacement(4);
                }
                ColoredTabbedPaneSample.this.updateTabbedPane();
            }
        };
        topCheck.addActionListener(orientationListener);
        leftCheck.addActionListener(orientationListener);
        bottomCheck.addActionListener(orientationListener);
        rightCheck.addActionListener(orientationListener);
        this.tabPanel = new JPanel(new BorderLayout());
        this.tabPanel.setOpaque(false);
        this.tabPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.tabbedPane = new JTabbedPane();
        JPanel defaultPanel = new JPanel();
        this.tabbedPane.add("Default", defaultPanel);
        JPanel yellowPanel = new JPanel();
        yellowPanel.setBackground(Color.yellow);
        this.tabbedPane.add("Yellow", yellowPanel);
        this.tabbedPane.setBackgroundAt(1, Color.yellow);
        this.tabbedPane.setForegroundAt(1, Color.red);
        JPanel greenPanel = new JPanel();
        greenPanel.setBackground(Color.green);
        this.tabbedPane.add("Green", greenPanel);
        this.tabbedPane.setBackgroundAt(2, Color.green);
        this.tabbedPane.setForegroundAt(2, Color.blue);
        JPanel bluePanel = new JPanel();
        bluePanel.setBackground(Color.blue);
        this.tabbedPane.add("Blue", bluePanel);
        this.tabbedPane.setBackgroundAt(3, Color.blue);
        this.tabbedPane.setForegroundAt(3, Color.magenta);
        JPanel panelTransparent = new JPanel();
        panelTransparent.setOpaque(false);
        this.tabbedPane.add("Transparent", panelTransparent);
        this.tabPanel.add((Component)this.tabbedPane, "Center");
        this.contentPanel.setBackground(new Color(255, 196, 96));
        this.contentPanel.add((Component)checkBoxPanel, "North");
        this.contentPanel.add((Component)this.tabPanel, "Center");
        this.contentPanel.add((Component)optionPanel, "South");
    }

    @Override
    public Properties getLAFProps() {
        Properties props = super.getLAFProps();
        if (this.selectedLaf == 6 || this.selectedLaf == 10) {
            props.put("tabAreaBackgroundColor", "120 80 0");
        } else {
            props.put("tabAreaBackgroundColor", "240 150 0");
        }
        return props;
    }

    @Override
    public void setLookAndFeel() {
        if (this.selectedLaf == 6 || this.selectedLaf == 10) {
            this.contentPanel.setBackground(new Color(128, 96, 48));
        } else {
            this.contentPanel.setBackground(new Color(255, 196, 96));
        }
        super.setLookAndFeel();
    }

    private void updateTabbedPane() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColoredTabbedPaneSample.this.tabPanel.validate();
                ColoredTabbedPaneSample.this.tabPanel.repaint();
            }
        });
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put("tabAreaBackgroundColor", "240 150 0");
            AcrylLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ColoredTabbedPaneSample app = new ColoredTabbedPaneSample();
                    app.setSize(800, 600);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

