/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.bernstein.BernsteinLookAndFeel;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.graphite.GraphiteLookAndFeel;
import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import com.jtattoo.plaf.noire.NoireLookAndFeel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import com.jtattoo.plaf.texture.TextureLookAndFeel;
import com.jtattoo.samples.Constants;
import com.jtattoo.samples.TitleBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BaseSampleFrame
extends JFrame {
    protected JList lafList = null;
    protected int selectedLaf = 0;
    protected ListSelectionListener lafListener = null;
    protected JPanel contentPanel = null;
    protected JSplitPane contentSplitPane = null;
    protected JPanel contentLayoutPanel = null;

    public BaseSampleFrame(String title) {
        super(title);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic('N');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...");
        menuItem.setMnemonic('O');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(BaseSampleFrame.this) == 0) {
                    JOptionPane.showMessageDialog(BaseSampleFrame.this, "Your selection: " + fc.getSelectedFile().getName());
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menuItem.setMnemonic('S');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save as");
        menuItem.setMnemonic('a');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.lafList = new JList<String>(Constants.LAF_NAMES);
        this.lafList.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.lafList.setSelectedIndex(0);
        this.lafList.setSelectionMode(0);
        this.lafListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (BaseSampleFrame.this.lafList.getSelectedIndex() != -1) {
                        if (BaseSampleFrame.this.selectedLaf != BaseSampleFrame.this.lafList.getSelectedIndex()) {
                            BaseSampleFrame.this.selectedLaf = BaseSampleFrame.this.lafList.getSelectedIndex();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BaseSampleFrame.this.setLookAndFeel();
                                }
                            });
                        }
                    } else {
                        BaseSampleFrame.this.lafList.setSelectedIndex(BaseSampleFrame.this.selectedLaf);
                    }
                }
            }
        };
        this.lafList.addListSelectionListener(this.lafListener);
        JScrollPane lafScrollPane = new JScrollPane(this.lafList);
        lafScrollPane.setBorder(new TitleBorder("LookAndFeels"));
        lafScrollPane.setMinimumSize(new Dimension(120, 80));
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentSplitPane = new JSplitPane(1, true, lafScrollPane, this.contentPanel);
        this.contentSplitPane.setDividerLocation(140);
        this.contentLayoutPanel = new JPanel(new BorderLayout());
        this.contentLayoutPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentLayoutPanel.add((Component)this.contentSplitPane, "Center");
        this.setContentPane(this.contentLayoutPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public Properties getLAFProps() {
        return new Properties();
    }

    public void setLookAndFeel() {
        try {
            Window[] windows;
            Properties props = this.getLAFProps();
            switch (this.selectedLaf) {
                case 0: {
                    AcrylLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
                    break;
                }
                case 1: {
                    AeroLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.aero.AeroLookAndFeel");
                    break;
                }
                case 2: {
                    AluminiumLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.aluminium.AluminiumLookAndFeel");
                    break;
                }
                case 3: {
                    BernsteinLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.bernstein.BernsteinLookAndFeel");
                    break;
                }
                case 4: {
                    FastLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.fast.FastLookAndFeel");
                    break;
                }
                case 5: {
                    GraphiteLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.graphite.GraphiteLookAndFeel");
                    break;
                }
                case 6: {
                    HiFiLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.hifi.HiFiLookAndFeel");
                    break;
                }
                case 7: {
                    LunaLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.luna.LunaLookAndFeel");
                    break;
                }
                case 8: {
                    McWinLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
                    break;
                }
                case 9: {
                    MintLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.mint.MintLookAndFeel");
                    break;
                }
                case 10: {
                    NoireLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.noire.NoireLookAndFeel");
                    break;
                }
                case 11: {
                    SmartLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
                    break;
                }
                case 12: {
                    TextureLookAndFeel.setTheme(props);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.texture.TextureLookAndFeel");
                }
            }
            Window[] windowArray = windows = Window.getWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                Window window = windowArray[n2];
                if (window.isDisplayable()) {
                    SwingUtilities.updateComponentTreeUI(window);
                }
                ++n2;
            }
            this.scrollSelectedToVisible(this.lafList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scrollSelectedToVisible(JList list) {
        int idx = list.getLeadSelectionIndex();
        Rectangle rect = list.getCellBounds(idx, idx);
        if (rect != null) {
            list.scrollRectToVisible(rect);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseSampleFrame app = new BaseSampleFrame("BaseSampleFrame");
                    app.setSize(800, 600);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

