/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.samples;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.bernstein.BernsteinLookAndFeel;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.graphite.GraphiteLookAndFeel;
import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import com.jtattoo.plaf.noire.NoireLookAndFeel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import com.jtattoo.plaf.texture.TextureLookAndFeel;
import com.jtattoo.samples.Constants;
import com.jtattoo.samples.TitleBorder;
import com.jtattoo.samples.icons.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdvancedLookAndFeelSample
extends JFrame {
    private JList lafList = null;
    private int selectedLaf = 0;
    private ListSelectionListener lafListener = null;
    private JList themeList = null;
    private int selectedTheme = 0;
    private ListSelectionListener themeListener = null;
    private JSplitPane lafSplitPane = null;
    private JPanel contentPanel = null;
    private JSplitPane contentSplitPane = null;
    private JPanel contentLayoutPanel = null;
    private TitlebarCheckBox checkBox = null;
    private TitlebarButton button = null;
    private TitlebarMenuButton menuButton = null;
    private JPanel titlebarPanel = null;

    public AdvancedLookAndFeelSample() {
        super("AdvancedLookAndFeelSample");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic('N');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...");
        menuItem.setMnemonic('O');
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(AdvancedLookAndFeelSample.this) == 0) {
                    JOptionPane.showMessageDialog(AdvancedLookAndFeelSample.this, "Your selection: " + fc.getSelectedFile().getName());
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menuItem.setMnemonic('S');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save as");
        menuItem.setMnemonic('a');
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.lafList = new JList<String>(Constants.LAF_NAMES);
        this.lafList.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.lafList.setSelectedIndex(0);
        this.lafList.setSelectionMode(0);
        this.lafListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (AdvancedLookAndFeelSample.this.lafList.getSelectedIndex() != -1) {
                        if (AdvancedLookAndFeelSample.this.selectedLaf != AdvancedLookAndFeelSample.this.lafList.getSelectedIndex()) {
                            AdvancedLookAndFeelSample.this.selectedLaf = AdvancedLookAndFeelSample.this.lafList.getSelectedIndex();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AdvancedLookAndFeelSample.this.setLookAndFeel(true);
                                }
                            });
                        }
                    } else {
                        AdvancedLookAndFeelSample.this.lafList.setSelectedIndex(AdvancedLookAndFeelSample.this.selectedLaf);
                    }
                }
            }
        };
        this.lafList.addListSelectionListener(this.lafListener);
        JScrollPane lafScrollPane = new JScrollPane(this.lafList);
        lafScrollPane.setBorder(new TitleBorder("LookAndFeels"));
        this.themeList = new JList();
        this.themeList.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.themeList.setSelectionMode(0);
        this.fillThemeList();
        this.themeListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (AdvancedLookAndFeelSample.this.themeList.getSelectedIndex() != -1) {
                        if (AdvancedLookAndFeelSample.this.selectedTheme != AdvancedLookAndFeelSample.this.themeList.getSelectedIndex()) {
                            AdvancedLookAndFeelSample.this.selectedTheme = AdvancedLookAndFeelSample.this.themeList.getSelectedIndex();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AdvancedLookAndFeelSample.this.setLookAndFeel(false);
                                }
                            });
                        }
                    } else {
                        AdvancedLookAndFeelSample.this.themeList.setSelectedIndex(AdvancedLookAndFeelSample.this.selectedTheme);
                    }
                }
            }
        };
        this.themeList.addListSelectionListener(this.themeListener);
        JScrollPane themeScrollPane = new JScrollPane(this.themeList);
        themeScrollPane.setBorder(new TitleBorder("Themes"));
        this.lafSplitPane = new JSplitPane(0, true, lafScrollPane, themeScrollPane);
        this.lafSplitPane.putClientProperty("textureType", new Integer(0));
        this.lafSplitPane.setDividerLocation(200);
        this.contentPanel = new JPanel(new BorderLayout());
        JScrollPane westPanel = new JScrollPane(new JTree());
        westPanel.setBorder(new TitleBorder("Tree"));
        JTextArea textArea = new JTextArea("Hello World");
        JScrollPane eastPanel = new JScrollPane(textArea);
        eastPanel.setBorder(new TitleBorder("TextArea"));
        JSplitPane splitPane = new JSplitPane(1, true, westPanel, eastPanel);
        splitPane.setDividerLocation(150);
        splitPane.putClientProperty("textureType", new Integer(0));
        this.contentPanel.add((Component)splitPane, "Center");
        this.contentSplitPane = new JSplitPane(1, true, this.lafSplitPane, this.contentPanel);
        this.contentSplitPane.putClientProperty("textureType", new Integer(0));
        this.contentSplitPane.setDividerLocation(160);
        this.contentLayoutPanel = new JPanel(new BorderLayout());
        this.contentLayoutPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentLayoutPanel.putClientProperty("textureType", new Integer(0));
        this.contentLayoutPanel.add((Component)this.contentSplitPane, "Center");
        this.setContentPane(this.contentLayoutPanel);
        this.checkBox = new TitlebarCheckBox("Check");
        this.button = new TitlebarButton("Button");
        this.menuButton = new TitlebarMenuButton("Menu");
        this.titlebarPanel = new JPanel(new TitlebarLayoutManager());
        this.titlebarPanel.setOpaque(false);
        this.titlebarPanel.add(this.checkBox);
        this.titlebarPanel.add(this.button);
        this.titlebarPanel.add(this.menuButton);
        if (this.getRootPane().getUI() instanceof BaseRootPaneUI) {
            BaseRootPaneUI rootPaneUI = (BaseRootPaneUI)this.getRootPane().getUI();
            rootPaneUI.getTitlePane().setCustomizedTitlePanel(this.titlebarPanel);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void setLookAndFeel(boolean loadThemes) {
        try {
            Window[] windows;
            String theme = "Default";
            if (!loadThemes) {
                theme = (String)this.themeList.getSelectedValue();
            }
            switch (this.selectedLaf) {
                case 0: {
                    AcrylLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
                    break;
                }
                case 1: {
                    AeroLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.aero.AeroLookAndFeel");
                    break;
                }
                case 2: {
                    AluminiumLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.aluminium.AluminiumLookAndFeel");
                    break;
                }
                case 3: {
                    BernsteinLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.bernstein.BernsteinLookAndFeel");
                    break;
                }
                case 4: {
                    FastLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.fast.FastLookAndFeel");
                    break;
                }
                case 5: {
                    GraphiteLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.graphite.GraphiteLookAndFeel");
                    break;
                }
                case 6: {
                    HiFiLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.hifi.HiFiLookAndFeel");
                    break;
                }
                case 7: {
                    LunaLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.luna.LunaLookAndFeel");
                    break;
                }
                case 8: {
                    McWinLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
                    break;
                }
                case 9: {
                    MintLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.mint.MintLookAndFeel");
                    break;
                }
                case 10: {
                    NoireLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.noire.NoireLookAndFeel");
                    break;
                }
                case 11: {
                    SmartLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
                    break;
                }
                case 12: {
                    TextureLookAndFeel.setTheme(theme);
                    UIManager.setLookAndFeel("com.jtattoo.plaf.texture.TextureLookAndFeel");
                }
            }
            Window[] windowArray = windows = Window.getWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                Window window = windowArray[n2];
                if (window.isDisplayable()) {
                    SwingUtilities.updateComponentTreeUI(window);
                }
                ++n2;
            }
            if (loadThemes) {
                this.fillThemeList();
            }
            this.scrollSelectedToVisible(this.lafList);
            this.scrollSelectedToVisible(this.themeList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fillThemeList() {
        this.themeList.removeListSelectionListener(this.themeListener);
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof AcrylLookAndFeel) {
            this.themeList.setListData(AcrylLookAndFeel.getThemes().toArray());
        } else if (laf instanceof AeroLookAndFeel) {
            this.themeList.setListData(AeroLookAndFeel.getThemes().toArray());
        } else if (laf instanceof AluminiumLookAndFeel) {
            this.themeList.setListData(AluminiumLookAndFeel.getThemes().toArray());
        } else if (laf instanceof BernsteinLookAndFeel) {
            this.themeList.setListData(BernsteinLookAndFeel.getThemes().toArray());
        } else if (laf instanceof FastLookAndFeel) {
            this.themeList.setListData(FastLookAndFeel.getThemes().toArray());
        } else if (laf instanceof GraphiteLookAndFeel) {
            this.themeList.setListData(GraphiteLookAndFeel.getThemes().toArray());
        } else if (laf instanceof HiFiLookAndFeel) {
            this.themeList.setListData(HiFiLookAndFeel.getThemes().toArray());
        } else if (laf instanceof LunaLookAndFeel) {
            this.themeList.setListData(LunaLookAndFeel.getThemes().toArray());
        } else if (laf instanceof McWinLookAndFeel) {
            this.themeList.setListData(McWinLookAndFeel.getThemes().toArray());
        } else if (laf instanceof MintLookAndFeel) {
            this.themeList.setListData(MintLookAndFeel.getThemes().toArray());
        } else if (laf instanceof NoireLookAndFeel) {
            this.themeList.setListData(NoireLookAndFeel.getThemes().toArray());
        } else if (laf instanceof SmartLookAndFeel) {
            this.themeList.setListData(SmartLookAndFeel.getThemes().toArray());
        } else if (laf instanceof TextureLookAndFeel) {
            this.themeList.setListData(TextureLookAndFeel.getThemes().toArray());
        } else {
            this.themeList.setListData((E[])null);
        }
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            this.themeList.setSelectedValue("Default", true);
        }
        this.selectedTheme = this.themeList.getSelectedIndex();
        this.themeList.addListSelectionListener(this.themeListener);
    }

    private void scrollSelectedToVisible(JList list) {
        int idx = list.getLeadSelectionIndex();
        Rectangle rect = list.getCellBounds(idx, idx);
        if (rect != null) {
            list.scrollRectToVisible(rect);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdvancedLookAndFeelSample app = new AdvancedLookAndFeelSample();
                    app.setSize(640, 480);
                    app.setLocationRelativeTo(null);
                    app.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class TitlebarButton
    extends JButton {
        public TitlebarButton(String title) {
            super(title);
            this.setFocusable(false);
            Border innerBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            Border outerBorder = BorderFactory.createLineBorder(UIManager.getColor("activeCaptionBorder"));
            this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Border innerBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            Border outerBorder = BorderFactory.createLineBorder(UIManager.getColor("activeCaptionBorder"));
            this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        }
    }

    public class TitlebarCheckBox
    extends JCheckBox {
        public TitlebarCheckBox(String title) {
            super(title);
            this.setForeground(UIManager.getColor("activeCaptionText"));
            this.setOpaque(false);
            this.setFocusable(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(UIManager.getColor("activeCaptionText"));
        }
    }

    public class TitlebarLayoutManager
    implements LayoutManager {
        private Dimension preferredSize = null;

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = 0;
            int count = parent.getComponentCount();
            int[] w = new int[count];
            int i = 0;
            while (i < count) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    w[i] = c.getPreferredSize().width;
                    width += w[i];
                    width += 4;
                }
                ++i;
            }
            if (this.preferredSize == null) {
                this.preferredSize = new Dimension(width, parent.getHeight());
            } else {
                this.preferredSize.width = width;
                this.preferredSize.height = parent.getHeight();
            }
            int x = parent.getWidth() - width;
            if (!parent.getComponentOrientation().isLeftToRight()) {
                x = 0;
            }
            int y = 0;
            int h = parent.getHeight() - 2;
            int i2 = 0;
            while (i2 < count) {
                Component c = parent.getComponent(i2);
                if (c.isVisible()) {
                    c.setBounds(x, y, w[i2], h);
                    x += w[i2] + 4;
                }
                ++i2;
            }
        }
    }

    public class TitlebarMenuButton
    extends JButton {
        public TitlebarMenuButton(String title) {
            super(title, ImageHelper.loadImage("DownArrow.gif"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setForeground(UIManager.getColor("activeCaptionText"));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    TitlebarMenuButton.this.setForeground(Color.black);
                    TitlebarMenuButton.this.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TitlebarMenuButton.this.setForeground(UIManager.getColor("activeCaptionText"));
                    TitlebarMenuButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TitlebarMenuButton.this.showPopup();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(UIManager.getColor("activeCaptionText"));
        }

        private void showPopup() {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Menu #1");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(AdvancedLookAndFeelSample.this, "Menu #1 clicked");
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Menu #2");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(AdvancedLookAndFeelSample.this, "Menu #2 clicked");
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Menu #3");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(AdvancedLookAndFeelSample.this, "Menu #3 clicked");
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this, 0, this.getHeight() - 1);
        }
    }
}

