/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class TextureLabelUI
extends BasicLabelUI {
    private static TextureLabelUI hifiLabelUI = null;

    public static ComponentUI createUI(JComponent c) {
        if (hifiLabelUI == null) {
            hifiLabelUI = new TextureLabelUI();
        }
        return hifiLabelUI;
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = -1;
        mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? l.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(l.getText(), l.getDisplayedMnemonic());
        Color fc = l.getForeground();
        if (AbstractLookAndFeel.getTheme().isTextShadowOn() && ColorHelper.getGrayValue(fc) > 164) {
            g.setColor(Color.black);
            JTattooUtilities.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY + 1);
        } else {
            Object sc = l.getClientProperty("shadowColor");
            if (sc instanceof Color) {
                g.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY + 1);
            }
        }
        g.setColor(fc);
        JTattooUtilities.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = -1;
        mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? l.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(l.getText(), l.getDisplayedMnemonic());
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
        g2D.setComposite(alpha);
        Color fc = l.getForeground();
        if (ColorHelper.getGrayValue(fc) > 164) {
            fc = ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0);
            g.setColor(Color.black);
        } else {
            fc = AbstractLookAndFeel.getDisabledForegroundColor();
            g.setColor(Color.white);
        }
        JTattooUtilities.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY + 1);
        g2D.setComposite(savedComposite);
        g.setColor(fc);
        JTattooUtilities.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }
}

