/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

public class SmartInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public SmartInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    public void paintPalette(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Color backColor = null;
        Color frameColor = null;
        if (JTattooUtilities.isFrameActive(this)) {
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, width, height);
            backColor = AbstractLookAndFeel.getTheme().getWindowTitleColors()[10];
            frameColor = ColorHelper.darker(AbstractLookAndFeel.getWindowTitleColorDark(), 15.0);
        } else {
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, width, height);
            backColor = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
            frameColor = ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveTitleColorDark(), 15.0);
        }
        g.setColor(frameColor);
        g.drawLine(0, height - 1, width, height - 1);
        int dx = 8;
        int dy = 2;
        int dw = width - this.buttonsWidth - 16;
        Graphics2D g2D = (Graphics2D)g;
        Composite composite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
        g2D.setComposite(alpha);
        float dc1 = 50.0f;
        float dc2 = 5.0f;
        Color c1 = ColorHelper.brighter(backColor, dc1);
        Color c2 = null;
        while (dy + 2 < height) {
            c2 = ColorHelper.darker(backColor, dc2);
            dc2 += 5.0f;
            g.setColor(c1);
            g.drawLine(dx, dy, dx + dw, dy);
            g.setColor(c2);
            g.drawLine(dx, ++dy, dx + dw, dy);
            dy += 2;
        }
        g2D.setComposite(composite);
    }

    @Override
    public void paintBackground(Graphics g) {
        int dx;
        int dw;
        boolean leftToRight;
        int xOffset;
        Graphics2D g2D = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        Color backColor = null;
        Color frameColor = null;
        if (JTattooUtilities.isActive(this)) {
            backColor = AbstractLookAndFeel.getTheme().getWindowTitleColors()[10];
            frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, width, height);
        } else {
            backColor = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
            frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0);
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, width, height);
        }
        int iconWidth = 0;
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            iconWidth = icon.getIconWidth() + 5;
        }
        int titleWidth = 0;
        String frameTitle = this.frame.getTitle();
        if (frameTitle != null) {
            g.setFont(this.getFont());
            FontMetrics fm = JTattooUtilities.getFontMetrics(this, g, this.getFont());
            titleWidth = fm.stringWidth(JTattooUtilities.getClippedText(this.frame.getTitle(), fm, this.getWidth() - iconWidth - this.buttonsWidth - 15)) + 10;
        }
        int n = xOffset = (leftToRight = JTattooUtilities.isLeftToRight(this.frame)) ? iconWidth + 10 + titleWidth : width - 10 - iconWidth - titleWidth;
        if (leftToRight) {
            dw = width - this.buttonsWidth - xOffset - 10;
            dx = xOffset;
        } else {
            dw = xOffset - this.buttonsWidth - 10;
            dx = this.buttonsWidth + 10;
        }
        int dy = 3;
        if (!AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() && !AbstractLookAndFeel.getTheme().isCenterWindowTitleOn() && dw > 0) {
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            float dc1 = 50.0f;
            float dc2 = 5.0f;
            Color c1 = ColorHelper.brighter(backColor, dc1);
            Color c2 = null;
            while (dy + 5 < height) {
                c2 = ColorHelper.darker(backColor, dc2);
                dc2 += 5.0f;
                g.setColor(c1);
                g.drawLine(dx, dy, dx + dw, dy);
                g.setColor(c2);
                g.drawLine(dx, ++dy, dx + dw, dy);
                dy += 3;
            }
            g2D.setComposite(composite);
        }
        g.setColor(frameColor);
        g.drawLine(0, height - 1, width, height - 1);
    }

    @Override
    public void paintBorder(Graphics g) {
    }

    @Override
    public void paintText(Graphics g, int x, int y, String title) {
        if (this.isActive()) {
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(titleColor) > 164) {
                g.setColor(Color.black);
                JTattooUtilities.drawString(this.frame, g, title, x + 1, y);
            }
            g.setColor(titleColor);
            JTattooUtilities.drawString(this.frame, g, title, x, y - 1);
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g, title, x, y - 1);
        }
    }
}

