/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractBorderFactory;
import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.BaseCheckBoxMenuItemUI;
import com.jtattoo.plaf.BaseCheckBoxUI;
import com.jtattoo.plaf.BaseDesktopPaneUI;
import com.jtattoo.plaf.BaseEditorPaneUI;
import com.jtattoo.plaf.BaseFileChooserUI;
import com.jtattoo.plaf.BaseFormattedTextFieldUI;
import com.jtattoo.plaf.BaseLabelUI;
import com.jtattoo.plaf.BaseMenuItemUI;
import com.jtattoo.plaf.BaseMenuUI;
import com.jtattoo.plaf.BasePanelUI;
import com.jtattoo.plaf.BasePasswordFieldUI;
import com.jtattoo.plaf.BasePopupMenuUI;
import com.jtattoo.plaf.BaseProgressBarUI;
import com.jtattoo.plaf.BaseRadioButtonMenuItemUI;
import com.jtattoo.plaf.BaseRadioButtonUI;
import com.jtattoo.plaf.BaseScrollPaneUI;
import com.jtattoo.plaf.BaseSeparatorUI;
import com.jtattoo.plaf.BaseSliderUI;
import com.jtattoo.plaf.BaseSpinnerUI;
import com.jtattoo.plaf.BaseSplitPaneUI;
import com.jtattoo.plaf.BaseTableHeaderUI;
import com.jtattoo.plaf.BaseTableUI;
import com.jtattoo.plaf.BaseTextAreaUI;
import com.jtattoo.plaf.BaseTextFieldUI;
import com.jtattoo.plaf.BaseToolTipUI;
import com.jtattoo.plaf.BaseTreeUI;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mint.MintBorderFactory;
import com.jtattoo.plaf.mint.MintButtonUI;
import com.jtattoo.plaf.mint.MintComboBoxUI;
import com.jtattoo.plaf.mint.MintDefaultTheme;
import com.jtattoo.plaf.mint.MintIconFactory;
import com.jtattoo.plaf.mint.MintInternalFrameUI;
import com.jtattoo.plaf.mint.MintMenuBarUI;
import com.jtattoo.plaf.mint.MintRootPaneUI;
import com.jtattoo.plaf.mint.MintScrollBarUI;
import com.jtattoo.plaf.mint.MintTabbedPaneUI;
import com.jtattoo.plaf.mint.MintToggleButtonUI;
import com.jtattoo.plaf.mint.MintToolBarUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;

public class MintLookAndFeel
extends AbstractLookAndFeel {
    private static MintDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        MintLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(String name, String licenseKey, String logoString) {
        Properties props = (Properties)themesMap.get(name);
        if (props != null) {
            props.put("licenseKey", licenseKey);
            props.put("logoString", logoString);
            MintLookAndFeel.setTheme(props);
            if (myTheme != null) {
                AbstractTheme.setInternalName(name);
            }
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "mintTheme";
        if (myTheme == null) {
            myTheme = new MintDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        MintLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "Mint";
    }

    @Override
    public String getID() {
        return "Mint";
    }

    @Override
    public String getDescription() {
        return "The Mint Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return MintBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return MintIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new MintDefaultTheme();
        }
        MintLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.put("ScrollBar.incrementButtonGap", new Integer(-1));
        table.put("ScrollBar.decrementButtonGap", new Integer(-1));
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"mintTheme".equals(currentThemeName)) {
            MintLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"LabelUI", BaseLabelUI.class.getName(), "SeparatorUI", BaseSeparatorUI.class.getName(), "RadioButtonUI", BaseRadioButtonUI.class.getName(), "CheckBoxUI", BaseCheckBoxUI.class.getName(), "TextFieldUI", BaseTextFieldUI.class.getName(), "TextAreaUI", BaseTextAreaUI.class.getName(), "EditorPaneUI", BaseEditorPaneUI.class.getName(), "PasswordFieldUI", BasePasswordFieldUI.class.getName(), "ToolTipUI", BaseToolTipUI.class.getName(), "TreeUI", BaseTreeUI.class.getName(), "TableUI", BaseTableUI.class.getName(), "TableHeaderUI", BaseTableHeaderUI.class.getName(), "PanelUI", BasePanelUI.class.getName(), "ScrollPaneUI", BaseScrollPaneUI.class.getName(), "ProgressBarUI", BaseProgressBarUI.class.getName(), "SliderUI", BaseSliderUI.class.getName(), "SplitPaneUI", BaseSplitPaneUI.class.getName(), "FileChooserUI", BaseFileChooserUI.class.getName(), "MenuUI", BaseMenuUI.class.getName(), "PopupMenuUI", BasePopupMenuUI.class.getName(), "MenuItemUI", BaseMenuItemUI.class.getName(), "CheckBoxMenuItemUI", BaseCheckBoxMenuItemUI.class.getName(), "RadioButtonMenuItemUI", BaseRadioButtonMenuItemUI.class.getName(), "PopupMenuSeparatorUI", BaseSeparatorUI.class.getName(), "DesktopPaneUI", BaseDesktopPaneUI.class.getName(), "ButtonUI", MintButtonUI.class.getName(), "ToggleButtonUI", MintToggleButtonUI.class.getName(), "ComboBoxUI", MintComboBoxUI.class.getName(), "TabbedPaneUI", MintTabbedPaneUI.class.getName(), "ScrollBarUI", MintScrollBarUI.class.getName(), "ToolBarUI", MintToolBarUI.class.getName(), "MenuBarUI", MintMenuBarUI.class.getName(), "InternalFrameUI", MintInternalFrameUI.class.getName(), "RootPaneUI", MintRootPaneUI.class.getName()};
        table.putDefaults(uiDefaults);
        if (JTattooUtilities.getJavaVersion() >= 1.5) {
            table.put("FormattedTextFieldUI", BaseFormattedTextFieldUI.class.getName());
            table.put("SpinnerUI", BaseSpinnerUI.class.getName());
        }
    }
}

