/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class McWinInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public McWinInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected LayoutManager createLayout() {
        return new MyTitlePaneLayout();
    }

    @Override
    public void paintBorder(Graphics g) {
        if (JTattooUtilities.isActive(this)) {
            g.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    @Override
    public void paintText(Graphics g, int x, int y, String title) {
        if (this.isActive()) {
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.frame, g, title, x, y - 1);
            g.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g, title, x, y - 2);
        } else {
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowInactiveTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.frame, g, title, x, y - 1);
            g.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g, title, x, y - 2);
        }
    }

    class MyTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        MyTitlePaneLayout() {
            super(McWinInternalFrameTitlePane.this);
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (McWinInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (McWinInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (McWinInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = JTattooUtilities.getFontMetrics(McWinInternalFrameTitlePane.this, null, McWinInternalFrameTitlePane.this.getFont());
            String frameTitle = McWinInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(String.valueOf(McWinInternalFrameTitlePane.this.frame.getTitle().substring(0, 2)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = McWinInternalFrameTitlePane.this.paletteTitleHeight;
            if (!McWinInternalFrameTitlePane.this.isPalette) {
                int fontHeight = fm.getHeight() + 5;
                Icon icon = McWinInternalFrameTitlePane.this.isMacStyleWindowDecoration() ? null : McWinInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 18);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c);
            } else {
                this.layoutDefault(c);
            }
        }

        public void layoutDefault(Container c) {
            int buttonHeight;
            boolean leftToRight = JTattooUtilities.isLeftToRight(McWinInternalFrameTitlePane.this.frame);
            int spacing = McWinInternalFrameTitlePane.this.getHorSpacing();
            int w = McWinInternalFrameTitlePane.this.getWidth();
            int h = McWinInternalFrameTitlePane.this.getHeight();
            int buttonWidth = buttonHeight = h - McWinInternalFrameTitlePane.this.getVerSpacing() - 1;
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h - buttonHeight) / 2 - 1);
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                McWinInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            McWinInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (McWinInternalFrameTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - McWinInternalFrameTitlePane.this.buttonsWidth - spacing - 20;
                Icon icon = McWinInternalFrameTitlePane.this.frame.getFrameIcon();
                if (icon != null) {
                    maxWidth -= icon.getIconWidth();
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, ((McWinInternalFrameTitlePane)McWinInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width);
                int cph = h;
                int cpx = leftToRight ? w - McWinInternalFrameTitlePane.this.buttonsWidth - cpw : McWinInternalFrameTitlePane.this.buttonsWidth;
                int cpy = 0;
                McWinInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                McWinInternalFrameTitlePane mcWinInternalFrameTitlePane = McWinInternalFrameTitlePane.this;
                mcWinInternalFrameTitlePane.buttonsWidth = mcWinInternalFrameTitlePane.buttonsWidth + ((McWinInternalFrameTitlePane)McWinInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c) {
            int btnHeight;
            int spacing = McWinInternalFrameTitlePane.this.getHorSpacing();
            int h = McWinInternalFrameTitlePane.this.getHeight();
            int btnWidth = btnHeight = h - McWinInternalFrameTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                McWinInternalFrameTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.iconButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            McWinInternalFrameTitlePane.this.buttonsWidth = x;
            if (McWinInternalFrameTitlePane.this.customTitlePanel != null) {
                int cpx = McWinInternalFrameTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((McWinInternalFrameTitlePane)McWinInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h;
                McWinInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                McWinInternalFrameTitlePane mcWinInternalFrameTitlePane = McWinInternalFrameTitlePane.this;
                mcWinInternalFrameTitlePane.buttonsWidth = mcWinInternalFrameTitlePane.buttonsWidth + (cpw + 5);
            }
        }
    }
}

