/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class McWinIcons
extends BaseIcons {
    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new BaseIcons.MacIconIcon();
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new BaseIcons.MacMinIcon();
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new BaseIcons.MacMaxIcon();
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new BaseIcons.MacCloseIcon();
        }
        return closeIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = new ThumbIcon(false);
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = new ThumbIcon(false);
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = new ThumbIcon(true);
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = new ThumbIcon(true);
        }
        return thumbVerIconRollover;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int GAP = 4;
        private static final Icon SMALL_CHECK_ICON = new LazyImageIcon("mcwin/icons/small/check_symbol_16x11.png");
        private static final Icon SMALL_CHECK_DISABLED_ICON = new LazyImageIcon("mcwin/icons/small/check_symbol_disabled_16x11.png");
        private static final Icon MEDIUM_CHECK_ICON = new LazyImageIcon("mcwin/icons/medium/check_symbol_18x13.png");
        private static final Icon MEDIUM_CHECK_DISABLED_ICON = new LazyImageIcon("mcwin/icons/medium/check_symbol_disabled_18x13.png");
        private static final Icon LARGE_CHECK_ICON = new LazyImageIcon("mcwin/icons/large/check_symbol_20x15.png");
        private static final Icon LARGE_CHECK_DISABLED_ICON = new LazyImageIcon("mcwin/icons/large/check_symbol_disabled_20x15.png");

        private CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon checkDisabledIcon;
            Icon checkIcon;
            Color[] colors;
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 4;
            }
            int w = this.getIconWidth() - 4;
            int h = this.getIconHeight();
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color frameColor = AbstractLookAndFeel.getFrameColor();
            if (button.isEnabled()) {
                colors = button.isRolloverEnabled() && model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isFrameActive(button) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (button.isSelected() ? AbstractLookAndFeel.getTheme().getDefaultColors() : AbstractLookAndFeel.getTheme().getCheckBoxColors()));
            } else {
                colors = AbstractLookAndFeel.getTheme().getDisabledColors();
                frameColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0);
            }
            JTattooUtilities.fillHorGradient(g, colors, x + 1, y + 1, w - 1, h - 1);
            g.setColor(frameColor);
            g.drawRect(x, y, w, h);
            if (button.isEnabled() && !model.isRollover() && !model.isPressed() && !model.isSelected()) {
                g.setColor(Color.white);
                g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            }
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                checkIcon = SMALL_CHECK_ICON;
                checkDisabledIcon = SMALL_CHECK_DISABLED_ICON;
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                checkIcon = MEDIUM_CHECK_ICON;
                checkDisabledIcon = MEDIUM_CHECK_DISABLED_ICON;
            } else {
                checkIcon = LARGE_CHECK_ICON;
                checkDisabledIcon = LARGE_CHECK_DISABLED_ICON;
            }
            if (model.isPressed() && model.isArmed()) {
                ColorUIResource bc = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
                Color fc = ColorHelper.darker(bc, 40.0);
                g.setColor(fc);
                g.drawRect(x + 3, y + 3, w - 6, h - 6);
                g.setColor(bc);
                g.fillRect(x + 4, y + 4, w - 7, h - 7);
            } else if (model.isSelected()) {
                int xi = x + (w - checkIcon.getIconWidth()) / 2 + 4;
                int yi = y + (h - checkIcon.getIconHeight()) / 2;
                if (model.isEnabled()) {
                    checkIcon.paintIcon(c, g, xi, yi);
                } else {
                    checkDisabledIcon.paintIcon(c, g, xi, yi);
                }
            }
        }

        @Override
        public int getIconWidth() {
            int w = AbstractLookAndFeel.getTheme().isSmallFontSize() ? 13 : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? 15 : 17);
            return w + 4;
        }

        @Override
        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 13;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 15;
            }
            return 17;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int GAP = 2;

        private RadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 2;
            }
            int w = this.getIconWidth() - 2;
            int h = this.getIconHeight();
            Graphics2D g2D = (Graphics2D)g;
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color[] colors = button.isEnabled() ? (button.isRolloverEnabled() && model.isRollover() || model.isPressed() && model.isArmed() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isFrameActive(button) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (button.isSelected() ? AbstractLookAndFeel.getTheme().getDefaultColors() : AbstractLookAndFeel.getTheme().getCheckBoxColors()))) : AbstractLookAndFeel.getTheme().getDisabledColors();
            Shape savedClip = g.getClip();
            Area clipArea = new Area(new Ellipse2D.Double(x, y, w + 1, h + 1));
            if (savedClip != null) {
                clipArea.intersect(new Area(savedClip));
            }
            g2D.setClip(clipArea);
            JTattooUtilities.fillHorGradient(g, colors, x, y, w, h);
            g2D.setClip(savedClip);
            if (button.isEnabled()) {
                g2D.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                g2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
            }
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawOval(x, y, w, h);
            if (model.isSelected()) {
                if (model.isEnabled()) {
                    int gv = ColorHelper.getGrayValue(colors[0]);
                    if (gv > 128) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                } else {
                    g.setColor(AbstractLookAndFeel.getTheme().getDisabledForegroundColor());
                }
                if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                    g2D.fillOval(x + 4, y + 4, w - 7, h - 7);
                } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                    g2D.fillOval(x + 4, y + 4, w - 7, h - 7);
                } else {
                    g2D.fillOval(x + 5, y + 5, w - 9, h - 9);
                }
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        @Override
        public int getIconWidth() {
            int w = AbstractLookAndFeel.getTheme().isSmallFontSize() ? 14 : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? 16 : 18);
            return w + 2;
        }

        @Override
        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 16;
            }
            return 18;
        }
    }

    private static class ThumbIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int WIDTH = 15;
        private static final int HEIGHT = 15;
        private boolean isRollover = false;

        public ThumbIcon(boolean isRollover) {
            this.isRollover = isRollover;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            Color[] colors = null;
            colors = this.isRollover ? AbstractLookAndFeel.getTheme().getRolloverColors() : (AbstractLookAndFeel.getTheme().isBrightMode() ? AbstractLookAndFeel.getTheme().getButtonColors() : AbstractLookAndFeel.getTheme().getSelectedColors());
            Shape savedClip = g2D.getClip();
            if (savedClip != null) {
                Area clipArea = new Area(new Ellipse2D.Double(x + 1, y + 1, 15.0, 15.0));
                if (savedClip != null) {
                    clipArea.intersect(new Area(savedClip));
                }
                g2D.setClip(clipArea);
                JTattooUtilities.fillHorGradient(g, colors, x + 1, y + 1, 15, 15);
                g2D.setClip(savedClip);
            } else {
                Area ellipseArea = new Area(new Ellipse2D.Double(x + 1, y + 1, 15.0, 15.0));
                g2D.setClip(ellipseArea);
                JTattooUtilities.fillHorGradient(g, colors, x, y, 15, 15);
                g2D.setClip(null);
            }
            g2D.setColor(AbstractLookAndFeel.getFrameColor());
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawOval(x + 1, y + 1, 14, 14);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        @Override
        public int getIconWidth() {
            return 17;
        }

        @Override
        public int getIconHeight() {
            return 17;
        }
    }
}

