/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class McWinBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return McWinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getTabbedPaneBorder() {
        return null;
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
                return new Insets(3, 4, 3, 4);
            }
            return new Insets(2, 12, 2, 12);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean active = this.isActive(c);
            boolean resizable = this.isResizable(c);
            int th = this.getTitleHeight(c);
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveTitleColorDark();
            if (active) {
                frameColor = AbstractLookAndFeel.getWindowBorderColor();
                titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
                borderColor = AbstractLookAndFeel.getWindowTitleColorDark();
            }
            if (!resizable) {
                Insets borderInsets = this.getBorderInsets(c);
                g.setColor(frameColor);
                g.drawRect(x, y, w - 1, h - 1);
                if (active) {
                    g.setColor(AbstractLookAndFeel.getWindowTitleColorDark());
                } else {
                    g.setColor(AbstractLookAndFeel.getWindowInactiveTitleColorDark());
                }
                int i = 1;
                while (i < borderInsets.left) {
                    g.drawRect(i, i, w - 2 * i - 1, h - 2 * i - 1);
                    ++i;
                }
                g.setColor(ColorHelper.brighter(frameColor, 20.0));
                g.drawLine(borderInsets.left - 1, y + th + borderInsets.top, borderInsets.left - 1, y + h - borderInsets.bottom);
                g.drawLine(w - borderInsets.right, y + th + borderInsets.top, w - borderInsets.right, y + h - borderInsets.bottom);
                g.drawLine(borderInsets.left - 1, y + h - borderInsets.bottom, w - borderInsets.right, y + h - borderInsets.bottom);
                return;
            }
            g.setColor(titleColor);
            g.fillRect(x, y + 1, w, 4);
            g.setColor(borderColor);
            g.fillRect(x + 1, y + h - 5, w - 2, 4);
            if (active) {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, 5, 5, th + 1);
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, 5, 5, th + 1);
            }
            g.setColor(borderColor);
            g.fillRect(1, this.insets.top + th + 1, 4, h - th - 5);
            g.fillRect(w - 5, this.insets.top + th + 1, 4, h - th - 5);
            g.setColor(ColorHelper.darker(frameColor, 10.0));
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(frameColor);
            g.drawLine(x + 5 - 1, y + 5 + th, x + 5 - 1, y + h - 5);
            g.drawLine(x + w - 5, y + 5 + th, x + w - 5, y + h - 5);
            g.drawLine(x + 5 - 1, y + h - 5, x + w - 5, y + h - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0);
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 20.0);
            } else if (model.isRollover()) {
                frameColor = AbstractLookAndFeel.getTheme().getRolloverColor();
            }
            g.setColor(frameColor);
            g.drawRect(x, y, w - 2, h - 1);
            g.setColor(AbstractLookAndFeel.getTheme().getToolbarBackgroundColor());
            g.drawLine(w - 1, 0, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.top = 1;
            borderInsets.left = 1;
            borderInsets.bottom = 1;
            borderInsets.right = 1;
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

