/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class GraphiteButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new GraphiteButtonUI();
    }

    @Override
    protected void paintBackground(Graphics g, AbstractButton b) {
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
            super.paintBackground(g, b);
        } else {
            int w = b.getWidth();
            int h = b.getHeight();
            Graphics2D g2D = (Graphics2D)g;
            Shape savedClip = g.getClip();
            if (b.getBorder() != null && b.isBorderPainted() && b.getBorder() instanceof UIResource) {
                Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 6.0, 6.0));
                if (savedClip != null) {
                    clipArea.intersect(new Area(savedClip));
                }
                g2D.setClip(clipArea);
            }
            super.paintBackground(g, b);
            g2D.setClip(savedClip);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            g.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, 3, 2, b.getWidth() - 6, b.getHeight() - 5);
            BasicGraphicsUtils.drawDashedRect(g, 4, 3, b.getWidth() - 8, b.getHeight() - 7);
        }
    }
}

