/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;

public class FastScrollButton
extends BaseScrollButton {
    public FastScrollButton(int direction, int width) {
        super(direction, width);
    }

    @Override
    public void paint(Graphics g) {
        boolean isPressed = this.getModel().isPressed();
        int width = this.getWidth();
        int height = this.getHeight();
        Color backColor = AbstractLookAndFeel.getTheme().getControlBackgroundColor();
        if (!JTattooUtilities.isActive(this)) {
            backColor = ColorHelper.brighter(backColor, 50.0);
        }
        if (isPressed) {
            backColor = ColorHelper.darker(backColor, 10.0);
        }
        Color hiColor = ColorHelper.brighter(backColor, 40.0);
        Color loColor = ColorHelper.darker(backColor, 30.0);
        g.setColor(backColor);
        g.fillRect(0, 0, width, height);
        if (this.getDirection() == 1) {
            Icon upArrow = BaseIcons.getUpArrowIcon();
            int x = width / 2 - upArrow.getIconWidth() / 2;
            int y = height / 2 - upArrow.getIconHeight() / 2 - 1;
            upArrow.paintIcon(this, g, x, y);
        } else if (this.getDirection() == 5) {
            Icon downArrow = BaseIcons.getDownArrowIcon();
            int x = width / 2 - downArrow.getIconWidth() / 2;
            int y = height / 2 - downArrow.getIconHeight() / 2;
            downArrow.paintIcon(this, g, x, y);
        } else if (this.getDirection() == 7) {
            Icon leftArrow = BaseIcons.getLeftArrowIcon();
            int x = width / 2 - leftArrow.getIconWidth() / 2 - 1;
            int y = height / 2 - leftArrow.getIconHeight() / 2;
            leftArrow.paintIcon(this, g, x, y);
        } else {
            Icon rightArrow = BaseIcons.getRightArrowIcon();
            int x = width / 2 - rightArrow.getIconWidth() / 2;
            int y = height / 2 - rightArrow.getIconHeight() / 2;
            rightArrow.paintIcon(this, g, x, y);
        }
        JTattooUtilities.draw3DBorder(g, ColorHelper.brighter(loColor, 20.0), loColor, 0, 0, width, height);
        if (!isPressed) {
            g.setColor(hiColor);
            g.drawLine(1, 1, width - 2, 1);
            g.drawLine(1, 1, 1, height - 2);
        }
    }
}

