/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BernsteinBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return BernsteinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(4, 8, 4, 8);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource cHi = AbstractLookAndFeel.getControlDarkShadow();
            Color cLo = ColorHelper.darker(cHi, 8.0);
            JTattooUtilities.draw3DBorder(g, cHi, cLo, x, y, w, h);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        private static final Color borderColor = new Color(255, 244, 128);
        private static final Color[] FRAME_COLORS = new Color[]{new Color(229, 187, 0), new Color(251, 232, 0), new Color(247, 225, 0), new Color(243, 216, 0), new Color(229, 187, 0)};

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!this.isResizable(c)) {
                Color cHi = ColorHelper.brighter(borderColor, 40.0);
                Color cLo = ColorHelper.darker(borderColor, 20.0);
                JTattooUtilities.draw3DBorder(g, cHi, cLo, x, y, w, h);
                cHi = ColorHelper.darker(cHi, 20.0);
                cLo = ColorHelper.brighter(cLo, 20.0);
                JTattooUtilities.draw3DBorder(g, cHi, cLo, x + 1, y + 1, w - 2, h - 2);
                g.setColor(borderColor);
                int i = 2;
                while (i < 5) {
                    g.drawRect(i, i, w - 2 * i - 1, h - 2 * i - 1);
                    ++i;
                }
                return;
            }
            int dt = w / 3;
            int db = w * 2 / 3;
            --w;
            Color cr = borderColor;
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x, y, x, y + --h);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + 2, y + 2, x + 2, y + h - 2);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + 3, y + 3, x + 3, y + h - 3);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + 4, y + 4, x + 4, y + h - 4);
            g.setColor(cr);
            g.drawLine(x + w, y, x + w, y + h);
            g.setColor(ColorHelper.brighter(cr, 30.0));
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.setColor(ColorHelper.brighter(cr, 60.0));
            g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
            g.setColor(ColorHelper.brighter(cr, 90.0));
            g.drawLine(x + w - 3, y + 3, x + w - 3, y + h - 3);
            g.setColor(cr);
            g.drawLine(x + w - 4, y + 4, x + w - 4, y + h - 4);
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x + w, y, x + w, y + 22);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + 22);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + w - 2, y + 2, x + w - 2, y + 22);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + w - 3, y + 3, x + w - 3, y + 22);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + w - 4, y + 4, x + w - 4, y + 22);
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x + w, y + h - 22, x + w, y + h);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + w - 1, y + h - 22, x + w - 1, y + h - 1);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + w - 2, y + h - 22, x + w - 2, y + h - 2);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + w - 3, y + h - 22, x + w - 3, y + h - 3);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + w - 4, y + h - 22, x + w - 4, y + h - 4);
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x, y, x + dt, y);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + 1, y + 1, x + dt, y + 1);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + 2, y + 2, x + dt, y + 2);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + 3, y + 3, x + dt, y + 3);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + 4, y + 4, x + dt, y + 4);
            g.setColor(cr);
            g.drawLine(x + dt, y, x + w, y);
            g.setColor(ColorHelper.brighter(cr, 90.0));
            g.drawLine(x + dt, y + 1, x + w - 1, y + 1);
            g.setColor(ColorHelper.brighter(cr, 60.0));
            g.drawLine(x + dt, y + 2, x + w - 2, y + 2);
            g.setColor(ColorHelper.brighter(cr, 30.0));
            g.drawLine(x + dt, y + 3, x + w - 3, y + 3);
            g.setColor(cr);
            g.drawLine(x + dt, y + 4, x + w - 4, y + 4);
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x + w - 22, y, x + w, y);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + w - 22, y + 1, x + w - 1, y + 1);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + w - 22, y + 2, x + w - 2, y + 2);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + w - 22, y + 3, x + w - 3, y + 3);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + w - 22, y + 4, x + w - 4, y + 4);
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x, y + h, x + db, y + h);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + 1, y + h - 1, x + db, y + h - 1);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + 2, y + h - 2, x + db, y + h - 2);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + 3, y + h - 3, x + db, y + h - 3);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + 4, y + h - 4, x + db, y + h - 4);
            g.setColor(cr);
            g.drawLine(x + db, y + h, x + w, y + h);
            g.setColor(ColorHelper.brighter(cr, 30.0));
            g.drawLine(x + db, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(ColorHelper.brighter(cr, 60.0));
            g.drawLine(x + db, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(ColorHelper.brighter(cr, 90.0));
            g.drawLine(x + db, y + h - 3, x + w - 3, y + h - 3);
            g.setColor(cr);
            g.drawLine(x + db, y + h - 4, x + w - 4, y + h - 4);
            g.setColor(FRAME_COLORS[0]);
            g.drawLine(x + w - 22, y + h, x + w, y + h);
            g.setColor(FRAME_COLORS[1]);
            g.drawLine(x + w - 22, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(FRAME_COLORS[2]);
            g.drawLine(x + w - 22, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(FRAME_COLORS[3]);
            g.drawLine(x + w - 22, y + h - 3, x + w - 3, y + h - 3);
            g.setColor(FRAME_COLORS[4]);
            g.drawLine(x + w - 22, y + h - 4, x + w - 4, y + h - 4);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Color frameHiColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 60.0);
        private static final Color frameLoColor = AbstractLookAndFeel.getFrameColor();
        private static final Insets insets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isRollover()) {
                    JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x, y, w - 1, h);
                    JTattooUtilities.draw3DBorder(g, Color.white, frameHiColor, x + 1, y + 1, w - 2, h - 2);
                } else if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g.setColor(frameHiColor);
                    g.drawRect(x, y, w - 2, h - 1);
                } else {
                    g.setColor(AbstractLookAndFeel.getFrameColor());
                    g.drawRect(x, y, w - 2, h - 1);
                }
            } else {
                g.setColor(frameHiColor);
                g.drawRect(x, y, w - 2, h - 1);
            }
            g.setColor(Color.white);
            g.drawLine(w - 1, 0, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

