/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractBorderFactory;
import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.BaseCheckBoxMenuItemUI;
import com.jtattoo.plaf.BaseCheckBoxUI;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.BaseDesktopPaneUI;
import com.jtattoo.plaf.BaseEditorPaneUI;
import com.jtattoo.plaf.BaseFileChooserUI;
import com.jtattoo.plaf.BaseFormattedTextFieldUI;
import com.jtattoo.plaf.BaseLabelUI;
import com.jtattoo.plaf.BaseMenuItemUI;
import com.jtattoo.plaf.BaseMenuUI;
import com.jtattoo.plaf.BasePanelUI;
import com.jtattoo.plaf.BasePasswordFieldUI;
import com.jtattoo.plaf.BasePopupMenuUI;
import com.jtattoo.plaf.BaseProgressBarUI;
import com.jtattoo.plaf.BaseRadioButtonMenuItemUI;
import com.jtattoo.plaf.BaseRadioButtonUI;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.BaseScrollPaneUI;
import com.jtattoo.plaf.BaseSeparatorUI;
import com.jtattoo.plaf.BaseSliderUI;
import com.jtattoo.plaf.BaseSpinnerUI;
import com.jtattoo.plaf.BaseSplitPaneUI;
import com.jtattoo.plaf.BaseTableHeaderUI;
import com.jtattoo.plaf.BaseTableUI;
import com.jtattoo.plaf.BaseTextAreaUI;
import com.jtattoo.plaf.BaseTextFieldUI;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.BaseToolTipUI;
import com.jtattoo.plaf.BaseTreeUI;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aero.AeroBorderFactory;
import com.jtattoo.plaf.aero.AeroDefaultTheme;
import com.jtattoo.plaf.aero.AeroIconFactory;
import com.jtattoo.plaf.aero.AeroInternalFrameUI;
import com.jtattoo.plaf.aero.AeroRootPaneUI;
import com.jtattoo.plaf.aero.AeroTabbedPaneUI;
import com.jtattoo.plaf.aero.AeroToolBarUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;

public class AeroLookAndFeel
extends AbstractLookAndFeel {
    private static AeroDefaultTheme myTheme;
    private static final ArrayList themesList;
    private static final HashMap themesMap;
    private static final Properties defaultProps;
    private static final Properties smallFontProps;
    private static final Properties largeFontProps;
    private static final Properties giantFontProps;
    private static final Properties goldProps;
    private static final Properties goldSmallFontProps;
    private static final Properties goldLargeFontProps;
    private static final Properties goldGiantFontProps;
    private static final Properties greenProps;
    private static final Properties greenSmallFontProps;
    private static final Properties greenLargeFontProps;
    private static final Properties greenGiantFontProps;

    static {
        String value;
        myTheme = null;
        themesList = new ArrayList();
        themesMap = new HashMap();
        defaultProps = new Properties();
        smallFontProps = new Properties();
        largeFontProps = new Properties();
        giantFontProps = new Properties();
        goldProps = new Properties();
        goldSmallFontProps = new Properties();
        goldLargeFontProps = new Properties();
        goldGiantFontProps = new Properties();
        greenProps = new Properties();
        greenSmallFontProps = new Properties();
        greenLargeFontProps = new Properties();
        greenGiantFontProps = new Properties();
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        goldProps.setProperty("focusCellColor", "160 160 120");
        goldProps.setProperty("selectionBackgroundColor", "232 232 180");
        goldProps.setProperty("rolloverColor", "225 225 159");
        goldProps.setProperty("controlColorLight", "248 248 180");
        goldProps.setProperty("controlColorDark", "200 200 120");
        goldProps.setProperty("windowTitleForegroundColor", "0 0 0");
        goldProps.setProperty("windowTitleBackgroundColor", "248 248 180");
        goldProps.setProperty("windowTitleColorLight", "249 249 195");
        goldProps.setProperty("windowTitleColorDark", "211 211 147");
        goldProps.setProperty("windowBorderColor", "200 200 120");
        goldProps.setProperty("menuSelectionForegroundColor", "0 0 0");
        goldProps.setProperty("menuSelectionBackgroundColor", "232 232 180");
        goldProps.setProperty("tabSelectionForegroundColor", "0 0 0");
        greenProps.setProperty("focusCellColor", "40 100 60");
        greenProps.setProperty("selectionBackgroundColor", "150 211 176");
        greenProps.setProperty("rolloverColor", "190 228 206");
        greenProps.setProperty("controlColorLight", "150 211 176");
        greenProps.setProperty("controlColorDark", "60 142 95");
        greenProps.setProperty("windowTitleForegroundColor", "255 255 255");
        greenProps.setProperty("windowTitleBackgroundColor", "80 120 100");
        greenProps.setProperty("windowTitleColorLight", "171 219 191");
        greenProps.setProperty("windowTitleColorDark", "99 164 127");
        greenProps.setProperty("windowBorderColor", "60 142 95");
        greenProps.setProperty("menuSelectionForegroundColor", "0 0 0");
        greenProps.setProperty("menuSelectionBackgroundColor", "150 211 176");
        greenProps.setProperty("tabSelectionForegroundColor", "255 255 255");
        for (String string : smallFontProps.keySet()) {
            value = smallFontProps.getProperty(string);
            goldSmallFontProps.setProperty(string, value);
            greenSmallFontProps.setProperty(string, value);
        }
        for (String string : largeFontProps.keySet()) {
            value = largeFontProps.getProperty(string);
            goldLargeFontProps.setProperty(string, value);
            greenLargeFontProps.setProperty(string, value);
        }
        for (String string : giantFontProps.keySet()) {
            value = giantFontProps.getProperty(string);
            goldGiantFontProps.setProperty(string, value);
            greenGiantFontProps.setProperty(string, value);
        }
        for (String string : goldProps.keySet()) {
            value = goldProps.getProperty(string);
            goldSmallFontProps.setProperty(string, value);
            goldLargeFontProps.setProperty(string, value);
            goldGiantFontProps.setProperty(string, value);
        }
        for (String string : greenProps.keySet()) {
            value = greenProps.getProperty(string);
            greenSmallFontProps.setProperty(string, value);
            greenLargeFontProps.setProperty(string, value);
            greenGiantFontProps.setProperty(string, value);
        }
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesList.add("Gold");
        themesList.add("Gold-Small-Font");
        themesList.add("Gold-Large-Font");
        themesList.add("Gold-Giant-Font");
        themesList.add("Green");
        themesList.add("Green-Small-Font");
        themesList.add("Green-Large-Font");
        themesList.add("Green-Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
        themesMap.put("Gold", goldProps);
        themesMap.put("Gold-Small-Font", goldSmallFontProps);
        themesMap.put("Gold-Large-Font", goldLargeFontProps);
        themesMap.put("Gold-Giant-Font", goldGiantFontProps);
        themesMap.put("Green", greenProps);
        themesMap.put("Green-Small-Font", greenSmallFontProps);
        themesMap.put("Green-Large-Font", greenLargeFontProps);
        themesMap.put("Green-Giant-Font", greenGiantFontProps);
    }

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        AeroLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(String name, String licenseKey, String logoString) {
        Properties props = (Properties)themesMap.get(name);
        if (props != null) {
            props.put("licenseKey", licenseKey);
            props.put("logoString", logoString);
            AeroLookAndFeel.setTheme(props);
            if (myTheme != null) {
                AbstractTheme.setInternalName(name);
            }
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "aeroTheme";
        if (myTheme == null) {
            myTheme = new AeroDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        AeroLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "Aero";
    }

    @Override
    public String getID() {
        return "Aero";
    }

    @Override
    public String getDescription() {
        return "The Aero Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return AeroBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return AeroIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new AeroDefaultTheme();
        }
        AeroLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"aeroTheme".equals(currentThemeName)) {
            AeroLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"LabelUI", BaseLabelUI.class.getName(), "ButtonUI", BaseButtonUI.class.getName(), "RadioButtonUI", BaseRadioButtonUI.class.getName(), "CheckBoxUI", BaseCheckBoxUI.class.getName(), "ToggleButtonUI", BaseToggleButtonUI.class.getName(), "SeparatorUI", BaseSeparatorUI.class.getName(), "TextFieldUI", BaseTextFieldUI.class.getName(), "TextAreaUI", BaseTextAreaUI.class.getName(), "EditorPaneUI", BaseEditorPaneUI.class.getName(), "PasswordFieldUI", BasePasswordFieldUI.class.getName(), "ComboBoxUI", BaseComboBoxUI.class.getName(), "ToolTipUI", BaseToolTipUI.class.getName(), "TreeUI", BaseTreeUI.class.getName(), "TableUI", BaseTableUI.class.getName(), "TableHeaderUI", BaseTableHeaderUI.class.getName(), "ScrollBarUI", BaseScrollBarUI.class.getName(), "ScrollPaneUI", BaseScrollPaneUI.class.getName(), "ProgressBarUI", BaseProgressBarUI.class.getName(), "PanelUI", BasePanelUI.class.getName(), "SplitPaneUI", BaseSplitPaneUI.class.getName(), "SliderUI", BaseSliderUI.class.getName(), "FileChooserUI", BaseFileChooserUI.class.getName(), "MenuUI", BaseMenuUI.class.getName(), "PopupMenuUI", BasePopupMenuUI.class.getName(), "MenuItemUI", BaseMenuItemUI.class.getName(), "CheckBoxMenuItemUI", BaseCheckBoxMenuItemUI.class.getName(), "RadioButtonMenuItemUI", BaseRadioButtonMenuItemUI.class.getName(), "PopupMenuSeparatorUI", BaseSeparatorUI.class.getName(), "DesktopPaneUI", BaseDesktopPaneUI.class.getName(), "TabbedPaneUI", AeroTabbedPaneUI.class.getName(), "ToolBarUI", AeroToolBarUI.class.getName(), "InternalFrameUI", AeroInternalFrameUI.class.getName(), "RootPaneUI", AeroRootPaneUI.class.getName()};
        table.putDefaults(uiDefaults);
        if (JTattooUtilities.getJavaVersion() >= 1.5) {
            table.put("FormattedTextFieldUI", BaseFormattedTextFieldUI.class.getName());
            table.put("SpinnerUI", BaseSpinnerUI.class.getName());
        }
    }
}

