/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class BaseSeparatorUI
extends BasicSeparatorUI {
    private static final Dimension size = new Dimension(2, 3);

    public static ComponentUI createUI(JComponent c) {
        return new BaseSeparatorUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ColorUIResource background;
        boolean horizontal = true;
        if (c instanceof JSeparator) {
            horizontal = ((JSeparator)c).getOrientation() == 0;
        }
        ColorUIResource colorUIResource = background = c instanceof JPopupMenu.Separator ? AbstractLookAndFeel.getMenuBackgroundColor() : AbstractLookAndFeel.getBackgroundColor();
        if (horizontal) {
            int w = c.getWidth();
            g.setColor(background);
            g.drawLine(0, 0, w, 0);
            g.setColor(ColorHelper.darker(background, 30.0));
            g.drawLine(0, 1, w, 1);
            g.setColor(ColorHelper.brighter(background, 50.0));
            g.drawLine(0, 2, w, 2);
        } else {
            int h = c.getHeight();
            g.setColor(ColorHelper.darker(background, 30.0));
            g.drawLine(0, 0, 0, h);
            g.setColor(ColorHelper.brighter(background, 50.0));
            g.drawLine(1, 0, 1, h);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return size;
    }
}

