/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BaseInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener MY_PROPERTY_CHANGE_HANDLER = new MyPropertyChangeHandler();
    private static final WindowAdapter MY_WINDOW_HANDLER = new MyWindowHandler();
    private static final Border HANDY_EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final String IS_PALETTE = "JInternalFrame.isPalette";
    private static final String FRAME_TYPE = "JInternalFrame.frameType";
    private static final String FRAME_BORDER = "InternalFrame.border";
    private static final String FRAME_PALETTE_BORDER = "InternalFrame.paletteBorder";
    private static final String PALETTE_FRAME = "palette";

    public BaseInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BaseInternalFrameUI((JInternalFrame)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object paletteProp = c.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        this.stripContentBorder();
    }

    @Override
    public void uninstallUI(JComponent c) {
        JComponent contentPane;
        Container cp = this.frame.getContentPane();
        if (cp instanceof JComponent && (contentPane = (JComponent)cp).getBorder() == HANDY_EMPTY_BORDER) {
            contentPane.setBorder(null);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Icon frameIcon = this.frame.getFrameIcon();
        if (frameIcon == null || frameIcon instanceof LazyImageIcon) {
            this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(MY_PROPERTY_CHANGE_HANDLER);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(MY_PROPERTY_CHANGE_HANDLER);
        super.uninstallListeners();
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    public void stripContentBorder() {
        JComponent contentPane;
        Border contentBorder;
        Container cp = this.frame.getContentPane();
        if (cp instanceof JComponent && ((contentBorder = (contentPane = (JComponent)cp).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentPane.setBorder(HANDY_EMPTY_BORDER);
        }
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        return new BaseInternalFrameTitlePane(w);
    }

    public BaseInternalFrameTitlePane getTitlePane() {
        return (BaseInternalFrameTitlePane)this.titlePane;
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            this.frame.setBorder(UIManager.getBorder(FRAME_PALETTE_BORDER));
        } else {
            this.frame.setBorder(UIManager.getBorder(FRAME_BORDER));
        }
        this.getTitlePane().setPalette(isPalette);
    }

    private static class MyPropertyChangeHandler
    implements PropertyChangeListener {
        private MyPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JInternalFrame jif = (JInternalFrame)e.getSource();
            if (!(jif.getUI() instanceof BaseInternalFrameUI)) {
                return;
            }
            BaseInternalFrameUI ui = (BaseInternalFrameUI)jif.getUI();
            String name = e.getPropertyName();
            if (name.equals(BaseInternalFrameUI.FRAME_TYPE)) {
                if (e.getNewValue() instanceof String) {
                    if (BaseInternalFrameUI.PALETTE_FRAME.equals(e.getNewValue())) {
                        LookAndFeel.installBorder(ui.frame, BaseInternalFrameUI.FRAME_PALETTE_BORDER);
                        ui.setPalette(true);
                    } else {
                        LookAndFeel.installBorder(ui.frame, BaseInternalFrameUI.FRAME_BORDER);
                        ui.setPalette(false);
                    }
                }
            } else if (name.equals(BaseInternalFrameUI.IS_PALETTE)) {
                if (e.getNewValue() != null) {
                    ui.setPalette((Boolean)e.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder();
            } else if (name.equals("ancestor") && !AbstractLookAndFeel.isWindowDecorationOn()) {
                JDesktopPane jp;
                Window window;
                if (e.getNewValue() instanceof JDesktopPane) {
                    JDesktopPane jp2 = (JDesktopPane)e.getNewValue();
                    Window window2 = SwingUtilities.getWindowAncestor(jp2);
                    if (window2 != null) {
                        WindowListener[] wl = window2.getWindowListeners();
                        boolean doAdd = true;
                        int i = 0;
                        while (i < wl.length) {
                            if (wl[i].equals(MY_WINDOW_HANDLER)) {
                                doAdd = false;
                                break;
                            }
                            ++i;
                        }
                        if (doAdd) {
                            window2.addWindowListener(MY_WINDOW_HANDLER);
                        }
                    }
                } else if (e.getOldValue() instanceof JDesktopPane && (window = SwingUtilities.getWindowAncestor(jp = (JDesktopPane)e.getOldValue())) != null) {
                    window.removeWindowListener(MY_WINDOW_HANDLER);
                }
            }
        }
    }

    private static class MyWindowHandler
    extends WindowAdapter {
        private MyWindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            e.getWindow().invalidate();
            e.getWindow().repaint();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            e.getWindow().invalidate();
            e.getWindow().repaint();
        }
    }
}

