/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractBorderFactory;
import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public abstract class AbstractLookAndFeel
extends MetalLookAndFeel {
    protected static String currentThemeName;
    private static AbstractTheme myTheme;

    static {
        try {
            if (JTattooUtilities.getJavaVersion() < 1.4) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        currentThemeName = "abstractTheme";
        myTheme = null;
    }

    public abstract AbstractBorderFactory getBorderFactory();

    public abstract AbstractIconFactory getIconFactory();

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        Object[] systemColors = new Object[]{"desktop", AbstractLookAndFeel.getDesktopColor(), "activeCaption", AbstractLookAndFeel.getWindowTitleBackgroundColor(), "activeCaptionLight", AbstractLookAndFeel.getWindowTitleColorLight(), "activeCaptionDark", AbstractLookAndFeel.getWindowTitleColorDark(), "activeCaptionText", AbstractLookAndFeel.getWindowTitleForegroundColor(), "activeCaptionBorder", AbstractLookAndFeel.getWindowBorderColor(), "inactiveCaption", AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor(), "inactiveCaptionLight", AbstractLookAndFeel.getWindowInactiveTitleColorLight(), "inactiveCaptionDark", AbstractLookAndFeel.getWindowInactiveTitleColorDark(), "inactiveCaptionText", AbstractLookAndFeel.getWindowInactiveTitleForegroundColor(), "inactiveCaptionBorder", AbstractLookAndFeel.getWindowInactiveBorderColor(), "window", AbstractLookAndFeel.getInputBackgroundColor(), "windowBorder", AbstractLookAndFeel.getBackgroundColor(), "windowText", AbstractLookAndFeel.getControlForegroundColor(), "menu", AbstractLookAndFeel.getMenuBackgroundColor(), "menuText", AbstractLookAndFeel.getMenuForegroundColor(), "MenuBar.rolloverEnabled", Boolean.TRUE, "text", AbstractLookAndFeel.getBackgroundColor(), "textText", AbstractLookAndFeel.getControlForegroundColor(), "textHighlight", AbstractLookAndFeel.getSelectionBackgroundColor(), "textHighlightText", AbstractLookAndFeel.getSelectionForegroundColor(), "textInactiveText", AbstractLookAndFeel.getDisabledForegroundColor(), "control", AbstractLookAndFeel.getControlBackgroundColor(), "controlText", AbstractLookAndFeel.getControlForegroundColor(), "controlHighlight", this.getControlHighlightColor(), "controlLtHighlight", this.getControlHighlightColor(), "controlShadow", this.getControlShadowColor(), "controlDkShadow", this.getControlDarkShadowColor(), "scrollbar", AbstractLookAndFeel.getControlBackgroundColor(), "info", AbstractLookAndFeel.getTooltipBackgroundColor(), "infoText", AbstractLookAndFeel.getTooltipForegroundColor()};
        int i = 0;
        while (i < systemColors.length) {
            table.put((String)systemColors[i], systemColors[i + 1]);
            i += 2;
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        BaseBorders.initDefaults();
        BaseIcons.initDefaults();
        Border textFieldBorder = this.getBorderFactory().getTextFieldBorder();
        Border comboBoxBorder = this.getBorderFactory().getComboBoxBorder();
        Border scrollPaneBorder = this.getBorderFactory().getScrollPaneBorder();
        Border tableScrollPaneBorder = this.getBorderFactory().getTableScrollPaneBorder();
        Border tabbedPaneBorder = this.getBorderFactory().getTabbedPaneBorder();
        Border buttonBorder = this.getBorderFactory().getButtonBorder();
        Border toggleButtonBorder = this.getBorderFactory().getToggleButtonBorder();
        UIDefaults.ProxyLazyValue titledBorderBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{AbstractLookAndFeel.getFrameColor()});
        Border menuBarBorder = this.getBorderFactory().getMenuBarBorder();
        Border popupMenuBorder = this.getBorderFactory().getPopupMenuBorder();
        Border menuItemBorder = this.getBorderFactory().getMenuItemBorder();
        Border toolBarBorder = this.getBorderFactory().getToolBarBorder();
        Border progressBarBorder = this.getBorderFactory().getProgressBarBorder();
        UIDefaults.ProxyLazyValue toolTipBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{AbstractLookAndFeel.getFrameColor()});
        UIDefaults.ProxyLazyValue focusCellHighlightBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{AbstractLookAndFeel.getFocusCellColor()});
        Border optionPaneBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border optionPaneMessageAreaBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        Border optionPaneButtonAreaBorder = BorderFactory.createEmptyBorder(0, 8, 8, 8);
        Border windowBorder = this.getBorderFactory().getInternalFrameBorder();
        ColorUIResource c = AbstractLookAndFeel.getBackgroundColor();
        ColorUIResource progressBarBackground = new ColorUIResource(ColorHelper.brighter(c, 20.0));
        Object[] objectArray = new Object[550];
        objectArray[0] = "controlTextFont";
        objectArray[1] = AbstractLookAndFeel.getControlTextFont();
        objectArray[2] = "systemTextFont ";
        objectArray[3] = AbstractLookAndFeel.getSystemTextFont();
        objectArray[4] = "userTextFont";
        objectArray[5] = AbstractLookAndFeel.getUserTextFont();
        objectArray[6] = "menuTextFont";
        objectArray[7] = AbstractLookAndFeel.getMenuTextFont();
        objectArray[8] = "windowTitleFont";
        objectArray[9] = AbstractLookAndFeel.getWindowTitleFont();
        objectArray[10] = "subTextFont";
        objectArray[11] = AbstractLookAndFeel.getSubTextFont();
        objectArray[12] = "Label.font";
        objectArray[13] = AbstractLookAndFeel.getUserTextFont();
        objectArray[14] = "Label.background";
        objectArray[15] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[16] = "Label.foreground";
        objectArray[17] = AbstractLookAndFeel.getForegroundColor();
        objectArray[18] = "Label.disabledText";
        objectArray[19] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[20] = "Label.disabledShadow";
        objectArray[21] = AbstractLookAndFeel.getWhite();
        objectArray[22] = "TextField.border";
        objectArray[23] = textFieldBorder;
        objectArray[24] = "TextField.foreground";
        objectArray[25] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[26] = "TextField.background";
        objectArray[27] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[28] = "TextField.disabledForeground";
        objectArray[29] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[30] = "TextField.disabledBackground";
        objectArray[31] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[32] = "TextField.inactiveForeground";
        objectArray[33] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[34] = "TextField.inactiveBackground";
        objectArray[35] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[36] = "TextArea.foreground";
        objectArray[37] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[38] = "TextArea.background";
        objectArray[39] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[40] = "TextArea.disabledForeground";
        objectArray[41] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[42] = "TextArea.disabledBackground";
        objectArray[43] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[44] = "TextArea.inactiveForeground";
        objectArray[45] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[46] = "TextArea.inactiveBackground";
        objectArray[47] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[48] = "EditorPane.foreground";
        objectArray[49] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[50] = "EditorPane.background";
        objectArray[51] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[52] = "EditorPane.disabledForeground";
        objectArray[53] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[54] = "EditorPane.disabledBackground";
        objectArray[55] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[56] = "EditorPane.inactiveForeground";
        objectArray[57] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[58] = "EditorPane.inactiveBackground";
        objectArray[59] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[60] = "FormattedTextField.border";
        objectArray[61] = textFieldBorder;
        objectArray[62] = "FormattedTextField.foreground";
        objectArray[63] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[64] = "FormattedTextField.background";
        objectArray[65] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[66] = "FormattedTextField.disabledForeground";
        objectArray[67] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[68] = "FormattedTextField.disabledBackground";
        objectArray[69] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[70] = "FormattedTextField.inactiveForeground";
        objectArray[71] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[72] = "FormattedTextField.inactiveBackground";
        objectArray[73] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[74] = "PasswordField.border";
        objectArray[75] = textFieldBorder;
        objectArray[76] = "PasswordField.foreground";
        objectArray[77] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[78] = "PasswordField.background";
        objectArray[79] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[80] = "PasswordField.disabledForeground";
        objectArray[81] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[82] = "PasswordField.disabledBackground";
        objectArray[83] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[84] = "PasswordField.inactiveForeground";
        objectArray[85] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[86] = "PasswordField.inactiveBackground";
        objectArray[87] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[88] = "Button.background";
        objectArray[89] = AbstractLookAndFeel.getButtonBackgroundColor();
        objectArray[90] = "Button.foreground";
        objectArray[91] = AbstractLookAndFeel.getButtonForegroundColor();
        objectArray[92] = "Button.disabledText";
        objectArray[93] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[94] = "Button.disabledShadow";
        objectArray[95] = AbstractLookAndFeel.getWhite();
        objectArray[96] = "Button.select";
        objectArray[97] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[98] = "Button.border";
        objectArray[99] = buttonBorder;
        objectArray[100] = "Button.frame";
        objectArray[101] = AbstractLookAndFeel.getFrameColor();
        objectArray[102] = "Button.focus";
        objectArray[103] = AbstractLookAndFeel.getFocusColor();
        objectArray[104] = "Button.rolloverColor";
        objectArray[105] = AbstractLookAndFeel.getTheme().getRolloverColor();
        objectArray[106] = "Button.rolloverForeground";
        objectArray[107] = AbstractLookAndFeel.getTheme().getRolloverForegroundColor();
        objectArray[108] = "CheckBox.font";
        objectArray[109] = AbstractLookAndFeel.getUserTextFont();
        objectArray[110] = "CheckBox.background";
        objectArray[111] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[112] = "CheckBox.foreground";
        objectArray[113] = AbstractLookAndFeel.getForegroundColor();
        objectArray[114] = "CheckBox.disabledText";
        objectArray[115] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[116] = "CheckBox.disabledShadow";
        objectArray[117] = AbstractLookAndFeel.getWhite();
        objectArray[118] = "Checkbox.select";
        objectArray[119] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[120] = "CheckBox.focus";
        objectArray[121] = AbstractLookAndFeel.getFocusColor();
        objectArray[122] = "CheckBox.icon";
        objectArray[123] = this.getIconFactory().getCheckBoxIcon();
        objectArray[124] = "RadioButton.font";
        objectArray[125] = AbstractLookAndFeel.getUserTextFont();
        objectArray[126] = "RadioButton.background";
        objectArray[127] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[128] = "RadioButton.foreground";
        objectArray[129] = AbstractLookAndFeel.getForegroundColor();
        objectArray[130] = "RadioButton.disabledText";
        objectArray[131] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[132] = "RadioButton.disabledShadow";
        objectArray[133] = AbstractLookAndFeel.getWhite();
        objectArray[134] = "RadioButton.select";
        objectArray[135] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[136] = "RadioButton.icon";
        objectArray[137] = this.getIconFactory().getRadioButtonIcon();
        objectArray[138] = "RadioButton.focus";
        objectArray[139] = AbstractLookAndFeel.getFocusColor();
        objectArray[140] = "ToggleButton.background";
        objectArray[141] = AbstractLookAndFeel.getButtonBackgroundColor();
        objectArray[142] = "ToggleButton.foreground";
        objectArray[143] = AbstractLookAndFeel.getButtonForegroundColor();
        objectArray[144] = "ToggleButton.select";
        objectArray[145] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[146] = "ToggleButton.text";
        objectArray[147] = AbstractLookAndFeel.getButtonForegroundColor();
        objectArray[148] = "ToggleButton.disabledText";
        objectArray[149] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[150] = "ToggleButton.disabledShadow";
        objectArray[151] = AbstractLookAndFeel.getWhite();
        objectArray[152] = "ToggleButton.disabledSelectedText";
        objectArray[153] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[154] = "ToggleButton.disabledBackground";
        objectArray[155] = AbstractLookAndFeel.getButtonBackgroundColor();
        objectArray[156] = "ToggleButton.disabledSelectedBackground";
        objectArray[157] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[158] = "ToggleButton.focus";
        objectArray[159] = AbstractLookAndFeel.getFocusColor();
        objectArray[160] = "ToggleButton.border";
        objectArray[161] = toggleButtonBorder;
        objectArray[162] = "ToolTip.border";
        objectArray[163] = toolTipBorder;
        objectArray[164] = "ToolTip.foreground";
        objectArray[165] = AbstractLookAndFeel.getTooltipForegroundColor();
        objectArray[166] = "ToolTip.background";
        objectArray[167] = AbstractLookAndFeel.getTooltipBackgroundColor();
        objectArray[168] = "Slider.border";
        objectArray[170] = "Slider.foreground";
        objectArray[171] = AbstractLookAndFeel.getFrameColor();
        objectArray[172] = "Slider.background";
        objectArray[173] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[174] = "Slider.focus";
        objectArray[175] = AbstractLookAndFeel.getFocusColor();
        objectArray[176] = "Slider.focusInsets";
        objectArray[177] = new InsetsUIResource(0, 0, 0, 0);
        objectArray[178] = "Slider.trackWidth";
        objectArray[179] = new Integer(7);
        objectArray[180] = "Slider.majorTickLength";
        objectArray[181] = new Integer(6);
        objectArray[182] = "ProgressBar.border";
        objectArray[183] = progressBarBorder;
        objectArray[184] = "ProgressBar.background";
        objectArray[185] = progressBarBackground;
        objectArray[186] = "ProgressBar.selectionForeground";
        objectArray[187] = AbstractLookAndFeel.getSelectionForegroundColor();
        objectArray[188] = "ProgressBar.selectionBackground";
        objectArray[189] = AbstractLookAndFeel.getForegroundColor();
        objectArray[190] = "ComboBox.border";
        objectArray[191] = comboBoxBorder;
        objectArray[192] = "ComboBox.background";
        objectArray[193] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[194] = "ComboBox.foreground";
        objectArray[195] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[196] = "ComboBox.selectionBackground";
        objectArray[197] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[198] = "ComboBox.selectionForeground";
        objectArray[199] = AbstractLookAndFeel.getSelectionForegroundColor();
        objectArray[200] = "ComboBox.selectionBorderColor";
        objectArray[201] = AbstractLookAndFeel.getFocusColor();
        objectArray[202] = "ComboBox.disabledBackground";
        objectArray[203] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[204] = "ComboBox.disabledForeground";
        objectArray[205] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[206] = "ComboBox.listBackground";
        objectArray[207] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[208] = "ComboBox.listForeground";
        objectArray[209] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[210] = "ComboBox.font";
        objectArray[211] = AbstractLookAndFeel.getUserTextFont();
        objectArray[212] = "Panel.foreground";
        objectArray[213] = AbstractLookAndFeel.getForegroundColor();
        objectArray[214] = "Panel.background";
        objectArray[215] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[216] = "Panel.darkBackground";
        objectArray[217] = AbstractLookAndFeel.getTheme().getBackgroundColorDark();
        objectArray[218] = "Panel.lightBackground";
        objectArray[219] = AbstractLookAndFeel.getTheme().getBackgroundColorLight();
        objectArray[220] = "Panel.alterBackground";
        objectArray[221] = AbstractLookAndFeel.getTheme().getAlterBackgroundColor();
        objectArray[222] = "Panel.font";
        objectArray[223] = AbstractLookAndFeel.getUserTextFont();
        objectArray[224] = "RootPane.frameBorder";
        objectArray[225] = windowBorder;
        objectArray[226] = "RootPane.plainDialogBorder";
        objectArray[227] = windowBorder;
        objectArray[228] = "RootPane.informationDialogBorder";
        objectArray[229] = windowBorder;
        objectArray[230] = "RootPane.errorDialogBorder";
        objectArray[231] = windowBorder;
        objectArray[232] = "RootPane.colorChooserDialogBorder";
        objectArray[233] = windowBorder;
        objectArray[234] = "RootPane.fileChooserDialogBorder";
        objectArray[235] = windowBorder;
        objectArray[236] = "RootPane.questionDialogBorder";
        objectArray[237] = windowBorder;
        objectArray[238] = "RootPane.warningDialogBorder";
        objectArray[239] = windowBorder;
        objectArray[240] = "InternalFrame.border";
        objectArray[241] = this.getBorderFactory().getInternalFrameBorder();
        objectArray[242] = "InternalFrame.font";
        objectArray[243] = AbstractLookAndFeel.getWindowTitleFont();
        objectArray[244] = "InternalFrame.paletteBorder";
        objectArray[245] = this.getBorderFactory().getPaletteBorder();
        objectArray[246] = "InternalFrame.paletteTitleHeight";
        objectArray[247] = new Integer(11);
        objectArray[248] = "InternalFrame.paletteCloseIcon";
        objectArray[249] = this.getIconFactory().getPaletteCloseIcon();
        objectArray[250] = "InternalFrame.icon";
        objectArray[251] = this.getIconFactory().getMenuIcon();
        objectArray[252] = "InternalFrame.iconifyIcon";
        objectArray[253] = this.getIconFactory().getIconIcon();
        objectArray[254] = "InternalFrame.maximizeIcon";
        objectArray[255] = this.getIconFactory().getMaxIcon();
        objectArray[256] = "InternalFrame.altMaximizeIcon";
        objectArray[257] = this.getIconFactory().getMinIcon();
        objectArray[258] = "InternalFrame.minimizeIcon";
        objectArray[259] = this.getIconFactory().getMinIcon();
        objectArray[260] = "InternalFrame.closeIcon";
        objectArray[261] = this.getIconFactory().getCloseIcon();
        objectArray[262] = "TitledBorder.titleColor";
        objectArray[263] = AbstractLookAndFeel.getForegroundColor();
        objectArray[264] = "TitledBorder.border";
        objectArray[265] = titledBorderBorder;
        objectArray[266] = "List.focusCellHighlightBorder";
        objectArray[267] = focusCellHighlightBorder;
        objectArray[268] = "List.font";
        objectArray[269] = AbstractLookAndFeel.getUserTextFont();
        objectArray[270] = "List.foreground";
        objectArray[271] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[272] = "List.background";
        objectArray[273] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[274] = "List.selectionForeground";
        objectArray[275] = AbstractLookAndFeel.getSelectionForegroundColor();
        objectArray[276] = "List.selectionBackground";
        objectArray[277] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[278] = "List.disabledForeground";
        objectArray[279] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[280] = "List.disabledBackground";
        objectArray[281] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[282] = "ScrollBar.background";
        objectArray[283] = AbstractLookAndFeel.getControlBackgroundColor();
        objectArray[284] = "ScrollBar.highlight";
        objectArray[285] = this.getControlHighlightColor();
        objectArray[286] = "ScrollBar.shadow";
        objectArray[287] = this.getControlShadowColor();
        objectArray[288] = "ScrollBar.darkShadow";
        objectArray[289] = this.getControlDarkShadowColor();
        objectArray[290] = "ScrollBar.thumb";
        objectArray[291] = AbstractLookAndFeel.getControlBackgroundColor();
        objectArray[292] = "ScrollBar.thumbShadow";
        objectArray[293] = this.getControlShadowColor();
        objectArray[294] = "ScrollBar.thumbHighlight";
        objectArray[295] = this.getControlHighlightColor();
        objectArray[296] = "ScrollBar.width";
        objectArray[297] = new Integer(17);
        objectArray[298] = "ScrollBar.allowsAbsolutePositioning";
        objectArray[299] = Boolean.TRUE;
        objectArray[300] = "ScrollPane.border";
        objectArray[301] = scrollPaneBorder;
        objectArray[302] = "ScrollPane.foreground";
        objectArray[303] = AbstractLookAndFeel.getForegroundColor();
        objectArray[304] = "ScrollPane.background";
        objectArray[305] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[306] = "Viewport.foreground";
        objectArray[307] = AbstractLookAndFeel.getForegroundColor();
        objectArray[308] = "Viewport.background";
        objectArray[309] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[310] = "Viewport.font";
        objectArray[311] = AbstractLookAndFeel.getUserTextFont();
        objectArray[312] = "TabbedPane.boder";
        objectArray[313] = tabbedPaneBorder;
        objectArray[314] = "TabbedPane.background";
        objectArray[315] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[316] = "TabbedPane.tabAreaBackground";
        objectArray[317] = AbstractLookAndFeel.getTabAreaBackgroundColor();
        objectArray[318] = "TabbedPane.unselectedBackground";
        objectArray[319] = AbstractLookAndFeel.getControlColorDark();
        objectArray[320] = "TabbedPane.foreground";
        objectArray[321] = AbstractLookAndFeel.getControlForegroundColor();
        objectArray[322] = "TabbedPane.selected";
        objectArray[323] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[324] = "TabbedPane.selectedForeground";
        objectArray[325] = AbstractLookAndFeel.getTabSelectionForegroundColor();
        objectArray[326] = "TabbedPane.tabAreaInsets";
        objectArray[327] = new InsetsUIResource(5, 5, 5, 5);
        objectArray[328] = "TabbedPane.contentBorderInsets";
        objectArray[329] = new InsetsUIResource(0, 0, 0, 0);
        objectArray[330] = "TabbedPane.tabInsets";
        objectArray[331] = new InsetsUIResource(1, 6, 1, 6);
        objectArray[332] = "TabbedPane.focus";
        objectArray[333] = AbstractLookAndFeel.getFocusColor();
        objectArray[334] = "TabbedPane.selected";
        objectArray[335] = AbstractLookAndFeel.getButtonBackgroundColor();
        objectArray[336] = "TabbedPane.shadow";
        objectArray[337] = new ColorUIResource(180, 180, 180);
        objectArray[338] = "TabbedPane.darkShadow";
        objectArray[339] = new ColorUIResource(120, 120, 120);
        objectArray[340] = "TabbedPane.highlight";
        objectArray[341] = new ColorUIResource(Color.white);
        objectArray[342] = "tab_unsel_fill";
        objectArray[343] = AbstractLookAndFeel.getControlBackgroundColor();
        objectArray[344] = "tab_sel_fill";
        objectArray[345] = AbstractLookAndFeel.getControlBackgroundColor();
        objectArray[346] = "Table.focusCellHighlightBorder";
        objectArray[347] = focusCellHighlightBorder;
        objectArray[348] = "Table.scrollPaneBorder";
        objectArray[349] = tableScrollPaneBorder;
        objectArray[350] = "Table.foreground";
        objectArray[351] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[352] = "Table.background";
        objectArray[353] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[354] = "Table.gridColor";
        objectArray[355] = AbstractLookAndFeel.getGridColor();
        objectArray[356] = "TableHeader.foreground";
        objectArray[357] = AbstractLookAndFeel.getControlForegroundColor();
        objectArray[358] = "TableHeader.background";
        objectArray[359] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[360] = "TableHeader.cellBorder";
        objectArray[361] = this.getBorderFactory().getTableHeaderBorder();
        objectArray[362] = "MenuBar.border";
        objectArray[363] = menuBarBorder;
        objectArray[364] = "MenuBar.foreground";
        objectArray[365] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[366] = "MenuBar.background";
        objectArray[367] = AbstractLookAndFeel.getMenuBackgroundColor();
        objectArray[368] = "Menu.border";
        objectArray[369] = menuItemBorder;
        objectArray[370] = "Menu.borderPainted";
        objectArray[371] = Boolean.TRUE;
        objectArray[372] = "Menu.foreground";
        objectArray[373] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[374] = "Menu.background";
        objectArray[375] = AbstractLookAndFeel.getMenuBackgroundColor();
        objectArray[376] = "Menu.selectionForeground";
        objectArray[377] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[378] = "Menu.selectionBackground";
        objectArray[379] = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
        objectArray[380] = "Menu.disabledForeground";
        objectArray[381] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[382] = "Menu.acceleratorForeground";
        objectArray[383] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[384] = "Menu.acceleratorSelectionForeground";
        objectArray[385] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[386] = "Menu.arrowIcon";
        objectArray[387] = this.getIconFactory().getMenuArrowIcon();
        objectArray[388] = "PopupMenu.background";
        objectArray[389] = AbstractLookAndFeel.getMenuBackgroundColor();
        objectArray[390] = "PopupMenu.border";
        objectArray[391] = popupMenuBorder;
        objectArray[392] = "MenuItem.border";
        objectArray[393] = menuItemBorder;
        objectArray[394] = "MenuItem.borderPainted";
        objectArray[395] = Boolean.TRUE;
        objectArray[396] = "MenuItem.foreground";
        objectArray[397] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[398] = "MenuItem.background";
        objectArray[399] = AbstractLookAndFeel.getMenuBackgroundColor();
        objectArray[400] = "MenuItem.selectionForeground";
        objectArray[401] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[402] = "MenuItem.selectionBackground";
        objectArray[403] = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
        objectArray[404] = "MenuItem.disabledForeground";
        objectArray[405] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[406] = "MenuItem.disabledShadow";
        objectArray[407] = AbstractLookAndFeel.getWhite();
        objectArray[408] = "MenuItem.acceleratorForeground";
        objectArray[409] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[410] = "MenuItem.acceleratorSelectionForeground";
        objectArray[411] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[412] = "CheckBoxMenuItem.border";
        objectArray[413] = menuItemBorder;
        objectArray[414] = "CheckBoxMenuItem.borderPainted";
        objectArray[415] = Boolean.TRUE;
        objectArray[416] = "CheckBoxMenuItem.foreground";
        objectArray[417] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[418] = "CheckBoxMenuItem.background";
        objectArray[419] = AbstractLookAndFeel.getMenuBackgroundColor();
        objectArray[420] = "CheckBoxMenuItem.selectionForeground";
        objectArray[421] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[422] = "CheckBoxMenuItem.selectionBackground";
        objectArray[423] = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
        objectArray[424] = "CheckBoxMenuItem.disabledForeground";
        objectArray[425] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[426] = "CheckBoxMenuItem.disabledShadow";
        objectArray[427] = AbstractLookAndFeel.getWhite();
        objectArray[428] = "CheckBoxMenuItem.acceleratorForeground";
        objectArray[429] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[430] = "CheckBoxMenuItem.acceleratorSelectionForeground";
        objectArray[431] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[432] = "CheckBoxMenuItem.checkIcon";
        objectArray[433] = this.getIconFactory().getMenuCheckBoxIcon();
        objectArray[434] = "RadioButtonMenuItem.border";
        objectArray[435] = menuItemBorder;
        objectArray[436] = "RadioButtonMenuItem.borderPainted";
        objectArray[437] = Boolean.TRUE;
        objectArray[438] = "RadioButtonMenuItem.foreground";
        objectArray[439] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[440] = "RadioButtonMenuItem.background";
        objectArray[441] = AbstractLookAndFeel.getMenuBackgroundColor();
        objectArray[442] = "RadioButtonMenuItem.selectionForeground";
        objectArray[443] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[444] = "RadioButtonMenuItem.selectionBackground";
        objectArray[445] = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
        objectArray[446] = "RadioButtonMenuItem.disabledForeground";
        objectArray[447] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[448] = "RadioButtonMenuItem.disabledShadow";
        objectArray[449] = AbstractLookAndFeel.getWhite();
        objectArray[450] = "RadioButtonMenuItem.acceleratorForeground";
        objectArray[451] = AbstractLookAndFeel.getMenuForegroundColor();
        objectArray[452] = "RadioButtonMenuItem.acceleratorSelectionForeground";
        objectArray[453] = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        objectArray[454] = "RadioButtonMenuItem.checkIcon";
        objectArray[455] = this.getIconFactory().getMenuRadioButtonIcon();
        objectArray[456] = "OptionPane.errorIcon";
        objectArray[457] = this.getIconFactory().getOptionPaneErrorIcon();
        objectArray[458] = "OptionPane.informationIcon";
        objectArray[459] = this.getIconFactory().getOptionPaneInformationIcon();
        objectArray[460] = "OptionPane.warningIcon";
        objectArray[461] = this.getIconFactory().getOptionPaneWarningIcon();
        objectArray[462] = "OptionPane.questionIcon";
        objectArray[463] = this.getIconFactory().getOptionPaneQuestionIcon();
        objectArray[464] = "OptionPane.border";
        objectArray[465] = optionPaneBorder;
        objectArray[466] = "OptionPane.messageAreaBorder";
        objectArray[467] = optionPaneMessageAreaBorder;
        objectArray[468] = "OptionPane.buttonAreaBorder";
        objectArray[469] = optionPaneButtonAreaBorder;
        objectArray[470] = "FileView.directoryIcon";
        objectArray[471] = this.getIconFactory().getTreeOpenIcon();
        objectArray[472] = "FileView.fileIcon";
        objectArray[473] = this.getIconFactory().getTreeLeafIcon();
        objectArray[474] = "FileView.computerIcon";
        objectArray[475] = this.getIconFactory().getFileViewComputerIcon();
        objectArray[476] = "FileView.hardDriveIcon";
        objectArray[477] = this.getIconFactory().getFileViewHardDriveIcon();
        objectArray[478] = "FileView.floppyDriveIcon";
        objectArray[479] = this.getIconFactory().getFileViewFloppyDriveIcon();
        objectArray[480] = "FileChooser.upFolderIcon";
        objectArray[481] = this.getIconFactory().getFileChooserUpFolderIcon();
        objectArray[482] = "FileChooser.homeFolderIcon";
        objectArray[483] = this.getIconFactory().getFileChooserHomeFolderIcon();
        objectArray[484] = "FileChooser.newFolderIcon";
        objectArray[485] = this.getIconFactory().getFileChooserNewFolderIcon();
        objectArray[486] = "FileChooser.listViewIcon";
        objectArray[487] = this.getIconFactory().getFileChooserListViewIcon();
        objectArray[488] = "FileChooser.detailsViewIcon";
        objectArray[489] = this.getIconFactory().getFileChooserDetailViewIcon();
        objectArray[490] = "FileChooser.viewMenuIcon";
        objectArray[491] = this.getIconFactory().getFileChooserDetailViewIcon();
        objectArray[492] = "Separator.background";
        objectArray[493] = AbstractLookAndFeel.getBackgroundColor();
        objectArray[494] = "Separator.foreground";
        objectArray[495] = AbstractLookAndFeel.getControlForegroundColor();
        objectArray[496] = "SplitPane.centerOneTouchButtons";
        objectArray[497] = Boolean.TRUE;
        objectArray[498] = "SplitPane.dividerSize";
        objectArray[499] = new Integer(7);
        objectArray[500] = "SplitPane.border";
        objectArray[501] = BorderFactory.createEmptyBorder();
        objectArray[502] = "Tree.background";
        objectArray[503] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[504] = "Tree.foreground";
        objectArray[505] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[506] = "Tree.textForeground";
        objectArray[507] = AbstractLookAndFeel.getInputForegroundColor();
        objectArray[508] = "Tree.textBackground";
        objectArray[509] = AbstractLookAndFeel.getInputBackgroundColor();
        objectArray[510] = "Tree.selectionForeground";
        objectArray[511] = AbstractLookAndFeel.getSelectionForegroundColor();
        objectArray[512] = "Tree.selectionBackground";
        objectArray[513] = AbstractLookAndFeel.getSelectionBackgroundColor();
        objectArray[514] = "Tree.disabledForeground";
        objectArray[515] = AbstractLookAndFeel.getDisabledForegroundColor();
        objectArray[516] = "Tree.disabledBackground";
        objectArray[517] = AbstractLookAndFeel.getDisabledBackgroundColor();
        objectArray[518] = "Tree.openIcon";
        objectArray[519] = this.getIconFactory().getTreeOpenIcon();
        objectArray[520] = "Tree.closedIcon";
        objectArray[521] = this.getIconFactory().getTreeCloseIcon();
        objectArray[522] = "Tree.leafIcon";
        objectArray[523] = this.getIconFactory().getTreeLeafIcon();
        objectArray[524] = "Tree.expandedIcon";
        objectArray[525] = this.getIconFactory().getTreeExpandedIcon();
        objectArray[526] = "Tree.collapsedIcon";
        objectArray[527] = this.getIconFactory().getTreeCollapsedIcon();
        objectArray[528] = "Tree.selectionBorderColor";
        objectArray[529] = AbstractLookAndFeel.getFocusCellColor();
        objectArray[530] = "Tree.line";
        objectArray[531] = AbstractLookAndFeel.getFrameColor();
        objectArray[532] = "Tree.hash";
        objectArray[533] = AbstractLookAndFeel.getFrameColor();
        objectArray[534] = "JToolBar.isRollover";
        objectArray[535] = Boolean.TRUE;
        objectArray[536] = "ToolBar.border";
        objectArray[537] = toolBarBorder;
        objectArray[538] = "ToolBar.background";
        objectArray[539] = AbstractLookAndFeel.getToolbarBackgroundColor();
        objectArray[540] = "ToolBar.foreground";
        objectArray[541] = AbstractLookAndFeel.getToolbarForegroundColor();
        objectArray[542] = "ToolBar.dockingBackground";
        objectArray[543] = AbstractLookAndFeel.getToolbarBackgroundColor();
        objectArray[544] = "ToolBar.dockingForeground";
        objectArray[545] = AbstractLookAndFeel.getToolbarDockingColor();
        objectArray[546] = "ToolBar.floatingBackground";
        objectArray[547] = AbstractLookAndFeel.getToolbarBackgroundColor();
        objectArray[548] = "ToolBar.floatingForeground";
        objectArray[549] = AbstractLookAndFeel.getToolbarForegroundColor();
        Object[] defaults = objectArray;
        table.putDefaults(defaults);
        if (JTattooUtilities.getJavaVersion() >= 1.5) {
            table.put("Spinner.font", AbstractLookAndFeel.getControlTextFont());
            table.put("Spinner.background", AbstractLookAndFeel.getButtonBackgroundColor());
            table.put("Spinner.foreground", AbstractLookAndFeel.getButtonForegroundColor());
            table.put("Spinner.border", this.getBorderFactory().getSpinnerBorder());
            table.put("Spinner.arrowButtonInsets", (Object)null);
            table.put("Spinner.arrowButtonBorder", BorderFactory.createEmptyBorder());
            table.put("Spinner.editorBorderPainted", Boolean.FALSE);
        }
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                table.put("ScrollBar.width", new Integer(8));
                table.put("SplitPane.dividerSize", new Integer(7));
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                table.put("ScrollBar.width", new Integer(10));
                table.put("SplitPane.dividerSize", new Integer(9));
            } else {
                table.put("ScrollBar.width", new Integer(12));
                table.put("SplitPane.dividerSize", new Integer(11));
            }
        } else if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
            table.put("ScrollBar.width", new Integer(17));
            table.put("SplitPane.dividerSize", new Integer(7));
        } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
            table.put("ScrollBar.width", new Integer(19));
            table.put("SplitPane.dividerSize", new Integer(9));
        } else {
            table.put("ScrollBar.width", new Integer(21));
            table.put("SplitPane.dividerSize", new Integer(11));
        }
    }

    public static void setTheme(AbstractTheme theme) {
        if (theme == null) {
            return;
        }
        MetalLookAndFeel.setCurrentTheme(theme);
        myTheme = theme;
        if (AbstractLookAndFeel.isWindowDecorationOn()) {
            DecorationHelper.decorateWindows(Boolean.TRUE);
        } else {
            DecorationHelper.decorateWindows(Boolean.FALSE);
        }
    }

    public static void setTheme(String name) {
    }

    public static AbstractTheme getTheme() {
        return myTheme;
    }

    public static MetalTheme getCurrentTheme() {
        return myTheme;
    }

    public static List getThemes() {
        ArrayList<String> themes = new ArrayList<String>();
        themes.add(AbstractLookAndFeel.getTheme().getName());
        return themes;
    }

    public static boolean isWindowDecorationOn() {
        return AbstractLookAndFeel.getTheme().isWindowDecorationOn();
    }

    public static ColorUIResource getForegroundColor() {
        return AbstractLookAndFeel.getTheme().getForegroundColor();
    }

    public static ColorUIResource getDisabledForegroundColor() {
        return AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
    }

    public static ColorUIResource getBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getBackgroundColor();
    }

    public static ColorUIResource getAlterBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getAlterBackgroundColor();
    }

    public static ColorUIResource getDisabledBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getDisabledBackgroundColor();
    }

    public static ColorUIResource getInputForegroundColor() {
        return AbstractLookAndFeel.getTheme().getInputForegroundColor();
    }

    public static ColorUIResource getInputBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getInputBackgroundColor();
    }

    public static ColorUIResource getFocusColor() {
        return AbstractLookAndFeel.getTheme().getFocusColor();
    }

    public static ColorUIResource getFocusCellColor() {
        return AbstractLookAndFeel.getTheme().getFocusCellColor();
    }

    public static ColorUIResource getFrameColor() {
        return AbstractLookAndFeel.getTheme().getFrameColor();
    }

    public static ColorUIResource getGridColor() {
        return AbstractLookAndFeel.getTheme().getGridColor();
    }

    public static ColorUIResource getSelectionForegroundColor() {
        return AbstractLookAndFeel.getTheme().getSelectionForegroundColor();
    }

    public static ColorUIResource getSelectionBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
    }

    public static ColorUIResource getButtonForegroundColor() {
        return AbstractLookAndFeel.getTheme().getButtonForegroundColor();
    }

    public static ColorUIResource getButtonBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getButtonBackgroundColor();
    }

    public static ColorUIResource getButtonColorLight() {
        return AbstractLookAndFeel.getTheme().getButtonColorLight();
    }

    public static ColorUIResource getButtonColorDark() {
        return AbstractLookAndFeel.getTheme().getButtonColorDark();
    }

    public static ColorUIResource getControlForegroundColor() {
        return AbstractLookAndFeel.getTheme().getControlForegroundColor();
    }

    public static ColorUIResource getControlBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getControlBackgroundColor();
    }

    public ColorUIResource getControlHighlightColor() {
        return AbstractLookAndFeel.getTheme().getControlHighlightColor();
    }

    public ColorUIResource getControlShadowColor() {
        return AbstractLookAndFeel.getTheme().getControlShadowColor();
    }

    public ColorUIResource getControlDarkShadowColor() {
        return AbstractLookAndFeel.getTheme().getControlDarkShadowColor();
    }

    public static ColorUIResource getControlColorLight() {
        return AbstractLookAndFeel.getTheme().getControlColorLight();
    }

    public static ColorUIResource getControlColorDark() {
        return AbstractLookAndFeel.getTheme().getControlColorDark();
    }

    public static ColorUIResource getWindowTitleForegroundColor() {
        return AbstractLookAndFeel.getTheme().getWindowTitleForegroundColor();
    }

    public static ColorUIResource getWindowTitleBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getWindowTitleBackgroundColor();
    }

    public static ColorUIResource getWindowTitleColorLight() {
        return AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
    }

    public static ColorUIResource getWindowTitleColorDark() {
        return AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
    }

    public static ColorUIResource getWindowBorderColor() {
        return AbstractLookAndFeel.getTheme().getWindowBorderColor();
    }

    public static ColorUIResource getWindowInactiveTitleForegroundColor() {
        return AbstractLookAndFeel.getTheme().getWindowInactiveTitleForegroundColor();
    }

    public static ColorUIResource getWindowInactiveTitleBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getWindowInactiveTitleBackgroundColor();
    }

    public static ColorUIResource getWindowInactiveTitleColorLight() {
        return AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
    }

    public static ColorUIResource getWindowInactiveTitleColorDark() {
        return AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
    }

    public static ColorUIResource getWindowInactiveBorderColor() {
        return AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor();
    }

    public static ColorUIResource getMenuForegroundColor() {
        return AbstractLookAndFeel.getTheme().getMenuForegroundColor();
    }

    public static ColorUIResource getMenuBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getMenuBackgroundColor();
    }

    public static ColorUIResource getMenuSelectionForegroundColor() {
        return AbstractLookAndFeel.getTheme().getMenuSelectionForegroundColor();
    }

    public static ColorUIResource getMenuSelectionBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
    }

    public static ColorUIResource getMenuColorLight() {
        return AbstractLookAndFeel.getTheme().getMenuColorLight();
    }

    public static ColorUIResource getMenuColorDark() {
        return AbstractLookAndFeel.getTheme().getMenuColorDark();
    }

    public static ColorUIResource getToolbarForegroundColor() {
        return AbstractLookAndFeel.getTheme().getToolbarForegroundColor();
    }

    public static ColorUIResource getToolbarBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getToolbarBackgroundColor();
    }

    public static ColorUIResource getToolbarColorLight() {
        return AbstractLookAndFeel.getTheme().getToolbarColorLight();
    }

    public static ColorUIResource getToolbarColorDark() {
        return AbstractLookAndFeel.getTheme().getToolbarColorDark();
    }

    public static ColorUIResource getToolbarDockingColor() {
        return AbstractLookAndFeel.getTheme().getFocusColor();
    }

    public static ColorUIResource getTabAreaBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getTabAreaBackgroundColor();
    }

    public static ColorUIResource getTabSelectionForegroundColor() {
        return AbstractLookAndFeel.getTheme().getTabSelectionForegroundColor();
    }

    public static ColorUIResource getDesktopColor() {
        return AbstractLookAndFeel.getTheme().getDesktopColor();
    }

    public static ColorUIResource getTooltipForegroundColor() {
        return AbstractLookAndFeel.getTheme().getTooltipForegroundColor();
    }

    public static ColorUIResource getTooltipBackgroundColor() {
        return AbstractLookAndFeel.getTheme().getTooltipBackgroundColor();
    }
}

