/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.border.JTBorderFactory;
import com.jtattoo.demo.utils.GridBagHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class WidgetPanel
extends JPanel {
    private JPanel widgetPanel = null;
    private JScrollPane tablePanel = null;
    private JSplitPane splitPane = null;
    private JComboBox addressCombo = null;
    private JTextField firstNameField = null;
    private JTextField lastNameField = null;
    private JTextField streetField = null;
    private JTextField cityField = null;
    private ButtonGroup buttonGroup = null;
    private JRadioButton redButton = null;
    private JRadioButton greenButton = null;
    private JRadioButton blueButton = null;
    private JCheckBox bananaButton = null;
    private JCheckBox burgerButton = null;
    private JCheckBox icecreamButton = null;
    private JButton updateButton = null;
    private JButton insertButton = null;
    private JButton deleteButton = null;
    private JTable table = null;
    private ArrayList colNames = new ArrayList();
    private ArrayList dataList = new ArrayList();
    private boolean initialized = false;

    public WidgetPanel() {
        super(new BorderLayout());
        this.init();
        this.initialized = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.initialized) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (UIManager.getLookAndFeel().getName().equals("Texture")) {
                        WidgetPanel.this.tablePanel.setBorder(BorderFactory.createEmptyBorder());
                    } else {
                        Border border = UIManager.getBorder("ScrollPane.border");
                        WidgetPanel.this.tablePanel.setBorder(border);
                    }
                }
            });
        }
    }

    private void init() {
        this.setName("Form");
        this.initModel();
        this.initControls();
        this.initListeners();
    }

    private void initModel() {
        this.colNames.add("Salutation");
        this.colNames.add("Firstname");
        this.colNames.add("Lastname");
        this.colNames.add("Street");
        this.colNames.add("City");
        this.colNames.add("Male");
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add("Mr.");
        rowData.add("Mad");
        rowData.add("Meier");
        rowData.add("Eastend 17");
        rowData.add("New York");
        rowData.add(Boolean.TRUE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Mrs.");
        rowData.add("Georgia");
        rowData.add("Smith");
        rowData.add("Westend 12");
        rowData.add("New York");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Sir");
        rowData.add("Edward");
        rowData.add("Hillary");
        rowData.add("Parkavenue 1a");
        rowData.add("Los Angeles");
        rowData.add(Boolean.TRUE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Mr.");
        rowData.add("Ronald");
        rowData.add("Mc. Guire");
        rowData.add("13th Street");
        rowData.add("Newmark");
        rowData.add(Boolean.TRUE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Mrs.");
        rowData.add("Martina");
        rowData.add("Diego");
        rowData.add("Block A");
        rowData.add("Westpoint");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Lady");
        rowData.add("Bettina");
        rowData.add("Maradona");
        rowData.add("Eastwoodpark 44");
        rowData.add("Washington");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Herr");
        rowData.add("Albert");
        rowData.add("Dreistein");
        rowData.add("Burgstrasse 22");
        rowData.add("Koeln");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Frau");
        rowData.add("Roberta");
        rowData.add("Robinson");
        rowData.add("Gartenstr. 22");
        rowData.add("Kleinkleckersdorf");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Herr");
        rowData.add("Manfred");
        rowData.add("Mustermann");
        rowData.add("Schlossplatz 22");
        rowData.add("Schwaebisch Gmuend");
        rowData.add(Boolean.TRUE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Herr");
        rowData.add("Norbert");
        rowData.add("Noergler");
        rowData.add("Wallstr 1a");
        rowData.add("Oberammergau");
        rowData.add(Boolean.TRUE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Frau");
        rowData.add("Lischen");
        rowData.add("Mueller");
        rowData.add("Kleintalweg 16");
        rowData.add("Witzenhausen");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
        rowData = new ArrayList();
        rowData.add("Frau");
        rowData.add("Lotte");
        rowData.add("Lustig");
        rowData.add("Preussenalee 1a");
        rowData.add("Krauthausen");
        rowData.add(Boolean.FALSE);
        this.dataList.add(rowData);
    }

    private void initControls() {
        this.widgetPanel = this.createWidgetPanel();
        this.tablePanel = this.createTablePanel();
        this.splitPane = new JSplitPane(0, true, this.widgetPanel, this.tablePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(320);
        this.add((Component)this.splitPane, "Center");
    }

    private void initListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WidgetPanel.this.getRootPane() != null) {
                            WidgetPanel.this.getRootPane().setDefaultButton(WidgetPanel.this.updateButton);
                            WidgetPanel.this.updateButton.invalidate();
                            WidgetPanel.this.updateButton.repaint();
                        }
                    }
                });
            }
        });
    }

    private JPanel createWidgetPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createFormPanel(), "Center");
        panel.add((Component)this.createButtonPanel(), "East");
        return panel;
    }

    private JScrollPane createFormPanel() {
        this.addressCombo = new JComboBox<String>(new String[]{"Mr.", "Mrs.", "Sir", "Lady", "Herr", "Frau"});
        this.firstNameField = new JTextField();
        this.lastNameField = new JTextField();
        this.streetField = new JTextField();
        this.cityField = new JTextField();
        this.cityField.setToolTipText("This is a long tool tip (also known as bubble help)\nfor the city text field.\n\nHere comes some more useless text.");
        JPanel radioPanel = new JPanel(new BorderLayout());
        radioPanel.setBorder(JTBorderFactory.createTitleBorder("favorite color"));
        this.redButton = new JRadioButton("red");
        this.greenButton = new JRadioButton("green");
        this.blueButton = new JRadioButton("blue");
        radioPanel.add((Component)this.redButton, "North");
        radioPanel.add((Component)this.greenButton, "Center");
        radioPanel.add((Component)this.blueButton, "South");
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.redButton);
        this.buttonGroup.add(this.greenButton);
        this.buttonGroup.add(this.blueButton);
        this.redButton.setSelected(true);
        JPanel checkPanel = new JPanel(new BorderLayout());
        checkPanel.setBorder(JTBorderFactory.createTitleBorder("favorite food"));
        this.bananaButton = new JCheckBox("bananas");
        this.burgerButton = new JCheckBox("hamburgers");
        this.icecreamButton = new JCheckBox("icecream");
        checkPanel.add((Component)this.bananaButton, "North");
        checkPanel.add((Component)this.burgerButton, "Center");
        checkPanel.add((Component)this.icecreamButton, "South");
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel topDistPanel = new JPanel();
        JPanel bottomDistPanel = new JPanel();
        GridBagHelper.addComponent(panel, topDistPanel, 0, 0, 1, 1, 0, 0, 0.0, 0.0, 0, 18);
        GridBagHelper.addComponent(panel, new JLabel("Salutation"), 0, 1, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(panel, this.addressCombo, 1, 1, 1, 1, 0, 0, 0.3, 0.0, 2, 18);
        GridBagHelper.addComponent(panel, new JPanel(), 2, 1, 1, 1, 0, 0, 0.7, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, new JLabel("Firstname"), 0, 2, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(panel, this.firstNameField, 1, 2, 3, 1, 0, 0, 1.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, new JLabel("Lastname"), 0, 3, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(panel, this.lastNameField, 1, 3, 3, 1, 0, 0, 1.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, new JLabel("Street"), 0, 4, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(panel, this.streetField, 1, 4, 3, 1, 0, 0, 1.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, new JLabel("City"), 0, 5, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(panel, this.cityField, 1, 5, 3, 1, 0, 0, 1.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, radioPanel, 0, 6, 2, 1, 0, 0, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(panel, checkPanel, 2, 6, 1, 1, 0, 0, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(panel, bottomDistPanel, 0, 10, 1, 1, 0, 0, 0.0, 1.0, 3, 18);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    private JScrollPane createButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.updateButton = new JButton("update");
        this.updateButton.setDefaultCapable(true);
        this.updateButton.setMnemonic(85);
        this.insertButton = new JButton("insert");
        this.insertButton.setMnemonic(73);
        this.deleteButton = new JButton("delete");
        this.deleteButton.setMnemonic(68);
        GridBagHelper.setMinRowHeight(panel, 0, 8);
        GridBagHelper.setMinColWidth(panel, 0, 100);
        GridBagHelper.addComponent(panel, this.updateButton, 0, 1, 1, 1, 0, 0, 1.0, 0.0, 2, 18);
        GridBagHelper.addComponent(panel, this.insertButton, 0, 2, 1, 1, 0, 0, 1.0, 0.0, 2, 18);
        GridBagHelper.addComponent(panel, this.deleteButton, 0, 3, 1, 1, 0, 0, 1.0, 0.0, 2, 18);
        GridBagHelper.addComponent(panel, new JPanel(), 0, 4, 1, 1, 0, 0, 0.0, 1.0, 3, 18);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    private JScrollPane createTablePanel() {
        MyTableModel model = new MyTableModel();
        this.table = new JTable(model);
        TableColumn tableCol = this.table.getColumnModel().getColumn(5);
        tableCol.setCellRenderer(new CheckBoxRenderer());
        tableCol.setPreferredWidth(30);
        return new JScrollPane(this.table);
    }

    class CheckBoxRenderer
    extends DefaultTableCellRenderer {
        CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int col) {
            JCheckBox checkBox = new JCheckBox("");
            checkBox.setOpaque(true);
            checkBox.setForeground(jTable.getForeground());
            checkBox.setBackground(jTable.getBackground());
            checkBox.setHorizontalAlignment(0);
            if (isSelected) {
                checkBox.setForeground(jTable.getSelectionForeground());
                Color bc = new Color(jTable.getSelectionBackground().getRGB());
                checkBox.setBackground(bc);
            }
            if (obj instanceof Boolean) {
                checkBox.setSelected((Boolean)obj);
            }
            return checkBox;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return WidgetPanel.this.colNames.size();
        }

        @Override
        public String getColumnName(int index) {
            return (String)WidgetPanel.this.colNames.get(index);
        }

        @Override
        public int getRowCount() {
            return WidgetPanel.this.dataList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            ArrayList rowData;
            if (rowIndex < WidgetPanel.this.dataList.size() && colIndex < (rowData = (ArrayList)WidgetPanel.this.dataList.get(rowIndex)).size()) {
                return rowData.get(colIndex);
            }
            return "ERROR";
        }
    }
}

