/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.noire.NoireLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ThemeDemo
extends JFrame {
    public static ThemeDemo app = null;
    public JPopupMenu popup = null;

    public ThemeDemo() {
        super("Theme-Demo-App");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("New");
        menu.add(menuItem);
        menuItem = new JMenuItem("Open");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int result = fc.showOpenDialog(app);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menu.add(menuItem);
        menuItem = new JMenuItem("Save as");
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        JTree tree = new JTree();
        tree.expandRow(3);
        tree.expandRow(2);
        tree.expandRow(1);
        JScrollPane westPanel = new JScrollPane(tree);
        JScrollPane formScrollPane = new JScrollPane(this.createFormPanel());
        formScrollPane.setMinimumSize(new Dimension(-1, 80));
        MyTable table = new MyTable(new MyTableModel());
        JScrollPane tableScrollPane = new JScrollPane(table);
        JSplitPane horSplitPane = new JSplitPane(0, true, formScrollPane, tableScrollPane);
        horSplitPane.setDividerLocation(120);
        JSplitPane verSplitPane = new JSplitPane(1, true, westPanel, horSplitPane);
        verSplitPane.setDividerLocation(148);
        contentPanel.add((Component)verSplitPane, "Center");
        this.setContentPane(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setLocation(32, 32);
        this.setSize(600, 400);
        this.setVisible(true);
    }

    private JPanel createFormPanel() {
        JPanel panel = new JPanel(null);
        panel.setPreferredSize(new Dimension(425, 100));
        JLabel firstnameLabel = new JLabel("Firstname");
        firstnameLabel.setBounds(10, 10, 100, 20);
        panel.add(firstnameLabel);
        JTextField firstnameField = new JTextField();
        firstnameField.setBounds(110, 10, 240, 20);
        firstnameField.setText("Donald");
        panel.add(firstnameField);
        JLabel lastnameLabel = new JLabel("Lastname");
        lastnameLabel.setBounds(10, 35, 100, 20);
        lastnameLabel.setEnabled(false);
        panel.add(lastnameLabel);
        JTextField lastnameField = new JTextField();
        lastnameField.setBounds(110, 35, 240, 20);
        lastnameField.setText("Duck");
        lastnameField.setEnabled(false);
        panel.add(lastnameField);
        JButton okButton = new JButton("OK");
        okButton.setBounds(360, 10, 60, 22);
        panel.add(okButton);
        return panel;
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put("logoString", "my company");
            props.put("backgroundPattern", "off");
            props.put("windowTitleForegroundColor", "228 228 255");
            props.put("windowTitleBackgroundColor", "0 0 96");
            props.put("windowTitleColorLight", "0 0 96");
            props.put("windowTitleColorDark", "0 0 64");
            props.put("windowBorderColor", "96 96 64");
            props.put("windowInactiveTitleForegroundColor", "228 228 255");
            props.put("windowInactiveTitleBackgroundColor", "0 0 96");
            props.put("windowInactiveTitleColorLight", "0 0 96");
            props.put("windowInactiveTitleColorDark", "0 0 64");
            props.put("windowInactiveBorderColor", "32 32 128");
            props.put("menuForegroundColor", "228 228 255");
            props.put("menuBackgroundColor", "0 0 64");
            props.put("menuSelectionForegroundColor", "0 0 0");
            props.put("menuSelectionBackgroundColor", "255 192 48");
            props.put("menuColorLight", "32 32 128");
            props.put("menuColorDark", "16 16 96");
            props.put("toolbarColorLight", "32 32 128");
            props.put("toolbarColorDark", "16 16 96");
            props.put("controlForegroundColor", "228 228 255");
            props.put("controlBackgroundColor", "16 16 96");
            props.put("controlColorLight", "16 16 96");
            props.put("controlColorDark", "8 8 64");
            props.put("controlHighlightColor", "32 32 128");
            props.put("controlShadowColor", "16 16 64");
            props.put("controlDarkShadowColor", "8 8 32");
            props.put("buttonForegroundColor", "0 0 32");
            props.put("buttonBackgroundColor", "196 196 196");
            props.put("buttonColorLight", "196 196 240");
            props.put("buttonColorDark", "164 164 228");
            props.put("foregroundColor", "228 228 255");
            props.put("backgroundColor", "0 0 64");
            props.put("backgroundColorLight", "16 16 96");
            props.put("backgroundColorDark", "8 8 64");
            props.put("alterBackgroundColor", "255 0 0");
            props.put("frameColor", "96 96 64");
            props.put("gridColor", "96 96 64");
            props.put("focusCellColor", "240 0 0");
            props.put("disabledForegroundColor", "128 128 164");
            props.put("disabledBackgroundColor", "0 0 72");
            props.put("selectionForegroundColor", "0 0 0");
            props.put("selectionBackgroundColor", "196 148 16");
            props.put("inputForegroundColor", "228 228 255");
            props.put("inputBackgroundColor", "0 0 96");
            props.put("rolloverColor", "240 168 0");
            props.put("rolloverColorLight", "240 168 0");
            props.put("rolloverColorDark", "196 137 0");
            NoireLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.noire.NoireLookAndFeel");
            app = new ThemeDemo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class MyTable
    extends JTable {
        private int rolloverRowIndex;

        public MyTable(TableModel model) {
            super(model);
            this.rolloverRowIndex = -1;
            RolloverListener listener = new RolloverListener();
            this.addMouseMotionListener(listener);
            this.addMouseListener(listener);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            Color foreground = this.getForeground();
            Color background = this.getBackground();
            if (this.isRowSelected(row)) {
                foreground = this.getSelectionForeground();
                background = this.getSelectionBackground();
            } else if (row == this.rolloverRowIndex) {
                background = ColorHelper.brighter(background, 30.0);
            } else if (row % 2 == 0) {
                background = ColorHelper.brighter(background, 10.0);
            }
            c.setForeground(foreground);
            c.setBackground(background);
            return c;
        }

        private class RolloverListener
        extends MouseInputAdapter {
            private RolloverListener() {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyTable.this.rolloverRowIndex = -1;
                MyTable.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = MyTable.this.rowAtPoint(e.getPoint());
                if (row != MyTable.this.rolloverRowIndex) {
                    MyTable.this.rolloverRowIndex = row;
                    MyTable.this.repaint();
                }
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Firstname", "Lastname", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), Boolean.FALSE}, {"Alison", "Huml", "Rowing", new Integer(3), Boolean.TRUE}, {"Kathy", "Walrath", "Knitting", new Integer(2), Boolean.FALSE}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), Boolean.TRUE}, {"Philip", "Milne", "Pool", new Integer(10), Boolean.FALSE}};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

