/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.plaf.ColorHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TablePanel
extends JPanel {
    public TablePanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setName("Table");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        MyTable myTable = new MyTable(new MyTableModel());
        JScrollPane scrollPane = new JScrollPane(myTable);
        this.add((Component)scrollPane, "Center");
        TableColumn tableCol = myTable.getColumnModel().getColumn(2);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("Snowboarding");
        comboBox.addItem("Rowing");
        comboBox.addItem("Chasing toddlers");
        comboBox.addItem("Speed reading");
        comboBox.addItem("Teaching high school");
        comboBox.addItem("None");
        tableCol.setCellEditor(new DefaultCellEditor(comboBox));
        tableCol.setPreferredWidth(200);
        tableCol = myTable.getColumnModel().getColumn(1);
        tableCol.setPreferredWidth(80);
    }

    public class MyTable
    extends JTable {
        private int rolloverRowIndex;

        public MyTable(TableModel model) {
            super(model);
            this.rolloverRowIndex = -1;
            RolloverListener listener = new RolloverListener();
            this.addMouseMotionListener(listener);
            this.addMouseListener(listener);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            Color foreground = this.getForeground();
            Color background = this.getBackground();
            if (this.isRowSelected(row)) {
                foreground = this.getSelectionForeground();
                background = this.getSelectionBackground();
            } else if (row == this.rolloverRowIndex) {
                foreground = this.getSelectionForeground();
                background = ColorHelper.brighter(this.getSelectionBackground(), 40.0);
            } else if (row % 2 == 0) {
                background = ColorHelper.brighter(this.getParent().getBackground(), 20.0);
            }
            c.setForeground(foreground);
            c.setBackground(background);
            return c;
        }

        private class RolloverListener
        extends MouseInputAdapter {
            private RolloverListener() {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyTable.this.rolloverRowIndex = -1;
                MyTable.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = MyTable.this.rowAtPoint(e.getPoint());
                if (row != MyTable.this.rolloverRowIndex) {
                    MyTable.this.rolloverRowIndex = row;
                    MyTable.this.repaint();
                }
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), Boolean.FALSE}, {"Alison", "Huml", "Rowing", new Integer(3), Boolean.TRUE}, {"Kathy", "Walrath", "Knitting", new Integer(2), Boolean.FALSE}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), Boolean.TRUE}, {"Philip", "Milne", "Pool", new Integer(10), Boolean.FALSE}};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

