/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableDemo
extends JFrame {
    public TableDemo() {
        super("Rollover-Table-Demo");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        MyTable myTable = new MyTable(new MyTableModel());
        myTable.setRowHeight(24);
        myTable.setSelectionBackground(Color.orange);
        myTable.setSelectionForeground(Color.black);
        myTable.getSelectionModel().setSelectionInterval(2, 2);
        TableColumn tableCol = myTable.getColumnModel().getColumn(2);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("Snowboarding");
        comboBox.addItem("Rowing");
        comboBox.addItem("Skating");
        comboBox.addItem("Chasing toddlers");
        comboBox.addItem("Speed reading");
        comboBox.addItem("Teaching high school");
        comboBox.addItem("None");
        tableCol.setCellEditor(new DefaultCellEditor(comboBox));
        tableCol.setPreferredWidth(200);
        tableCol = myTable.getColumnModel().getColumn(1);
        tableCol.setPreferredWidth(80);
        contentPanel.add((Component)new JScrollPane(myTable), "Center");
        this.setContentPane(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setLocation(32, 32);
        this.setSize(480, 300);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put("logoString", "my company");
            props.put("textShadow", "off");
            props.put("systemTextFont", "Arial PLAIN 13");
            props.put("controlTextFont", "Arial PLAIN 13");
            props.put("menuTextFont", "Arial PLAIN 13");
            props.put("userTextFont", "Arial PLAIN 13");
            props.put("subTextFont", "Arial PLAIN 12");
            props.put("windowTitleFont", "Arial BOLD 13");
            HiFiLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.hifi.HiFiLookAndFeel");
            new TableDemo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class MyTable
    extends JTable {
        private Color evenBackColor;
        private Color evenTextColor;
        private Color oddBackColor;
        private Color oddTextColor;
        private Color rolloverBackColor;
        private Color rolloverTextColor;
        private int rolloverRowIndex;

        public MyTable(TableModel model) {
            super(model);
            this.evenBackColor = new Color(80, 80, 80);
            this.evenTextColor = Color.white;
            this.oddBackColor = new Color(96, 96, 96);
            this.oddTextColor = Color.white;
            this.rolloverBackColor = new Color(128, 128, 128);
            this.rolloverTextColor = Color.white;
            this.rolloverRowIndex = -1;
            RolloverListener listener = new RolloverListener();
            this.addMouseMotionListener(listener);
            this.addMouseListener(listener);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (this.isRowSelected(row)) {
                c.setForeground(this.getSelectionForeground());
                c.setBackground(this.getSelectionBackground());
            } else if (row == this.rolloverRowIndex) {
                c.setForeground(this.rolloverTextColor);
                c.setBackground(this.rolloverBackColor);
            } else if (row % 2 == 0) {
                c.setForeground(this.evenTextColor);
                c.setBackground(this.evenBackColor);
            } else {
                c.setForeground(this.oddTextColor);
                c.setBackground(this.oddBackColor);
            }
            return c;
        }

        private class RolloverListener
        extends MouseInputAdapter {
            private RolloverListener() {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyTable.this.rolloverRowIndex = -1;
                MyTable.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = MyTable.this.rowAtPoint(e.getPoint());
                if (row != MyTable.this.rolloverRowIndex) {
                    MyTable.this.rolloverRowIndex = row;
                    MyTable.this.repaint();
                }
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), Boolean.FALSE}, {"Alison", "Huml", "Rowing", new Integer(3), Boolean.TRUE}, {"Kathy", "Walrath", "Knitting", new Integer(2), Boolean.FALSE}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), Boolean.TRUE}, {"Mimi", "Koslowski", "Skating", new Integer(7), Boolean.TRUE}, {"August", "Vanderbilt", "Ice hopping", new Integer(2), Boolean.FALSE}, {"Philip", "Milne", "Pool", new Integer(10), Boolean.FALSE}};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

